/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.arrays;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.homelinux.elabor.arrays.Filter;

class FilterIterator<T>
implements Iterator<T> {
    private final Iterator<T> iterator;
    private final Filter<T> filter;
    private T item;

    public FilterIterator(Iterable<T> items, Filter<T> filter) {
        this.filter = filter;
        this.iterator = items.iterator();
        this.step();
    }

    private void step() {
        this.item = null;
        while (this.item == null && this.iterator.hasNext()) {
            T current = this.iterator.next();
            if (!this.filter.check(current)) continue;
            this.item = current;
        }
    }

    @Override
    public boolean hasNext() {
        return this.item != null;
    }

    @Override
    public T next() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        T current = this.item;
        this.step();
        return current;
    }
}

