/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.calendar;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.homelinux.elabor.calendar.DaysOfMonthIterator;
import org.homelinux.elabor.calendar.Giorno;
import org.homelinux.elabor.calendar.Month;

public class MonthArray<T extends Giorno>
extends ArrayList<List<T>> {
    private static final long serialVersionUID = 1L;

    public MonthArray(int anno, Month mese, List<T> values) {
        Iterator<T> valuesIterator = values.iterator();
        T current = this.getNextValue(valuesIterator);
        DaysOfMonthIterator days = new DaysOfMonthIterator(anno, mese);
        while (days.hasNext()) {
            int giorno = days.next();
            ArrayList<T> giornoList = new ArrayList<T>();
            while (current != null && current.getGiorno() == giorno) {
                giornoList.add(current);
                current = this.getNextValue(valuesIterator);
            }
            this.add(giornoList);
        }
    }

    private T getNextValue(Iterator<T> iterator) {
        return (T)(iterator.hasNext() ? (Giorno)iterator.next() : null);
    }
}

