/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.db;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import org.homelinux.elabor.calendar.ElaborCalendar;
import org.homelinux.elabor.db.AnnoMeseCCM;
import org.homelinux.elabor.db.CalendarCreatorManager;
import org.homelinux.elabor.db.MonthCCM;
import org.homelinux.elabor.db.RecordCreator;

public class CalendarCreator
implements RecordCreator<ElaborCalendar> {
    private final CalendarCreatorManager manager;

    public CalendarCreator(String monthName, DateFormat dateFormat) {
        this.manager = new MonthCCM(monthName, dateFormat);
    }

    public CalendarCreator(String annoName, String meseName) {
        this.manager = new AnnoMeseCCM(annoName, meseName);
    }

    @Override
    public ElaborCalendar createRecord(ResultSet rs) throws SQLException {
        Date date;
        try {
            date = this.manager.getDate(rs);
        }
        catch (ParseException exc) {
            throw new RuntimeException(exc);
        }
        return new ElaborCalendar(date);
    }
}

