/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.definers;

import org.homelinux.elabor.scriptorium.definers.Definer;
import org.homelinux.elabor.scriptorium.definers.DefinerStrategy;
import org.homelinux.elabor.scriptorium.definers.InvalidTokenDefinition;
import org.homelinux.elabor.scriptorium.definers.SelectionValidator;
import org.homelinux.elabor.scriptorium.ecomponents.ComponentFactory;
import org.homelinux.elabor.scriptorium.ecomponents.EditionComponent;
import org.homelinux.elabor.scriptorium.gui.Preferences;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumDirector;
import org.homelinux.elabor.tools.MessageCatalog;

public class TokenDefiner<eC extends EditionComponent<?>>
implements Definer<eC> {
    private String checkErrorMessage;
    private ComponentFactory<eC> prototype;
    private ScriptoriumDirector director;
    private DefinerStrategy<eC> definer;
    private SelectionValidator validator;

    public TokenDefiner(ScriptoriumDirector director) {
        this.initLocale();
        this.director = director;
    }

    @Override
    public void setPrototype(ComponentFactory<eC> prototype) {
        this.prototype = prototype;
    }

    @Override
    public void setStrategy(DefinerStrategy<eC> definer) {
        this.definer = definer;
    }

    @Override
    public void setValidator(SelectionValidator validator) {
        this.validator = validator;
    }

    private void initLocale() {
        MessageCatalog catalog = new MessageCatalog();
        String locale = Preferences.getInstance().getProperty("locale");
        catalog.loadCatalog(TokenDefiner.class.getName(), locale);
        this.checkErrorMessage = catalog.translate("checkError");
    }

    @Override
    public boolean validate(int length) {
        return this.validator.validate(length);
    }

    @Override
    public String getCheckErrorMessage() {
        return this.checkErrorMessage;
    }

    @Override
    public eC defineToken(int offset, int length) throws InvalidTokenDefinition {
        return this.definer.defineToken(offset, length, this.director, this.prototype);
    }
}

