/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ecomponents;

import java.util.List;
import org.homelinux.elabor.scriptorium.ecomponents.ComponentFactory;
import org.homelinux.elabor.scriptorium.ecomponents.DescriptionItem;
import org.homelinux.elabor.scriptorium.ecomponents.EditionComposite;
import org.homelinux.elabor.scriptorium.ecomponents.OntologyClass;
import org.homelinux.elabor.scriptorium.ecomponents.OntologyReference;
import org.homelinux.elabor.scriptorium.ecomponents.ValidationException;
import org.homelinux.elabor.scriptorium.ecomponents.VariantItem;
import org.homelinux.elabor.scriptorium.ecomponents.WitnessesIds;
import org.homelinux.elabor.scriptorium.ecomponents.visitors.EditionVisitor;
import org.w3c.dom.Element;

public class Description
extends EditionComposite<Description>
implements ComponentFactory<Description> {
    public Description() {
    }

    public Description(VariantItem parent) {
        super(parent);
    }

    public Description(Element element) {
        super(element);
    }

    public WitnessesIds getWitnessesIds() {
        return this.getFirstNodeByType(new WitnessesIds());
    }

    private WitnessesIds createWitnessesIds() throws ValidationException {
        WitnessesIds wit_ids = new WitnessesIds(this);
        this.addFirstChild(wit_ids);
        return wit_ids;
    }

    public void addWitnessId(String id) throws ValidationException {
        WitnessesIds wit_ids = this.getWitnessesIds();
        if (wit_ids == null) {
            wit_ids = this.createWitnessesIds();
        }
        wit_ids.addWitnessId(id);
    }

    public void removeWitnessId(String id) {
        WitnessesIds wit_ids = this.getWitnessesIds();
        if (wit_ids != null) {
            wit_ids.removeWitnessId(id);
        }
    }

    public List<DescriptionItem> getItems() {
        return this.getNodesByType(new DescriptionItem());
    }

    public void addItem(DescriptionItem item) throws ValidationException {
        this.addChild(item);
    }

    public void removeItem(DescriptionItem item) {
        this.removeChild(item);
    }

    public void replaceItem(DescriptionItem old_item, DescriptionItem new_item) throws ValidationException {
        this.replaceChild(old_item, new_item);
    }

    @Override
    public String toString() {
        String retValue = "";
        WitnessesIds witnesses_ids = this.getWitnessesIds();
        retValue = String.valueOf(retValue) + (witnesses_ids == null ? "" : witnesses_ids.toString());
        List<DescriptionItem> items = this.getItems();
        for (DescriptionItem item : items) {
            retValue = String.valueOf(retValue) + (retValue.length() != 0 ? " " : "") + item.toString();
        }
        return retValue;
    }

    protected boolean referOntology(OntologyClass ontology_class) {
        boolean refer = false;
        for (DescriptionItem item : this.getItems()) {
            OntologyReference reference = item.getOntologyReference();
            if (reference == null || !reference.referOntology(ontology_class)) continue;
            refer = true;
            break;
        }
        return refer;
    }

    @Override
    public void accept(EditionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Description make(Element element) {
        return new Description(element);
    }

    @Override
    public String getElementName() {
        return "description";
    }
}

