/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ecomponents;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.homelinux.elabor.scriptorium.ecomponents.Author;
import org.homelinux.elabor.scriptorium.ecomponents.AuthorPlace;
import org.homelinux.elabor.scriptorium.ecomponents.ComponentFactory;
import org.homelinux.elabor.scriptorium.ecomponents.Conspectus;
import org.homelinux.elabor.scriptorium.ecomponents.DocumentType;
import org.homelinux.elabor.scriptorium.ecomponents.Edition;
import org.homelinux.elabor.scriptorium.ecomponents.EditionComponent;
import org.homelinux.elabor.scriptorium.ecomponents.EditionComposite;
import org.homelinux.elabor.scriptorium.ecomponents.EditionDate;
import org.homelinux.elabor.scriptorium.ecomponents.Identifier;
import org.homelinux.elabor.scriptorium.ecomponents.NullOntologyReference;
import org.homelinux.elabor.scriptorium.ecomponents.OntologyReference;
import org.homelinux.elabor.scriptorium.ecomponents.OntologyReferenceInterface;
import org.homelinux.elabor.scriptorium.ecomponents.OntologyRefererInterface;
import org.homelinux.elabor.scriptorium.ecomponents.Publication;
import org.homelinux.elabor.scriptorium.ecomponents.Receiver;
import org.homelinux.elabor.scriptorium.ecomponents.ReceiverPlace;
import org.homelinux.elabor.scriptorium.ecomponents.References;
import org.homelinux.elabor.scriptorium.ecomponents.Title;
import org.homelinux.elabor.scriptorium.ecomponents.visitors.EditionVisitor;
import org.w3c.dom.Element;

public class Header
extends EditionComposite<Header>
implements ComponentFactory<Header> {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static final String DOCUMENT_TYPE = "document_type";
    private static final String EDITOR = "editor";
    private static final String PUBLICATION_TITLE = "publication_title";
    private static final String PUBLISHER = "publisher";
    private static final String PUBLICATION_YEAR = "publication_year";
    private static final String FOLDER = "folder";
    private static final String AUTHOR_INCERTO = "auth_incerto";
    private static final String RECEIVER_INCERTO = "dest_incerto";
    private static final String DATE_COMMENT = "date_comment";

    public Header() {
    }

    public Header(Edition parent) {
        super(parent);
    }

    public Header(Element element) {
        super(element);
    }

    public void setTitle(String title) {
        Title component = this.getFirstOrAppendNodeByType(new Title());
        component.setValue(title);
    }

    public String getTitle() {
        Title title = this.getFirstOrAppendNodeByType(new Title());
        return title.getValue();
    }

    public void setIdentifier(String identifier) {
        Identifier component = this.getFirstOrAppendNodeByType(new Identifier());
        component.setValue(identifier);
    }

    public String getIdentifier() {
        Identifier identifier = this.getFirstOrAppendNodeByType(new Identifier());
        return identifier.getValue();
    }

    private <eC extends EditionComponent<?>> void removeReferer(eC prototype) {
        eC component = this.getFirstNodeByType(prototype);
        if (component != null) {
            this.removeChild(component);
        }
    }

    private static OntologyReferenceInterface getOntologyReference(OntologyRefererInterface referer) {
        List<OntologyReference> references = referer.getOntologyReferences();
        OntologyReferenceInterface result = references.size() == 0 ? new NullOntologyReference() : (OntologyReferenceInterface)references.get(0);
        return result;
    }

    public void setAuthor(OntologyReference reference) {
        Author component = this.getFirstOrAppendNodeByType(new Author());
        component.setOntologyReference(reference);
    }

    public void removeAuthor() {
        this.removeReferer(new Author());
    }

    public OntologyReferenceInterface getAuthor() {
        Author author = this.getFirstOrAppendNodeByType(new Author());
        return Header.getOntologyReference(author);
    }

    public boolean isAuthorIncerto() {
        return this.getBooleanAttribute(AUTHOR_INCERTO, false);
    }

    public void setAuthorIncerto(boolean incerto) {
        this.setBooleanAttribute(AUTHOR_INCERTO, incerto);
    }

    public boolean isReceiverIncerto() {
        return this.getBooleanAttribute(RECEIVER_INCERTO, false);
    }

    public void setReceiverIncerto(boolean incerto) {
        this.setBooleanAttribute(RECEIVER_INCERTO, incerto);
    }

    public void setAuthorPlace(OntologyReference reference) {
        AuthorPlace component = this.getFirstOrAppendNodeByType(new AuthorPlace());
        component.setOntologyReference(reference);
    }

    public void removeAuthorPlace() {
        this.removeReferer(new AuthorPlace());
    }

    public OntologyReferenceInterface getAuthorPlace() {
        AuthorPlace authorPlace = this.getFirstOrAppendNodeByType(new AuthorPlace());
        return Header.getOntologyReference(authorPlace);
    }

    public void setReceiverPlace(OntologyReference reference) {
        ReceiverPlace component = this.getFirstOrAppendNodeByType(new ReceiverPlace());
        component.setOntologyReference(reference);
    }

    public void removeReceiverPlace() {
        this.removeReferer(new ReceiverPlace());
    }

    public OntologyReferenceInterface getReceiverPlace() {
        ReceiverPlace receiverPlace = this.getFirstOrAppendNodeByType(new ReceiverPlace());
        return Header.getOntologyReference(receiverPlace);
    }

    public void setReceiver(OntologyReference reference) {
        Receiver component = this.getFirstOrAppendNodeByType(new Receiver());
        component.setOntologyReference(reference);
    }

    public OntologyReferenceInterface getReceiver() {
        Receiver receiver = this.getFirstOrAppendNodeByType(new Receiver());
        return Header.getOntologyReference(receiver);
    }

    public void removeReceiver() {
        this.removeReferer(new Receiver());
    }

    public void setPublication(OntologyReference reference) {
        Publication component = this.getFirstOrAppendNodeByType(new Publication());
        component.setOntologyReference(reference);
    }

    public void removePublication() {
        this.removeReferer(new Publication());
    }

    public OntologyReferenceInterface getPublication() {
        Publication publication = this.getFirstOrAppendNodeByType(new Publication());
        return Header.getOntologyReference(publication);
    }

    public void setDate(Date date) {
        EditionDate component = this.getFirstOrAppendNodeByType(new EditionDate());
        component.setValue(DATE_FORMAT.format(date));
    }

    public void removeDate() {
        EditionDate date = this.getFirstNodeByType(new EditionDate());
        if (date != null) {
            this.removeChild(date);
        }
    }

    public Date getDate() {
        Date date;
        EditionDate editionDate = this.getFirstOrAppendNodeByType(new EditionDate());
        String dateString = editionDate.getValue();
        try {
            date = DATE_FORMAT.parse(dateString);
        }
        catch (ParseException exc) {
            date = null;
        }
        return date;
    }

    public void setDateComment(String dateComment) {
        this.setStringAttribute(DATE_COMMENT, dateComment);
    }

    public String getDateComment() {
        return this.getStringAttribute(DATE_COMMENT);
    }

    public String getPlace() {
        return "***";
    }

    public void setDocumentType(DocumentType documentType) {
        String typeString = documentType.toString();
        this.setStringAttribute(DOCUMENT_TYPE, typeString);
    }

    public DocumentType getDocumentType() {
        DocumentType documentType;
        String typeString = this.getStringAttribute(DOCUMENT_TYPE);
        try {
            documentType = DocumentType.valueOf(typeString);
        }
        catch (Exception e) {
            documentType = DocumentType.AUTOGRAPH;
        }
        return documentType;
    }

    public void setEditor(String editor) {
        this.setStringAttribute(EDITOR, editor);
    }

    public String getEditor() {
        return this.getStringAttribute(EDITOR);
    }

    public void setPublicationTitle(String publicationTitle) {
        this.setStringAttribute(PUBLICATION_TITLE, publicationTitle);
    }

    public String getPublicationTitle() {
        return this.getStringAttribute(PUBLICATION_TITLE);
    }

    public void setPublisher(String publisher) {
        this.setStringAttribute(PUBLISHER, publisher);
    }

    public String getPublisher() {
        return this.getStringAttribute(PUBLISHER);
    }

    public void setPublicationYear(String publication_year) {
        this.setStringAttribute(PUBLICATION_YEAR, publication_year);
    }

    public String getPublicationYear() {
        return this.getStringAttribute(PUBLICATION_YEAR);
    }

    public void setFolder(String folder) {
        this.setStringAttribute(FOLDER, folder);
    }

    public String getFolder() {
        return this.getStringAttribute(FOLDER);
    }

    public Conspectus getConspectus() {
        return this.getFirstOrAppendNodeByType(new Conspectus());
    }

    public References getReferences() {
        return this.getFirstOrAppendNodeByType(new References());
    }

    @Override
    public Header make(Element element) {
        return new Header(element);
    }

    @Override
    public String getElementName() {
        return "header";
    }

    @Override
    public void accept(EditionVisitor visitor) {
        visitor.visit(this);
    }
}

