/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ecomponents.drawing;

import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.CharRotationManager;

class ObliqueCRManager
implements CharRotationManager {
    ObliqueCRManager() {
    }

    @Override
    public void drawString(Graphics2D graphics, String string, double x, double y, double theta, double charInterspace) {
        AffineTransform save = graphics.getTransform();
        AffineTransform rot = new AffineTransform(save);
        rot.rotate(theta + 1.5707963267948966, x, y);
        FontMetrics metrics = graphics.getFontMetrics();
        double height = metrics.getAscent() - metrics.getDescent();
        double length = height * (double)string.length() + charInterspace * (double)(string.length() - 1);
        double posX = x - length / 2.0;
        double posY = y;
        int index = 0;
        while (index < string.length()) {
            String substring = string.substring(index, index + 1);
            int width = metrics.stringWidth(substring);
            Point2D.Double charPoint = new Point2D.Double(posX + height / 2.0, posY);
            Point2D trPoint = rot.transform(charPoint, null);
            int xc = (int)trPoint.getX();
            int yc = (int)trPoint.getY();
            AffineTransform charRot = new AffineTransform();
            charRot.rotate(theta, xc, yc);
            graphics.setTransform(charRot);
            graphics.drawString(substring, xc - width / 2, yc + (int)height / 2);
            graphics.setTransform(save);
            posX += height + charInterspace;
            ++index;
        }
    }
}

