/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ecomponents.drawing.points;

import java.awt.geom.Point2D;
import org.homelinux.elabor.scriptorium.ecomponents.ComponentFactory;
import org.homelinux.elabor.scriptorium.ecomponents.EditionComponent;
import org.homelinux.elabor.scriptorium.ecomponents.EditionListener;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.CharRotation;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.ComponentType;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.Glyph;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.AbstractPointReference;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.PointReference;
import org.homelinux.elabor.scriptorium.ecomponents.visitors.EditionVisitor;
import org.homelinux.elabor.scriptorium.ecomponents.visitors.GlyphVisitor;
import org.homelinux.elabor.scriptorium.ndraft.LabeledPoint;
import org.w3c.dom.Element;

public class ScriptoriumPoint
extends AbstractPointReference<ScriptoriumPoint>
implements ComponentFactory<ScriptoriumPoint>,
Glyph,
LabeledPoint {
    private static final long serialVersionUID = 1L;
    private static final String LABEL_ATTRIBUTE = "label";
    private static final String X_ATTRIBUTE = "x";
    private static final String Y_ATTRIBUTE = "y";
    private static final String LABEL_ROTATION = "label_rotation";
    private static final String CHAR_ROTATE = "char_rotate";
    private static final String CHAR_ROTATION = "char_rotation";
    private static final String CHAR_INTERSPACE = "char_interspace";
    private static final String LABEL_LLX = "llx";
    private static final String LABEL_LLY = "lly";
    private static final String LABEL_URX = "urx";
    private static final String LABEL_URY = "ury";
    private static final String POINT_STYLE = "style";
    private static final String VISIBLE = "visibility";
    private static final String SUBID_ATTRIBUTE = "subid";
    private Point2D snap;

    public ScriptoriumPoint() {
        this.snap = null;
    }

    public ScriptoriumPoint(Element element) {
        super(element);
        this.snap = null;
    }

    public ScriptoriumPoint(EditionComponent<?> parent, EditionListener listener) {
        super(parent);
        this.setVisible(true);
        this.setListener(listener);
        this.snap = null;
    }

    public void set(Point2D point) {
        this.setX(point.getX());
        this.setY(point.getY());
    }

    public Point2D getPoint2D() {
        return this.getPoint2D(false);
    }

    public Point2D getPoint2D(boolean orginal) {
        return new Point2D.Double(this.getX(orginal), this.getY(orginal));
    }

    public String getLabel() {
        return this.getStringAttribute(LABEL_ATTRIBUTE);
    }

    public void setLabel(String label) {
        this.setLabel(label, true);
    }

    public void setLabel(String label, boolean notify) {
        this.setStringAttribute(LABEL_ATTRIBUTE, label, notify);
    }

    public void setX(double x) {
        this.setDoubleAttribute(X_ATTRIBUTE, x);
    }

    public void setY(double y) {
        this.setDoubleAttribute(Y_ATTRIBUTE, y);
    }

    public double getX() {
        return this.getX(false);
    }

    public double getX(boolean original) {
        return original || this.snap == null ? this.getDoubleAttribute(X_ATTRIBUTE) : this.snap.getX();
    }

    public double getY() {
        return this.getY(false);
    }

    public double getY(boolean original) {
        return original || this.snap == null ? this.getDoubleAttribute(Y_ATTRIBUTE) : this.snap.getY();
    }

    public void setSnap(double x, double y) {
        this.snap = new Point2D.Double(x, y);
    }

    public void setSnap(Point2D point) {
        this.snap = point;
    }

    public void setLabelRotation(int rotation) {
        this.setIntAttribute(LABEL_ROTATION, rotation);
    }

    public int getLabelRotation() {
        return this.getIntAttribute(LABEL_ROTATION);
    }

    public void setCharRotation(CharRotation charRotation) {
        String stringCharRotation = charRotation.toString();
        this.setStringAttribute(CHAR_ROTATION, stringCharRotation);
    }

    public CharRotation getCharRotation() {
        boolean charRotate;
        String stringCharRotation = this.getStringAttribute(CHAR_ROTATION);
        CharRotation charRotation = stringCharRotation.isEmpty() ? ((charRotate = this.getBooleanAttribute(CHAR_ROTATE, true)) ? CharRotation.NORMAL : CharRotation.VERTICAL) : CharRotation.valueOf(stringCharRotation);
        return charRotation;
    }

    public void setCharInterspace(double charInterspace) {
        this.setDoubleAttribute(CHAR_INTERSPACE, charInterspace);
    }

    public double getCharInterspace() {
        String stringCharInterspace = this.getStringAttribute(CHAR_INTERSPACE);
        double charInterspace = stringCharInterspace.isEmpty() ? 0.0 : Double.parseDouble(stringCharInterspace);
        return charInterspace;
    }

    public Point2D getLowerLeftCorner() {
        return new Point2D.Double(this.getLabelLLCornerX(), this.getLabelLLCornerY());
    }

    public Point2D getUpperRightCorner() {
        return new Point2D.Double(this.getLabelURCornerX(), this.getLabelURCornerY());
    }

    public void setLabelLLCornerX(double llx) {
        this.setDoubleAttribute(LABEL_LLX, llx);
    }

    public void setLabelLLCornerY(double lly) {
        this.setDoubleAttribute(LABEL_LLY, lly);
    }

    public void setLabelURCornerX(double urx) {
        this.setDoubleAttribute(LABEL_URX, urx);
    }

    public void setLabelURCornerY(double ury) {
        this.setDoubleAttribute(LABEL_URY, ury);
    }

    public double getLabelLLCornerX() {
        return this.getDoubleAttribute(LABEL_LLX);
    }

    public double getLabelLLCornerY() {
        return this.getDoubleAttribute(LABEL_LLY);
    }

    public double getLabelURCornerX() {
        return this.getDoubleAttribute(LABEL_URX);
    }

    public double getLabelURCornerY() {
        return this.getDoubleAttribute(LABEL_URY);
    }

    public void setVisible(boolean visible) {
        this.setBooleanAttribute(VISIBLE, visible);
    }

    public boolean isVisible() {
        return this.getBooleanAttribute(VISIBLE, true);
    }

    public void setStyleName(String styleName) {
        this.setStringAttribute(POINT_STYLE, styleName);
    }

    public String getStyleName() {
        return this.getStringAttribute(POINT_STYLE);
    }

    public void setSubId(int id) {
        this.setIntAttribute(SUBID_ATTRIBUTE, id);
    }

    public int getSubId() {
        return this.getIntAttribute(SUBID_ATTRIBUTE);
    }

    public String toString() {
        String id = String.valueOf(this.getId());
        int subid = this.getSubId();
        String label = this.getLabel();
        String coordinates = "(" + this.getX() + "," + this.getY() + ")";
        String text = id;
        if (subid > 0) {
            text = String.valueOf(text) + "->" + subid;
        }
        text = label.isEmpty() ? String.valueOf(text) + coordinates : String.valueOf(text) + "-" + label + coordinates;
        return text;
    }

    @Override
    public void accept(EditionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public ScriptoriumPoint make(Element element) {
        return new ScriptoriumPoint(element);
    }

    @Override
    public String getElementName() {
        return ComponentType.POINT.getName();
    }

    public PointReference getReference() {
        return new PointReference(this, this.getListener());
    }

    @Override
    public void accept(GlyphVisitor visitor) {
        visitor.visit(this);
    }

    public void resetSnap() {
        this.snap = null;
    }

    @Override
    public ScriptoriumPoint getPoint() {
        return this;
    }
}

