/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes;

import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import org.homelinux.elabor.scriptorium.ecomponents.ComponentFactory;
import org.homelinux.elabor.scriptorium.ecomponents.EditionListener;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.ComponentType;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.AbstractShape;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.ScriptoriumShape;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.ShapeVisitor;
import org.homelinux.elabor.tools.MessageCatalog;
import org.w3c.dom.Element;

public class CircleByCenter
extends AbstractShape<CircleByCenter>
implements ComponentFactory<CircleByCenter> {
    private String centerString;
    private String pointString;
    private String[] pointNames;
    private static final String RADIUS = "radius";
    private static final String CENTER_Y = "center_y";
    private static final String CENTER_X = "center_x";

    public CircleByCenter() {
        this.initLocale();
    }

    public CircleByCenter(ScriptoriumShape parent, EditionListener listener) {
        super(parent, listener);
        this.initLocale();
    }

    public CircleByCenter(Element element) {
        super(element);
        this.initLocale();
    }

    private void initLocale() {
        MessageCatalog catalog = new MessageCatalog();
        catalog.loadCatalog(this.getClass().getName());
        this.centerString = catalog.translate("center");
        this.pointString = catalog.translate("point");
        this.pointNames = new String[]{this.centerString, this.pointString};
    }

    @Override
    public int getNeededNumberOfPoints() {
        return this.pointNames.length;
    }

    @Override
    public String getPointName(int position) {
        return this.pointNames[position];
    }

    @Override
    public Shape getShape(Point2D[] points) {
        Ellipse2D.Double circle = new Ellipse2D.Double();
        double radius = points[0].distance(points[1]);
        circle.setFrameFromCenter(points[0].getX(), points[0].getY(), points[0].getX() + radius, points[0].getY() + radius);
        this.setComputedAttributes(points[0].getX(), points[0].getY(), radius);
        return circle;
    }

    private void setComputedAttributes(double xc, double yc, double radius) {
        this.setDoubleAttribute(CENTER_X, xc);
        this.setDoubleAttribute(CENTER_Y, yc);
        this.setDoubleAttribute(RADIUS, radius);
    }

    @Override
    public String getElementName() {
        return ComponentType.CIRCLE_BY_CENTER.getName();
    }

    @Override
    public CircleByCenter make(Element element) {
        return new CircleByCenter(element);
    }

    @Override
    public void accept(ShapeVisitor visitor) {
        visitor.visit(this);
    }
}

