/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.homelinux.elabor.scriptorium.ecomponents.ComponentFactory;
import org.homelinux.elabor.scriptorium.ecomponents.EditionListener;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.ComponentType;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.AbstractShape;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.Equation;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.ScriptoriumShape;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.ShapeVisitor;
import org.homelinux.elabor.scriptorium.gui.drawings.GeometricHelper;
import org.homelinux.elabor.tools.MessageCatalog;
import org.w3c.dom.Element;

public class EllipseByPoints
extends AbstractShape<EllipseByPoints>
implements ComponentFactory<EllipseByPoints> {
    private String pointString;
    private static final String RADIUS = "radius";
    private static final String CENTER_Y = "center_y";
    private static final String CENTER_X = "center_x";
    private static final String CIRCLE = "circle";
    private static final String ARC_ONLY = "arc_only";
    private static final String FIRST_FOCUS_X = "focus1_x";
    private static final String FIRST_FOCUS_Y = "focus1_y";
    private static final String SECOND_FOCUS_X = "focus2_x";
    private static final String SECOND_FOCUS_Y = "focus2_y";
    private static final String SEMIMAJOR_AXIS = "semimajor_axis";
    private static final String SEMIMINOR_AXIS = "semiminor_axis";

    public EllipseByPoints() {
        this.initLocale();
    }

    public EllipseByPoints(Element element) {
        super(element);
        this.initLocale();
    }

    public EllipseByPoints(ScriptoriumShape parent, EditionListener listener) {
        super(parent, listener);
        this.initLocale();
    }

    private void initLocale() {
        MessageCatalog catalog = new MessageCatalog();
        catalog.loadCatalog(this.getClass().getName());
        this.pointString = catalog.translate("point");
    }

    @Override
    public int getNeededNumberOfPoints() {
        return 2;
    }

    @Override
    public boolean canAddPoint() {
        return true;
    }

    @Override
    public String getPointName(int position) {
        return this.pointString;
    }

    @Override
    public Shape getShape(Point2D[] points) {
        Shape shape = points.length == 2 ? this.getCircleByDiameter(points) : (this.isCircle() ? this.getCircleByPoints(points) : this.getEllipseByPoints(points));
        return shape;
    }

    private Shape getEllipseByPoints(Point2D[] points) {
        Shape shape;
        Equation equation = GeometricHelper.computeApproxEquation(points);
        if (equation.isEllipse()) {
            boolean arcOnly = this.isArcOnly();
            try {
                shape = GeometricHelper.buildConic(equation, arcOnly, points[0], points[points.length - 1], points);
            }
            catch (NoninvertibleTransformException exc) {
                shape = this.getCircleByPoints(points);
            }
            this.computeEllipseAttributes(equation);
        } else {
            shape = this.getCircleByPoints(points);
        }
        return shape;
    }

    private void computeEllipseAttributes(Equation equation) {
        double semiMajor = equation.getSemiMajor();
        double semiMinor = equation.getSemiMinor();
        double C = Math.sqrt(semiMajor * semiMajor - semiMinor * semiMinor);
        Point2D.Double f1 = new Point2D.Double(-C, 0.0);
        Point2D.Double f2 = new Point2D.Double(C, 0.0);
        AffineTransform transform = new AffineTransform();
        double xc = equation.getXc();
        double yc = equation.getYc();
        double alpha = equation.getAlpha();
        transform.translate(xc, yc);
        transform.rotate(alpha);
        Point2D tf1 = transform.transform(f1, null);
        Point2D tf2 = transform.transform(f2, null);
        this.setEllipseComputedAttributes(tf1.getX(), tf1.getY(), tf2.getX(), tf2.getY(), semiMajor, semiMinor);
    }

    private Shape getCircleByPoints(Point2D[] points) {
        Shape shape;
        try {
            Array2DRowRealMatrix A = new Array2DRowRealMatrix(3, 3);
            ArrayRealVector B = new ArrayRealVector(3);
            double x2 = 0.0;
            double y2 = 0.0;
            double xy = 0.0;
            double x = 0.0;
            double y = 0.0;
            double x3 = 0.0;
            double y3 = 0.0;
            double xy2 = 0.0;
            double x2y = 0.0;
            Point2D[] point2DArray = points;
            int n = points.length;
            int n2 = 0;
            while (n2 < n) {
                Point2D point = point2DArray[n2];
                x2 += point.getX() * point.getX();
                xy += point.getX() * point.getY();
                y2 += point.getY() * point.getY();
                x += point.getX();
                y += point.getY();
                x3 += point.getX() * point.getX() * point.getX();
                y3 += point.getY() * point.getY() * point.getY();
                xy2 += point.getX() * point.getY() * point.getY();
                x2y += point.getX() * point.getX() * point.getY();
                ++n2;
            }
            A.setEntry(0, 0, x2);
            A.setEntry(0, 1, xy);
            A.setEntry(0, 2, x);
            B.setEntry(0, -x3 - xy2);
            A.setEntry(1, 0, xy);
            A.setEntry(1, 1, y2);
            A.setEntry(1, 2, y);
            B.setEntry(1, -x2y - y3);
            A.setEntry(2, 0, x);
            A.setEntry(2, 1, y);
            A.setEntry(2, 2, (double)points.length);
            B.setEntry(2, -x2 - y2);
            DecompositionSolver solver = new LUDecomposition((RealMatrix)A).getSolver();
            RealVector X = solver.solve((RealVector)B);
            double xc = -X.getEntry(0) / 2.0;
            double yc = -X.getEntry(1) / 2.0;
            double r = Math.sqrt(Math.pow(xc, 2.0) + Math.pow(yc, 2.0) - X.getEntry(2));
            Arc2D.Double circle = new Arc2D.Double();
            circle.setFrameFromCenter(xc, yc, xc + r, yc + r);
            if (this.isArcOnly()) {
                circle.setAngles(points[0], points[points.length - 1]);
            } else {
                ((Arc2D)circle).setAngleExtent(360.0);
            }
            this.setCircleComputedAttributes(xc, yc, r);
            shape = circle;
        }
        catch (RuntimeException exc) {
            shape = new Line2D.Double(Math.max(points[0].getX(), Math.max(points[1].getX(), points[2].getX())), Math.max(points[0].getY(), Math.max(points[1].getY(), points[2].getY())), Math.min(points[0].getX(), Math.min(points[1].getX(), points[2].getX())), Math.min(points[0].getY(), Math.min(points[1].getY(), points[2].getY())));
        }
        return shape;
    }

    private Shape getCircleByDiameter(Point2D[] points) {
        double centerX = (points[0].getX() + points[1].getX()) / 2.0;
        double centerY = (points[0].getY() + points[1].getY()) / 2.0;
        Arc2D.Double circle = new Arc2D.Double();
        double radius = points[0].distance(points[1]) / 2.0;
        circle.setFrameFromCenter(centerX, centerY, centerX + radius, centerY + radius);
        if (this.isArcOnly()) {
            circle.setAngles(points[0], points[1]);
        } else {
            ((Arc2D)circle).setAngleExtent(360.0);
        }
        this.setCircleComputedAttributes(centerX, centerY, radius);
        return circle;
    }

    private void setCircleComputedAttributes(double xc, double yc, double radius) {
        this.removeAttribute(FIRST_FOCUS_X);
        this.removeAttribute(FIRST_FOCUS_Y);
        this.removeAttribute(SECOND_FOCUS_X);
        this.removeAttribute(SECOND_FOCUS_Y);
        this.removeAttribute(SEMIMAJOR_AXIS);
        this.removeAttribute(SEMIMINOR_AXIS);
        this.setDoubleAttribute(CENTER_X, xc);
        this.setDoubleAttribute(CENTER_Y, yc);
        this.setDoubleAttribute(RADIUS, radius);
    }

    private void setEllipseComputedAttributes(double xf1, double yf1, double xf2, double yf2, double semiMajor, double semiMinor) {
        this.removeAttribute(CENTER_X);
        this.removeAttribute(CENTER_Y);
        this.removeAttribute(RADIUS);
        this.setDoubleAttribute(FIRST_FOCUS_X, xf1);
        this.setDoubleAttribute(FIRST_FOCUS_Y, yf1);
        this.setDoubleAttribute(SECOND_FOCUS_X, xf2);
        this.setDoubleAttribute(SECOND_FOCUS_Y, yf2);
        this.setDoubleAttribute(SEMIMAJOR_AXIS, semiMajor);
        this.setDoubleAttribute(SEMIMINOR_AXIS, semiMinor);
    }

    @Override
    public String getElementName() {
        return ComponentType.ELLIPSE_BY_POINTS.getName();
    }

    public void setCircle(boolean circle) {
        this.setBooleanAttribute(CIRCLE, circle);
    }

    public boolean isCircle() {
        return this.getBooleanAttribute(CIRCLE, false);
    }

    public void setArcOnly(boolean arc_only) {
        this.setBooleanAttribute(ARC_ONLY, arc_only);
    }

    public boolean isArcOnly() {
        return this.getBooleanAttribute(ARC_ONLY, false);
    }

    @Override
    public EllipseByPoints make(Element element) {
        return new EllipseByPoints(element);
    }

    @Override
    public void accept(ShapeVisitor visitor) {
        visitor.visit(this);
    }

    public Point2D getFirstFocus() {
        double x = this.getDoubleAttribute(FIRST_FOCUS_X);
        double y = this.getDoubleAttribute(FIRST_FOCUS_Y);
        return new Point2D.Double(x, y);
    }

    public Point2D getSecondFocus() {
        double x = this.getDoubleAttribute(SECOND_FOCUS_X);
        double y = this.getDoubleAttribute(SECOND_FOCUS_Y);
        return new Point2D.Double(x, y);
    }

    public Point2D getCenter() {
        double x = this.getDoubleAttribute(CENTER_X);
        double y = this.getDoubleAttribute(CENTER_Y);
        return new Point2D.Double(x, y);
    }

    public double getRadius() {
        return this.getDoubleAttribute(RADIUS);
    }

    public double getSemiMajorAxis() {
        return this.getDoubleAttribute(SEMIMAJOR_AXIS);
    }

    public double getSemiMinorAxis() {
        return this.getDoubleAttribute(SEMIMINOR_AXIS);
    }
}

