/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ecomponents.drawing.styles;

import java.awt.Color;
import java.io.File;
import java.util.List;
import org.homelinux.elabor.scriptorium.ecomponents.ComponentFactory;
import org.homelinux.elabor.scriptorium.ecomponents.EditionComponent;
import org.homelinux.elabor.scriptorium.ecomponents.EditionComposite;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.styles.ScriptoriumStyle;
import org.homelinux.elabor.scriptorium.ecomponents.visitors.EditionVisitor;
import org.homelinux.elabor.scriptorium.gui.drawings.styles.DefaultStroke;
import org.w3c.dom.Element;

public class StyleSet
extends EditionComposite<StyleSet>
implements ComponentFactory<StyleSet> {
    private File file;

    public StyleSet() {
    }

    public StyleSet(Element element) {
        super(element);
    }

    public StyleSet(EditionComponent<?> parent) {
        super(parent);
    }

    @Override
    public String getElementName() {
        return "styleset";
    }

    @Override
    public void accept(EditionVisitor visitor) {
    }

    @Override
    public StyleSet make(Element element) {
        return new StyleSet(element);
    }

    public void addStyle(ScriptoriumStyle style) {
        this.addChildNoCheck(style);
    }

    public void removeStyle(ScriptoriumStyle style) {
        if (style != null) {
            this.removeChild(style);
        }
    }

    public void replaceStyle(ScriptoriumStyle style) {
        ScriptoriumStyle found;
        if (style != null && (found = this.getStyle(style.getName())) != null) {
            Color labelColor = style.getLabelColor();
            int labelFontSize = style.getLabelFontSize();
            int pointSize = style.getPointSize();
            DefaultStroke stroke = style.getStroke();
            Color elementColor = style.getElementColor(false);
            found.setElementColor(elementColor, false);
            Color elementOrigColor = style.getElementColor(true);
            found.setElementColor(elementOrigColor, true);
            found.setLabelColor(labelColor);
            found.setLabelFontSize(labelFontSize);
            found.setPointSize(pointSize);
            found.setStroke(stroke);
            Color fillColor = style.getFillColor(false);
            found.setFillColor(fillColor, false);
            Color fillOrigColor = style.getFillColor(true);
            found.setFillColor(fillOrigColor, true);
        }
    }

    public List<ScriptoriumStyle> getStyles() {
        return this.getNodesByType(new ScriptoriumStyle());
    }

    public ScriptoriumStyle getStyle(String name) {
        ScriptoriumStyle style = null;
        for (ScriptoriumStyle current : this.getStyles()) {
            if (!current.getName().equals(name)) continue;
            style = current;
            break;
        }
        return style;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }
}

