/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ecomponents.old;

import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.homelinux.elabor.scriptorium.ecomponents.ComponentFactory;
import org.homelinux.elabor.scriptorium.ecomponents.EditionListener;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.ComponentType;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.AbstractShape;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.ScriptoriumShape;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.ShapeVisitor;
import org.w3c.dom.Element;

public class CircleByApproximation
extends AbstractShape<CircleByApproximation>
implements ComponentFactory<CircleByApproximation> {
    private static final String RADIUS = "radius";
    private static final String CENTER_Y = "center_y";
    private static final String CENTER_X = "center_x";
    private static final String APPROXPOINT = "approx. p.";

    public CircleByApproximation() {
    }

    public CircleByApproximation(ScriptoriumShape parent, EditionListener listener) {
        super(parent, listener);
    }

    public CircleByApproximation(Element element) {
        super(element);
    }

    @Override
    public boolean canAddPoint() {
        return true;
    }

    @Override
    public int getNeededNumberOfPoints() {
        return 3;
    }

    @Override
    public String getPointName(int position) {
        return APPROXPOINT;
    }

    @Override
    public Shape getShape(Point2D[] points) {
        Shape shape;
        Array2DRowRealMatrix A = new Array2DRowRealMatrix(3, 3);
        ArrayRealVector B = new ArrayRealVector(3);
        double x2 = 0.0;
        double y2 = 0.0;
        double xy = 0.0;
        double x = 0.0;
        double y = 0.0;
        double x3 = 0.0;
        double y3 = 0.0;
        double xy2 = 0.0;
        double x2y = 0.0;
        Point2D[] point2DArray = points;
        int n = points.length;
        int n2 = 0;
        while (n2 < n) {
            Point2D point = point2DArray[n2];
            x2 += point.getX() * point.getX();
            xy += point.getX() * point.getY();
            y2 += point.getY() * point.getY();
            x += point.getX();
            y += point.getY();
            x3 += point.getX() * point.getX() * point.getX();
            y3 += point.getY() * point.getY() * point.getY();
            xy2 += point.getX() * point.getY() * point.getY();
            x2y += point.getX() * point.getX() * point.getY();
            ++n2;
        }
        A.setEntry(0, 0, x2);
        A.setEntry(0, 1, xy);
        A.setEntry(0, 2, x);
        B.setEntry(0, -x3 - xy2);
        A.setEntry(1, 0, xy);
        A.setEntry(1, 1, y2);
        A.setEntry(1, 2, y);
        B.setEntry(1, -x2y - y3);
        A.setEntry(2, 0, x);
        A.setEntry(2, 1, y);
        A.setEntry(2, 2, (double)points.length);
        B.setEntry(2, -x2 - y2);
        try {
            DecompositionSolver solver = new LUDecomposition((RealMatrix)A).getSolver();
            RealVector X = solver.solve((RealVector)B);
            double xc = -X.getEntry(0) / 2.0;
            double yc = -X.getEntry(1) / 2.0;
            double radius = Math.sqrt(Math.pow(xc, 2.0) + Math.pow(yc, 2.0) - X.getEntry(2));
            Ellipse2D.Double circle = new Ellipse2D.Double();
            circle.setFrameFromCenter(xc, yc, xc + radius, yc + radius);
            shape = circle;
            this.setComputedAttributes(xc, yc, radius);
        }
        catch (RuntimeException exc) {
            shape = new Line2D.Double(Math.max(points[0].getX(), Math.max(points[1].getX(), points[2].getX())), Math.max(points[0].getY(), Math.max(points[1].getY(), points[2].getY())), Math.min(points[0].getX(), Math.min(points[1].getX(), points[2].getX())), Math.min(points[0].getY(), Math.min(points[1].getY(), points[2].getY())));
        }
        return shape;
    }

    private void setComputedAttributes(double xc, double yc, double radius) {
        this.setDoubleAttribute(CENTER_X, xc);
        this.setDoubleAttribute(CENTER_Y, yc);
        this.setDoubleAttribute(RADIUS, radius);
    }

    @Override
    public String getElementName() {
        return ComponentType.CIRCLE_BY_APPROXIMATION.getName();
    }

    @Override
    public CircleByApproximation make(Element element) {
        return new CircleByApproximation(element);
    }

    @Override
    public void accept(ShapeVisitor visitor) {
        visitor.visit(this);
    }
}

