/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ecomponents.old;

import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.homelinux.elabor.scriptorium.ecomponents.ComponentFactory;
import org.homelinux.elabor.scriptorium.ecomponents.EditionListener;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.ComponentType;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.AbstractShape;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.ScriptoriumShape;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.ShapeVisitor;
import org.w3c.dom.Element;

public class CircleByPoints
extends AbstractShape<CircleByPoints>
implements ComponentFactory<CircleByPoints> {
    private static final String[] POINTNAMES = new String[]{"1st p.", "2nd p.", "3rd p."};

    public CircleByPoints() {
    }

    public CircleByPoints(ScriptoriumShape parent, EditionListener listener) {
        super(parent, listener);
    }

    public CircleByPoints(Element element) {
        super(element);
    }

    @Override
    public int getNeededNumberOfPoints() {
        return POINTNAMES.length;
    }

    @Override
    public String getPointName(int position) {
        return POINTNAMES[position];
    }

    @Override
    public Shape getShape(Point2D[] p) {
        Shape shape;
        try {
            Array2DRowRealMatrix A = new Array2DRowRealMatrix(3, 3);
            ArrayRealVector B = new ArrayRealVector(3);
            int i = 0;
            while (i < 3) {
                A.setEntry(i, 0, p[i].getX());
                A.setEntry(i, 1, p[i].getY());
                A.setEntry(i, 2, 1.0);
                B.setEntry(i, -Math.pow(p[i].getX(), 2.0) - Math.pow(p[i].getY(), 2.0));
                ++i;
            }
            DecompositionSolver solver = new LUDecomposition((RealMatrix)A).getSolver();
            RealVector X = solver.solve((RealVector)B);
            double xc = -X.getEntry(0) / 2.0;
            double yc = -X.getEntry(1) / 2.0;
            double r = Math.sqrt(Math.pow(xc, 2.0) + Math.pow(yc, 2.0) - X.getEntry(2));
            Ellipse2D.Double circle = new Ellipse2D.Double();
            circle.setFrameFromCenter(xc, yc, xc + r, yc + r);
            shape = circle;
        }
        catch (RuntimeException exc) {
            shape = new Line2D.Double(Math.max(p[0].getX(), Math.max(p[1].getX(), p[2].getX())), Math.max(p[0].getY(), Math.max(p[1].getY(), p[2].getY())), Math.min(p[0].getX(), Math.min(p[1].getX(), p[2].getX())), Math.min(p[0].getY(), Math.min(p[1].getY(), p[2].getY())));
        }
        return shape;
    }

    @Override
    public String getElementName() {
        return ComponentType.CIRCLE_BY_POINTS.getName();
    }

    @Override
    public CircleByPoints make(Element element) {
        return new CircleByPoints(element);
    }

    @Override
    public void accept(ShapeVisitor visitor) {
        visitor.visit(this);
    }
}

