/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui;

import java.awt.Color;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.im.InputContext;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.Caret;
import javax.xml.parsers.ParserConfigurationException;
import org.homelinux.elabor.scriptorium.definers.Definer;
import org.homelinux.elabor.scriptorium.definers.DefinersFactory;
import org.homelinux.elabor.scriptorium.ecomponents.AbstractValuedLeaf;
import org.homelinux.elabor.scriptorium.ecomponents.Annotation;
import org.homelinux.elabor.scriptorium.ecomponents.Citation;
import org.homelinux.elabor.scriptorium.ecomponents.Comment;
import org.homelinux.elabor.scriptorium.ecomponents.Conspectus;
import org.homelinux.elabor.scriptorium.ecomponents.Crux;
import org.homelinux.elabor.scriptorium.ecomponents.DateToken;
import org.homelinux.elabor.scriptorium.ecomponents.Edition;
import org.homelinux.elabor.scriptorium.ecomponents.EditionComponent;
import org.homelinux.elabor.scriptorium.ecomponents.EditionComposite;
import org.homelinux.elabor.scriptorium.ecomponents.EditionMapper;
import org.homelinux.elabor.scriptorium.ecomponents.Enunciatio;
import org.homelinux.elabor.scriptorium.ecomponents.Expunctio;
import org.homelinux.elabor.scriptorium.ecomponents.Folium;
import org.homelinux.elabor.scriptorium.ecomponents.Formula;
import org.homelinux.elabor.scriptorium.ecomponents.Header;
import org.homelinux.elabor.scriptorium.ecomponents.Image;
import org.homelinux.elabor.scriptorium.ecomponents.Integratio;
import org.homelinux.elabor.scriptorium.ecomponents.ListItem;
import org.homelinux.elabor.scriptorium.ecomponents.MathConcept;
import org.homelinux.elabor.scriptorium.ecomponents.Name;
import org.homelinux.elabor.scriptorium.ecomponents.Ontology;
import org.homelinux.elabor.scriptorium.ecomponents.Place;
import org.homelinux.elabor.scriptorium.ecomponents.TextPart;
import org.homelinux.elabor.scriptorium.ecomponents.Tongue;
import org.homelinux.elabor.scriptorium.ecomponents.Unit;
import org.homelinux.elabor.scriptorium.ecomponents.ValuedComposite;
import org.homelinux.elabor.scriptorium.ecomponents.Variant;
import org.homelinux.elabor.scriptorium.ecomponents.Witness;
import org.homelinux.elabor.scriptorium.ecomponents.Work;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.Drawing;
import org.homelinux.elabor.scriptorium.ecomponents.visitors.EditionUpgrade;
import org.homelinux.elabor.scriptorium.exports.ScriptoriumExport;
import org.homelinux.elabor.scriptorium.gui.ComponentObserver;
import org.homelinux.elabor.scriptorium.gui.ConspectusPanel;
import org.homelinux.elabor.scriptorium.gui.EditionComponentFrame;
import org.homelinux.elabor.scriptorium.gui.EnunciationesPanel;
import org.homelinux.elabor.scriptorium.gui.FindFrame;
import org.homelinux.elabor.scriptorium.gui.OpenFrameVisitor;
import org.homelinux.elabor.scriptorium.gui.Preferences;
import org.homelinux.elabor.scriptorium.gui.ReferencesFrame;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumDirector;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumSelector;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumStyledDocument;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumTextPane;
import org.homelinux.elabor.scriptorium.gui.TextPanel;
import org.homelinux.elabor.scriptorium.gui.VariantsPanel;
import org.homelinux.elabor.scriptorium.gui.WindowsFactory;
import org.homelinux.elabor.scriptorium.gui.annotations.AnnotationsPanel;
import org.homelinux.elabor.scriptorium.gui.citations.CitationsPanel;
import org.homelinux.elabor.scriptorium.gui.comments.CommentsPanel;
import org.homelinux.elabor.scriptorium.gui.cruces.CrucesPanel;
import org.homelinux.elabor.scriptorium.gui.datetokens.DateTokensPanel;
import org.homelinux.elabor.scriptorium.gui.drawings.DraftExportDirectorFactory;
import org.homelinux.elabor.scriptorium.gui.drawings.DrawingFrame;
import org.homelinux.elabor.scriptorium.gui.drawings.DrawingsPanel;
import org.homelinux.elabor.scriptorium.gui.expunctiones.ExpunctionesPanel;
import org.homelinux.elabor.scriptorium.gui.folia.FoliaPanel;
import org.homelinux.elabor.scriptorium.gui.images.ImagesPanel;
import org.homelinux.elabor.scriptorium.gui.integrationes.IntegrationesPanel;
import org.homelinux.elabor.scriptorium.gui.mathconcepts.MathConceptsPanel;
import org.homelinux.elabor.scriptorium.gui.metadata.MetadataFrame;
import org.homelinux.elabor.scriptorium.gui.metadata.MetadataPanel;
import org.homelinux.elabor.scriptorium.gui.metadata.MetadataSummaryPanel;
import org.homelinux.elabor.scriptorium.gui.names.NamesPanel;
import org.homelinux.elabor.scriptorium.gui.parts.TextPartsPanel;
import org.homelinux.elabor.scriptorium.gui.places.PlacesPanel;
import org.homelinux.elabor.scriptorium.gui.tongues.TonguesPanel;
import org.homelinux.elabor.scriptorium.gui.units.UnitsPanel;
import org.homelinux.elabor.scriptorium.gui.variants.VariantPanel;
import org.homelinux.elabor.scriptorium.gui.works.WorksPanel;
import org.homelinux.elabor.scriptorium.services.EditionManager;
import org.homelinux.elabor.scriptorium.services.Finder;
import org.homelinux.elabor.tools.MessageCatalog;
import org.homelinux.elabor.ui.UIConstants;
import org.homelinux.elabor.ui.UITools;
import org.xml.sax.SAXException;

public class IDE
extends JFrame
implements ScriptoriumDirector,
ActionListener {
    public static final long serialVersionUID = 1L;
    private static final Locale GREEK_LOCALE = new Locale("el", "", "org.homelinux.elabor.scriptorium");
    private EditionMapper mapper;
    private Finder finder;
    private EditionComponentFrame<Image, ImagesPanel> imagesFrame;
    private EditionComponentFrame<Annotation, AnnotationsPanel> annotationsFrame;
    private EditionComponentFrame<Citation, CitationsPanel> citationsFrame;
    private EditionComponentFrame<Comment, CommentsPanel> commentsFrame;
    private EditionComponentFrame<Witness, ConspectusPanel> conspectusFrame;
    private EditionComponentFrame<Crux, CrucesPanel> crucesFrame;
    private EditionComponentFrame<Enunciatio, EnunciationesPanel> enunciationesFrame;
    private EditionComponentFrame<Expunctio, ExpunctionesPanel> expunctionesFrame;
    private EditionComponentFrame<DateToken, DateTokensPanel> dateTokensFrame;
    private EditionComponentFrame<Drawing, DrawingsPanel> drawingsFrame;
    private EditionComponentFrame<Folium, FoliaPanel> foliaFrame;
    private EditionComponentFrame<Integratio, IntegrationesPanel> integrationesFrame;
    private EditionComponentFrame<MathConcept, MathConceptsPanel> mathConceptsFrame;
    private EditionComponentFrame<Place, PlacesPanel> placesFrame;
    private EditionComponentFrame<Work, WorksPanel> worksFrame;
    private EditionComponentFrame<Tongue, TonguesPanel> tonguesFrame;
    private EditionComponentFrame<TextPart, TextPartsPanel> textPartsFrame;
    private EditionComponentFrame<Name, NamesPanel> namesFrame;
    private EditionComponentFrame<Unit, UnitsPanel> unitsFrame;
    private DrawingFrame drawingFrame;
    private FindFrame findFrame;
    private MetadataFrame metadataFrame;
    private ReferencesFrame referencesFrame;
    private TextPanel textPanel;
    private VariantsPanel variants_panel;
    private MetadataSummaryPanel metadataSummaryPanel;
    private JMenuItem newJMI;
    private JMenuItem openJMI;
    private JMenuItem saveJMI;
    private JMenuItem nameJMI;
    private JMenuItem importJMI;
    private JMenuItem lockJMI;
    private JMenuItem unlockJMI;
    private JMenuItem exportHtmlJMI;
    private JMenuItem exportTxtJMI;
    private JMenuItem exportLatexJMI;
    private JMenuItem closeJMI;
    private JMenuItem cutJMI;
    private JMenuItem copyJMI;
    private JMenuItem pasteJMI;
    private JMenuItem deleteJMI;
    private JMenuItem findJMI;
    private JMenuItem findNextJMI;
    private JRadioButtonMenuItem latinJMI;
    private JRadioButtonMenuItem greekJMI;
    private JMenuItem metadataJMI;
    private JMenuItem witnessesJMI;
    private JMenuItem referencesJMI;
    private JMenuItem defineFormulaJMI;
    private JMenuItem defineVariantJMI;
    private JMenuItem insertFoliumJMI;
    private JMenuItem insertDrawingJMI;
    private JMenuItem foliaJMI;
    private JMenuItem drawingsJMI;
    private JMenuItem defineCitationJMI;
    private JMenuItem defineCruxJMI;
    private JMenuItem defineDateTokenJMI;
    private JMenuItem defineEnunciatioJMI;
    private JMenuItem defineExpunctioJMI;
    private JMenuItem defineMathConceptJMI;
    private JMenuItem defineNameJMI;
    private JMenuItem definePlaceJMI;
    private JMenuItem defineWorkJMI;
    private JMenuItem defineTongueJMI;
    private JMenuItem insertUnitJMI;
    private JMenuItem insertPartJMI;
    private JMenuItem addIntegratioJMI;
    private JMenuItem addAnnotationJMI;
    private JMenuItem addImageJMI;
    private JMenuItem insertListItemJMI;
    private JMenuItem annotationsJMI;
    private JMenuItem imagesJMI;
    private JMenuItem citationsJMI;
    private JMenuItem crucesJMI;
    private JMenuItem dateTokensJMI;
    private JMenuItem enunciationesJMI;
    private JMenuItem expunctionesJMI;
    private JMenuItem integrationesJMI;
    private JMenuItem mathConceptsJMI;
    private JMenuItem namesJMI;
    private JMenuItem placesJMI;
    private JMenuItem worksJMI;
    private JMenuItem unitsJMI;
    private JMenuItem tonguesJMI;
    private JMenuItem textPartsJMI;
    private JMenuItem addCommentJMI;
    private JMenuItem commentsJMI;
    private String unexpectedEventString;
    private String fileString;
    private String editString;
    private String languageString;
    private String traditionString;
    private String editorString;
    private String toolsString;
    private String newString;
    private String openString;
    private String saveString;
    private String nameString;
    private String importString;
    private String lockString;
    private String unlockString;
    private String exportHtmlString;
    private String exportTxtString;
    private String exportLatexString;
    private String closeString;
    private String latinString;
    private String greekString;
    private String cutString;
    private String copyString;
    private String pasteString;
    private String deleteString;
    private String findString;
    private String findNextString;
    private String metadataString;
    private String witnessesString;
    private String referencesString;
    private String defineFormulaString;
    private String defineVariantString;
    private String insertFoliumString;
    private String insertDrawingString;
    private String foliaString;
    private String drawingsString;
    private String defineCitationString;
    private String defineCruxString;
    private String defineDateTokenString;
    private String defineEnunciatioString;
    private String defineExpunctioString;
    private String defineMathConceptString;
    private String defineNameString;
    private String definePlaceString;
    private String defineWorkString;
    private String defineTongueString;
    private String insertUnitString;
    private String insertPartString;
    private String addIntegratioString;
    private String addAnnotationString;
    private String addImageString;
    private String insertListItemString;
    private String namesString;
    private String mathConceptsString;
    private String placesString;
    private String worksString;
    private String tonguesString;
    private String textPartsString;
    private String dateTokensString;
    private String citationsString;
    private String unitsString;
    private String enunciationesString;
    private String expunctionesString;
    private String crucesString;
    private String integrationesString;
    private String annotationsString;
    private String imagesString;
    private String commentsString;
    private String addCommentString;
    private String metadataSummaryTitleString;
    private String variantsTitleString;
    private String newFileString;
    private DateFormat default_format;
    private Definer<Annotation> annotation_definer;
    private Definer<Image> imageDefiner;
    private Definer<Citation> citation_definer;
    private Definer<Comment> comment_definer;
    private Definer<Crux> crux_definer;
    private Definer<DateToken> dateToken_definer;
    private Definer<Drawing> drawing_definer;
    private Definer<Enunciatio> enunciatio_definer;
    private Definer<Expunctio> expunctio_definer;
    private Definer<Folium> folium_definer;
    private Definer<Formula> formula_definer;
    private Definer<Integratio> integratio_definer;
    private Definer<ListItem> list_item_definer;
    private Definer<MathConcept> mathConceptDefiner;
    private Definer<Name> name_definer;
    private Definer<Place> placeDefiner;
    private Definer<Work> workDefiner;
    private Definer<Unit> unit_definer;
    private Definer<TextPart> part_definer;
    private Definer<Variant> variant_definer;
    private Definer<Tongue> tongueDefiner;
    private List<ComponentObserver> observers;
    private Edition edition;
    private boolean metadataSummaryVisible;
    private List<JMenuItem> exportJMIs;
    private final EditionManager editionManager = EditionManager.getInstance();
    private Ontology namesOntology = this.editionManager.getNamesOntology();
    private Ontology variantsOntology = this.editionManager.getVariantsOntology();

    public void init() throws SAXException, ParserConfigurationException, IOException {
        this.observers = new ArrayList<ComponentObserver>();
        IDE.initPreferences();
        Preferences preferences = Preferences.getInstance();
        this.metadataSummaryVisible = preferences.getBoolean("metadata_summary");
        this.initFrames();
        this.initDefiners();
        this.initLocale();
        this.initMenubar();
        this.greetings();
        this.enableActions();
    }

    private static void initPreferences() {
        Preferences.newInstance();
    }

    private static URL getCodeBase() throws MalformedURLException {
        return new URL(".");
    }

    private void initFrames() {
        this.annotationsFrame = WindowsFactory.getAnnotationsFrame();
        this.imagesFrame = WindowsFactory.getImagesFrame();
        this.citationsFrame = WindowsFactory.getCitationsFrame();
        this.commentsFrame = WindowsFactory.getCommentsFrame();
        this.conspectusFrame = WindowsFactory.getConspectusFrame();
        this.crucesFrame = WindowsFactory.getCrucesFrame();
        this.dateTokensFrame = WindowsFactory.getDatesFrame();
        this.drawingFrame = new DrawingFrame();
        this.enunciationesFrame = WindowsFactory.getEnunciationesFrame();
        this.expunctionesFrame = WindowsFactory.getExpunctionesFrame();
        this.findFrame = new FindFrame();
        this.drawingsFrame = WindowsFactory.getDrawingsFrame();
        this.foliaFrame = WindowsFactory.getFoliaFrame();
        this.integrationesFrame = WindowsFactory.getIntegrationesFrame();
        this.mathConceptsFrame = WindowsFactory.getMathConceptsFrame();
        this.metadataFrame = new MetadataFrame();
        this.namesFrame = WindowsFactory.getNamesFrame();
        this.textPartsFrame = WindowsFactory.getTextPartsFrame();
        this.placesFrame = WindowsFactory.getPlacesFrame();
        this.referencesFrame = new ReferencesFrame();
        this.unitsFrame = WindowsFactory.getUnitsFrame();
        this.tonguesFrame = WindowsFactory.getTonguesFrame();
        this.worksFrame = WindowsFactory.getWorksFrame();
    }

    private void tearDown() {
        this.annotationsFrame.dispose();
        this.citationsFrame.dispose();
        this.commentsFrame.dispose();
        this.conspectusFrame.dispose();
        this.crucesFrame.dispose();
        this.dateTokensFrame.dispose();
        this.drawingFrame.dispose();
        this.enunciationesFrame.dispose();
        this.expunctionesFrame.dispose();
        this.findFrame.dispose();
        this.drawingsFrame.dispose();
        this.foliaFrame.dispose();
        this.integrationesFrame.dispose();
        this.mathConceptsFrame.dispose();
        this.metadataFrame.dispose();
        this.namesFrame.dispose();
        this.placesFrame.dispose();
        this.referencesFrame.dispose();
        this.textPartsFrame.dispose();
        this.tonguesFrame.dispose();
        this.unitsFrame.dispose();
        this.worksFrame.dispose();
        if (this.variants_panel != null) {
            this.variants_panel.closing();
        }
        if (this.textPanel != null) {
            this.textPanel.dispose();
        }
        this.observers.clear();
        this.setContentPaneTitle();
    }

    private void initDefiners() {
        this.annotation_definer = DefinersFactory.getAnnotationDefiner(this);
        this.imageDefiner = DefinersFactory.getImageDefiner(this);
        this.citation_definer = DefinersFactory.getCitationDefiner(this);
        this.comment_definer = DefinersFactory.getCommentDefiner(this);
        this.crux_definer = DefinersFactory.getCruxDefiner(this);
        this.dateToken_definer = DefinersFactory.getDateTokenDefiner(this);
        this.drawing_definer = DefinersFactory.getDrawingDefiner(this);
        this.enunciatio_definer = DefinersFactory.getEnunciatioDefiner(this);
        this.expunctio_definer = DefinersFactory.getExpunctioDefiner(this);
        this.folium_definer = DefinersFactory.getFoliumDefiner(this);
        this.formula_definer = DefinersFactory.getFormulaDefiner(this);
        this.integratio_definer = DefinersFactory.getIntegratioDefiner(this);
        this.list_item_definer = DefinersFactory.getListItemDefiner(this);
        this.mathConceptDefiner = DefinersFactory.getMathConceptDefiner(this);
        this.name_definer = DefinersFactory.getNameDefiner(this);
        this.placeDefiner = DefinersFactory.getPlaceDefiner(this);
        this.part_definer = DefinersFactory.getPartDefiner(this);
        this.tongueDefiner = DefinersFactory.getTongueDefiner(this);
        this.unit_definer = DefinersFactory.getUnitDefiner(this);
        this.variant_definer = DefinersFactory.getVariantDefiner(this);
        this.workDefiner = DefinersFactory.getWorkDefiner(this);
    }

    private void initLocale() {
        MessageCatalog catalog = new MessageCatalog();
        Preferences preferences = Preferences.getInstance();
        String locale = preferences.getProperty("locale");
        Class<?> classObj = this.getClass();
        String className = classObj.getName();
        catalog.loadCatalog(className, locale);
        this.default_format = DateFormat.getDateInstance(2, new Locale(locale));
        this.unexpectedEventString = catalog.translate("unexpectedEvent");
        this.fileString = catalog.translate("file");
        this.editString = catalog.translate("edit");
        this.languageString = catalog.translate("language");
        this.traditionString = catalog.translate("tradition");
        this.editorString = catalog.translate("editor");
        this.toolsString = catalog.translate("tools");
        this.newString = catalog.translate("new");
        this.openString = catalog.translate("open");
        this.saveString = catalog.translate("save");
        this.nameString = catalog.translate("name");
        this.importString = catalog.translate("import");
        this.lockString = catalog.translate("lock");
        this.unlockString = catalog.translate("unlock");
        this.exportHtmlString = catalog.translate("exportHTML");
        this.exportTxtString = catalog.translate("exportTXT");
        this.exportLatexString = catalog.translate("exportLatex");
        this.closeString = catalog.translate("close");
        this.cutString = catalog.translate("cut");
        this.copyString = catalog.translate("copy");
        this.pasteString = catalog.translate("paste");
        this.deleteString = catalog.translate("delete");
        this.findString = catalog.translate("find");
        this.findNextString = catalog.translate("findNext");
        this.latinString = catalog.translate("latin");
        this.greekString = catalog.translate("greek");
        this.metadataString = catalog.translate("editionTitle");
        this.witnessesString = catalog.translate("witnesses");
        this.referencesString = catalog.translate("references");
        this.defineFormulaString = catalog.translate("defineFormula");
        this.defineVariantString = catalog.translate("defineVariant");
        this.insertFoliumString = catalog.translate("insertFolium");
        this.insertDrawingString = catalog.translate("insertDrawing");
        this.foliaString = catalog.translate("folia");
        this.drawingsString = catalog.translate("drawings");
        this.defineCitationString = catalog.translate("defineCitation");
        this.defineCruxString = catalog.translate("defineCrux");
        this.defineDateTokenString = catalog.translate("defineDateToken");
        this.defineEnunciatioString = catalog.translate("defineEnunciatio");
        this.defineExpunctioString = catalog.translate("defineExpunctio");
        this.defineMathConceptString = catalog.translate("defineMathConcept");
        this.defineNameString = catalog.translate("defineName");
        this.definePlaceString = catalog.translate("definePlace");
        this.defineWorkString = catalog.translate("defineWork");
        this.defineTongueString = catalog.translate("defineTongue");
        this.insertPartString = catalog.translate("insertPart");
        this.insertUnitString = catalog.translate("insertUnit");
        this.insertListItemString = catalog.translate("insertListItem");
        this.addAnnotationString = catalog.translate("addAnnotation");
        this.addImageString = catalog.translate("addImage");
        this.addIntegratioString = catalog.translate("addIntegratio");
        this.annotationsString = catalog.translate("annotations");
        this.imagesString = catalog.translate("images");
        this.citationsString = catalog.translate("citations");
        this.crucesString = catalog.translate("cruces");
        this.dateTokensString = catalog.translate("dateTokens");
        this.enunciationesString = catalog.translate("enunciationes");
        this.expunctionesString = catalog.translate("expunctiones");
        this.integrationesString = catalog.translate("integrationes");
        this.mathConceptsString = catalog.translate("mathConcepts");
        this.namesString = catalog.translate("names");
        this.placesString = catalog.translate("places");
        this.textPartsString = catalog.translate("parts");
        this.tonguesString = catalog.translate("tongues");
        this.unitsString = catalog.translate("units");
        this.worksString = catalog.translate("works");
        this.commentsString = catalog.translate("comments");
        this.addCommentString = catalog.translate("addComment");
        this.variantsTitleString = catalog.translate("variantsTitle");
        this.metadataSummaryTitleString = catalog.translate("metadataSummaryTitle");
        this.newFileString = catalog.translate("newFile");
    }

    private void initMenubar() throws SAXException, ParserConfigurationException, IOException {
        JMenu fileMenu = this.setupFileMenu();
        JMenu editMenu = this.setupEditMenu();
        JMenu langMenu = this.setupLangMenu();
        JMenu tradMenu = this.setupTraditionMenu();
        JMenu editorMenu = this.setupEditorMenu();
        JMenu toolsMenu = this.setupToolsMenu();
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(fileMenu);
        menuBar.add(editMenu);
        menuBar.add(langMenu);
        menuBar.add(tradMenu);
        menuBar.add(editorMenu);
        menuBar.add(toolsMenu);
        this.setJMenuBar(menuBar);
    }

    private JMenu setupToolsMenu() {
        JMenu toolsMenu = new JMenu(this.toolsString);
        toolsMenu.setMnemonic(84);
        this.addCommentJMI = new JMenuItem(this.addCommentString);
        this.commentsJMI = new JMenuItem(this.commentsString);
        this.commentsJMI.setAccelerator(KeyStroke.getKeyStroke(77, 2));
        this.addCommentJMI.addActionListener(this);
        this.commentsJMI.addActionListener(this);
        toolsMenu.add(this.commentsJMI);
        toolsMenu.addSeparator();
        toolsMenu.add(this.addCommentJMI);
        return toolsMenu;
    }

    private JMenu setupEditorMenu() {
        JMenu editorMenu = new JMenu(this.editorString);
        editorMenu.setMnemonic(68);
        this.defineCitationJMI = new JMenuItem(this.defineCitationString);
        this.defineCitationJMI.setAccelerator(KeyStroke.getKeyStroke(67, 8));
        this.defineCruxJMI = new JMenuItem(this.defineCruxString);
        this.defineCruxJMI.setAccelerator(KeyStroke.getKeyStroke(82, 8));
        this.defineDateTokenJMI = new JMenuItem(this.defineDateTokenString);
        this.defineDateTokenJMI.setAccelerator(KeyStroke.getKeyStroke(68, 8));
        this.defineEnunciatioJMI = new JMenuItem(this.defineEnunciatioString);
        this.defineEnunciatioJMI.setAccelerator(KeyStroke.getKeyStroke(69, 8));
        this.defineExpunctioJMI = new JMenuItem(this.defineExpunctioString);
        this.defineExpunctioJMI.setAccelerator(KeyStroke.getKeyStroke(88, 8));
        this.defineMathConceptJMI = new JMenuItem(this.defineMathConceptString);
        this.defineMathConceptJMI.setAccelerator(KeyStroke.getKeyStroke(77, 8));
        this.defineNameJMI = new JMenuItem(this.defineNameString);
        this.defineNameJMI.setAccelerator(KeyStroke.getKeyStroke(78, 8));
        this.definePlaceJMI = new JMenuItem(this.definePlaceString);
        this.definePlaceJMI.setAccelerator(KeyStroke.getKeyStroke(80, 8));
        this.defineWorkJMI = new JMenuItem(this.defineWorkString);
        this.defineWorkJMI.setAccelerator(KeyStroke.getKeyStroke(87, 8));
        this.defineTongueJMI = new JMenuItem(this.defineTongueString);
        this.defineTongueJMI.setAccelerator(KeyStroke.getKeyStroke(84, 8));
        this.insertUnitJMI = new JMenuItem(this.insertUnitString);
        this.insertPartJMI = new JMenuItem(this.insertPartString);
        this.insertPartJMI.setAccelerator(KeyStroke.getKeyStroke(66, 8));
        this.insertListItemJMI = new JMenuItem(this.insertListItemString);
        this.addIntegratioJMI = new JMenuItem(this.addIntegratioString);
        this.addAnnotationJMI = new JMenuItem(this.addAnnotationString);
        this.addImageJMI = new JMenuItem(this.addImageString);
        this.annotationsJMI = new JMenuItem(this.annotationsString);
        this.imagesJMI = new JMenuItem(this.imagesString);
        this.citationsJMI = new JMenuItem(this.citationsString);
        this.crucesJMI = new JMenuItem(this.crucesString);
        this.dateTokensJMI = new JMenuItem(this.dateTokensString);
        this.enunciationesJMI = new JMenuItem(this.enunciationesString);
        this.expunctionesJMI = new JMenuItem(this.expunctionesString);
        this.integrationesJMI = new JMenuItem(this.integrationesString);
        this.mathConceptsJMI = new JMenuItem(this.mathConceptsString);
        this.namesJMI = new JMenuItem(this.namesString);
        this.placesJMI = new JMenuItem(this.placesString);
        this.unitsJMI = new JMenuItem(this.unitsString);
        this.worksJMI = new JMenuItem(this.worksString);
        this.tonguesJMI = new JMenuItem(this.tonguesString);
        this.textPartsJMI = new JMenuItem(this.textPartsString);
        this.defineCitationJMI.addActionListener(this);
        this.defineCruxJMI.addActionListener(this);
        this.defineDateTokenJMI.addActionListener(this);
        this.defineEnunciatioJMI.addActionListener(this);
        this.defineExpunctioJMI.addActionListener(this);
        this.defineMathConceptJMI.addActionListener(this);
        this.defineNameJMI.addActionListener(this);
        this.definePlaceJMI.addActionListener(this);
        this.defineWorkJMI.addActionListener(this);
        this.defineTongueJMI.addActionListener(this);
        this.insertPartJMI.addActionListener(this);
        this.insertUnitJMI.addActionListener(this);
        this.insertUnitJMI.setAccelerator(KeyStroke.getKeyStroke(85, 8));
        this.addAnnotationJMI.addActionListener(this);
        this.addAnnotationJMI.setAccelerator(KeyStroke.getKeyStroke(65, 8));
        this.addImageJMI.addActionListener(this);
        this.addImageJMI.setAccelerator(KeyStroke.getKeyStroke(70, 8));
        this.addIntegratioJMI.addActionListener(this);
        this.addIntegratioJMI.setAccelerator(KeyStroke.getKeyStroke(73, 8));
        this.insertListItemJMI.addActionListener(this);
        this.insertListItemJMI.setAccelerator(KeyStroke.getKeyStroke(76, 8));
        this.annotationsJMI.addActionListener(this);
        this.imagesJMI.addActionListener(this);
        this.citationsJMI.addActionListener(this);
        this.crucesJMI.addActionListener(this);
        this.dateTokensJMI.addActionListener(this);
        this.enunciationesJMI.addActionListener(this);
        this.expunctionesJMI.addActionListener(this);
        this.integrationesJMI.addActionListener(this);
        this.mathConceptsJMI.addActionListener(this);
        this.namesJMI.addActionListener(this);
        this.placesJMI.addActionListener(this);
        this.textPartsJMI.addActionListener(this);
        this.tonguesJMI.addActionListener(this);
        this.unitsJMI.addActionListener(this);
        this.worksJMI.addActionListener(this);
        editorMenu.add(this.defineCitationJMI);
        editorMenu.add(this.defineCruxJMI);
        editorMenu.add(this.defineDateTokenJMI);
        editorMenu.add(this.defineEnunciatioJMI);
        editorMenu.add(this.defineExpunctioJMI);
        editorMenu.add(this.defineMathConceptJMI);
        editorMenu.add(this.defineNameJMI);
        editorMenu.add(this.definePlaceJMI);
        editorMenu.add(this.defineWorkJMI);
        editorMenu.add(this.defineTongueJMI);
        editorMenu.addSeparator();
        editorMenu.add(this.insertPartJMI);
        editorMenu.add(this.insertUnitJMI);
        editorMenu.add(this.insertListItemJMI);
        editorMenu.add(this.addAnnotationJMI);
        editorMenu.add(this.addImageJMI);
        editorMenu.add(this.addIntegratioJMI);
        editorMenu.addSeparator();
        editorMenu.add(this.annotationsJMI);
        editorMenu.add(this.imagesJMI);
        editorMenu.add(this.citationsJMI);
        editorMenu.add(this.crucesJMI);
        editorMenu.add(this.dateTokensJMI);
        editorMenu.add(this.enunciationesJMI);
        editorMenu.add(this.expunctionesJMI);
        editorMenu.add(this.integrationesJMI);
        editorMenu.add(this.mathConceptsJMI);
        editorMenu.add(this.namesJMI);
        editorMenu.add(this.placesJMI);
        editorMenu.add(this.textPartsJMI);
        editorMenu.add(this.tonguesJMI);
        editorMenu.add(this.unitsJMI);
        editorMenu.add(this.worksJMI);
        return editorMenu;
    }

    private JMenu setupTraditionMenu() {
        JMenu tradMenu = new JMenu(this.traditionString);
        tradMenu.setMnemonic(82);
        this.metadataJMI = new JMenuItem(this.metadataString);
        this.witnessesJMI = new JMenuItem(this.witnessesString);
        this.referencesJMI = new JMenuItem(this.referencesString);
        this.defineFormulaJMI = new JMenuItem(this.defineFormulaString);
        this.defineFormulaJMI.addActionListener(this);
        this.defineFormulaJMI.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        this.defineVariantJMI = new JMenuItem(this.defineVariantString);
        this.defineVariantJMI.setAccelerator(KeyStroke.getKeyStroke(66, 2));
        this.insertFoliumJMI = new JMenuItem(this.insertFoliumString);
        this.insertFoliumJMI.setAccelerator(KeyStroke.getKeyStroke(85, 2));
        this.insertDrawingJMI = new JMenuItem(this.insertDrawingString);
        this.drawingsJMI = new JMenuItem(this.drawingsString);
        this.foliaJMI = new JMenuItem(this.foliaString);
        this.metadataJMI.addActionListener(this);
        this.witnessesJMI.addActionListener(this);
        this.referencesJMI.addActionListener(this);
        this.defineVariantJMI.addActionListener(this);
        this.insertFoliumJMI.addActionListener(this);
        this.insertDrawingJMI.addActionListener(this);
        this.insertDrawingJMI.setAccelerator(KeyStroke.getKeyStroke(68, 2));
        this.drawingsJMI.addActionListener(this);
        this.foliaJMI.addActionListener(this);
        tradMenu.add(this.metadataJMI);
        tradMenu.add(this.witnessesJMI);
        tradMenu.add(this.referencesJMI);
        tradMenu.addSeparator();
        tradMenu.add(this.defineFormulaJMI);
        tradMenu.addSeparator();
        tradMenu.add(this.defineVariantJMI);
        tradMenu.addSeparator();
        tradMenu.add(this.insertFoliumJMI);
        tradMenu.add(this.insertDrawingJMI);
        tradMenu.addSeparator();
        tradMenu.add(this.foliaJMI);
        tradMenu.add(this.drawingsJMI);
        return tradMenu;
    }

    private JMenu setupFileMenu() throws SAXException, ParserConfigurationException, IOException {
        JMenu fileMenu = new JMenu(this.fileString);
        fileMenu.setMnemonic(70);
        this.newJMI = new JMenuItem(this.newString);
        this.openJMI = new JMenuItem(this.openString);
        this.saveJMI = new JMenuItem(this.saveString);
        this.nameJMI = new JMenuItem(this.nameString);
        this.importJMI = new JMenuItem(this.importString);
        this.lockJMI = new JMenuItem(this.lockString);
        this.unlockJMI = new JMenuItem(this.unlockString);
        this.exportHtmlJMI = new JMenuItem(this.exportHtmlString);
        this.exportTxtJMI = new JMenuItem(this.exportTxtString);
        this.exportLatexJMI = new JMenuItem(this.exportLatexString);
        this.closeJMI = new JMenuItem(this.closeString);
        this.newJMI.addActionListener(this);
        this.openJMI.addActionListener(this);
        this.saveJMI.addActionListener(this);
        this.nameJMI.addActionListener(this);
        this.importJMI.addActionListener(this);
        this.lockJMI.addActionListener(this);
        this.unlockJMI.addActionListener(this);
        this.exportHtmlJMI.addActionListener(this);
        this.exportTxtJMI.addActionListener(this);
        this.exportLatexJMI.addActionListener(this);
        this.closeJMI.addActionListener(this);
        this.newJMI.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.openJMI.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.saveJMI.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.exportHtmlJMI.setAccelerator(KeyStroke.getKeyStroke(72, 2));
        this.exportTxtJMI.setAccelerator(KeyStroke.getKeyStroke(84, 2));
        this.exportLatexJMI.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        this.closeJMI.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        fileMenu.add(this.newJMI);
        fileMenu.add(this.openJMI);
        fileMenu.add(this.saveJMI);
        fileMenu.add(this.nameJMI);
        fileMenu.addSeparator();
        fileMenu.add(this.importJMI);
        fileMenu.add(this.lockJMI);
        fileMenu.add(this.unlockJMI);
        fileMenu.addSeparator();
        fileMenu.add(this.exportHtmlJMI);
        fileMenu.add(this.exportTxtJMI);
        fileMenu.add(this.exportLatexJMI);
        this.addExports(fileMenu);
        fileMenu.addSeparator();
        fileMenu.add(this.closeJMI);
        return fileMenu;
    }

    private void addExports(JMenu fileMenu) throws SAXException, ParserConfigurationException, IOException {
        this.exportJMIs = new ArrayList<JMenuItem>();
        fileMenu.addSeparator();
        ScriptoriumExport[] scriptoriumExportArray = ScriptoriumExport.values();
        int n = scriptoriumExportArray.length;
        int n2 = 0;
        while (n2 < n) {
            ScriptoriumExport export = scriptoriumExportArray[n2];
            JMenuItem jmi = this.newJMI(export);
            fileMenu.add(jmi);
            this.exportJMIs.add(jmi);
            ++n2;
        }
    }

    private JMenuItem newJMI(ScriptoriumExport export) throws SAXException, ParserConfigurationException, IOException {
        String text = export.getText();
        JMenuItem jmi = new JMenuItem(text);
        ActionListener listener = export.getActionListener(this);
        jmi.addActionListener(listener);
        return jmi;
    }

    private JMenu setupEditMenu() {
        JMenu editMenu = new JMenu(this.editString);
        editMenu.setMnemonic(69);
        this.cutJMI = new JMenuItem(this.cutString);
        this.copyJMI = new JMenuItem(this.copyString);
        this.pasteJMI = new JMenuItem(this.pasteString);
        this.deleteJMI = new JMenuItem(this.deleteString);
        this.findJMI = new JMenuItem(this.findString);
        this.findNextJMI = new JMenuItem(this.findNextString);
        this.cutJMI.addActionListener(this);
        this.copyJMI.addActionListener(this);
        this.pasteJMI.addActionListener(this);
        this.deleteJMI.addActionListener(this);
        this.findJMI.addActionListener(this);
        this.findNextJMI.addActionListener(this);
        this.cutJMI.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.copyJMI.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.pasteJMI.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        this.findJMI.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        this.findNextJMI.setAccelerator(KeyStroke.getKeyStroke(75, 2));
        editMenu.add(this.cutJMI);
        editMenu.add(this.copyJMI);
        editMenu.add(this.pasteJMI);
        editMenu.add(this.deleteJMI);
        editMenu.addSeparator();
        editMenu.add(this.findJMI);
        editMenu.add(this.findNextJMI);
        return editMenu;
    }

    private JMenu setupLangMenu() {
        JMenu langMenu = new JMenu(this.languageString);
        langMenu.setMnemonic(76);
        ButtonGroup langBGroup = new ButtonGroup();
        this.latinJMI = new JRadioButtonMenuItem(this.latinString);
        this.greekJMI = new JRadioButtonMenuItem(this.greekString);
        langBGroup.add(this.latinJMI);
        langBGroup.add(this.greekJMI);
        this.latinJMI.setSelected(true);
        this.latinJMI.addActionListener(this);
        this.greekJMI.addActionListener(this);
        langMenu.add(this.latinJMI);
        langMenu.add(this.greekJMI);
        return langMenu;
    }

    private void greetings() {
        JEditorPane greetPane = new JEditorPane();
        greetPane.setBorder(new LineBorder(Color.blue));
        greetPane.setEditable(false);
        greetPane.setContentType("text/html");
        try {
            URL greetURL = new URL(IDE.getCodeBase(), "greetings.html");
            greetPane.setPage(greetURL);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        this.setLayout(new GridBagLayout());
        UITools.addComponent(this, greetPane, 0, 0, 1, 1, 0, 0, 0, 50);
    }

    private void enableActions() {
        this.newJMI.setEnabled(true);
        this.openJMI.setEnabled(true);
        this.saveJMI.setEnabled(this.edition != null && IDE.checkUnsaved());
        this.nameJMI.setEnabled(this.edition != null);
        this.importJMI.setEnabled(this.edition != null && this.edition.isTextNull());
        this.lockJMI.setEnabled(this.edition != null && !this.textPanel.isBasicTextLocked());
        this.unlockJMI.setEnabled(this.edition != null && this.textPanel.isBasicTextLocked());
        this.exportHtmlJMI.setEnabled(this.edition != null);
        this.exportTxtJMI.setEnabled(this.edition != null);
        this.exportLatexJMI.setEnabled(this.edition != null);
        this.closeJMI.setEnabled(this.edition != null);
        this.cutJMI.setEnabled(this.edition != null && !this.textPanel.isBasicTextLocked());
        this.copyJMI.setEnabled(this.edition != null && !this.textPanel.isBasicTextLocked());
        this.pasteJMI.setEnabled(this.edition != null && !this.textPanel.isBasicTextLocked());
        this.deleteJMI.setEnabled(this.edition != null && !this.textPanel.isBasicTextLocked());
        this.findJMI.setEnabled(this.edition != null);
        this.findNextJMI.setEnabled(this.edition != null);
        this.latinJMI.setEnabled(this.edition != null);
        this.greekJMI.setEnabled(this.edition != null);
        boolean enabled = this.edition != null && this.textPanel.isBasicTextLocked();
        this.metadataJMI.setEnabled(enabled);
        this.witnessesJMI.setEnabled(enabled);
        this.referencesJMI.setEnabled(enabled);
        this.defineFormulaJMI.setEnabled(enabled);
        this.defineVariantJMI.setEnabled(enabled);
        this.insertFoliumJMI.setEnabled(enabled);
        this.insertDrawingJMI.setEnabled(enabled);
        this.foliaJMI.setEnabled(enabled);
        this.drawingsJMI.setEnabled(enabled);
        this.defineCitationJMI.setEnabled(enabled);
        this.defineCruxJMI.setEnabled(enabled);
        this.defineDateTokenJMI.setEnabled(enabled);
        this.defineEnunciatioJMI.setEnabled(enabled);
        this.defineExpunctioJMI.setEnabled(enabled);
        this.defineMathConceptJMI.setEnabled(enabled);
        this.defineNameJMI.setEnabled(enabled);
        this.definePlaceJMI.setEnabled(enabled);
        this.defineWorkJMI.setEnabled(enabled);
        this.defineTongueJMI.setEnabled(enabled);
        this.insertPartJMI.setEnabled(enabled);
        this.insertUnitJMI.setEnabled(enabled);
        this.insertListItemJMI.setEnabled(enabled);
        this.addIntegratioJMI.setEnabled(enabled);
        this.addAnnotationJMI.setEnabled(enabled);
        this.addImageJMI.setEnabled(enabled);
        this.annotationsJMI.setEnabled(enabled);
        this.imagesJMI.setEnabled(enabled);
        this.citationsJMI.setEnabled(enabled);
        this.crucesJMI.setEnabled(enabled);
        this.dateTokensJMI.setEnabled(enabled);
        this.enunciationesJMI.setEnabled(enabled);
        this.expunctionesJMI.setEnabled(enabled);
        this.integrationesJMI.setEnabled(enabled);
        this.mathConceptsJMI.setEnabled(enabled);
        this.namesJMI.setEnabled(enabled);
        this.placesJMI.setEnabled(enabled);
        this.textPartsJMI.setEnabled(enabled);
        this.tonguesJMI.setEnabled(enabled);
        this.unitsJMI.setEnabled(enabled);
        this.worksJMI.setEnabled(enabled);
        this.commentsJMI.setEnabled(enabled);
        this.addCommentJMI.setEnabled(enabled);
    }

    private void setContentPaneTitle() {
        String title;
        JComponent contentPane = (JComponent)this.getContentPane();
        if (this.edition == null) {
            title = "";
        } else {
            Header header = this.edition.getHeader();
            String edition_title = header.getTitle();
            File document = this.edition.getFile();
            String filename = document == null ? this.newFileString : document.getName();
            title = String.valueOf(edition_title) + " ( " + filename + " )";
        }
        contentPane.setBorder(new TitledBorder(new LineBorder(Color.darkGray), title));
    }

    private void saveEdition(boolean withName) {
        int position = this.getTextPanel().getCaretPosition();
        DraftExportDirectorFactory exportDirectorFactory = new DraftExportDirectorFactory();
        boolean ok = this.editionManager.saveEdition(this.edition, withName, null, exportDirectorFactory);
        if (ok) {
            this.setContentPaneTitle();
            this.textPanel.lockBasicText();
        }
        this.getTextPanel().setCaretPosition(position);
    }

    @Override
    public void downloadEdition(URI uuid) {
    }

    public void loadEdition(boolean create) {
        this.closeCurrentEdition();
        if (create) {
            this.createNewEdition();
        } else {
            this.edition = this.editionManager.loadEdition(null);
        }
        if (this.edition != null) {
            EditionUpgrade visitor = new EditionUpgrade();
            visitor.visit(this.edition);
            this.mapper = new EditionMapper(this.edition);
            this.setupGUI();
        }
    }

    private void createNewEdition() {
        Preferences preferences = Preferences.getInstance();
        this.edition = new Edition();
        Header header = this.edition.getHeader();
        Conspectus conspectus = header.getConspectus();
        int index = 0;
        while (true) {
            String propertyName;
            String propertyValue;
            Witness witness = new Witness(conspectus);
            if ((propertyValue = preferences.getString(propertyName = "conspectus_" + ++index)) == null) break;
            String[] strings = propertyValue.split("/");
            String id = strings[0];
            String title = strings[1];
            witness.setId(id);
            witness.setTitle(title);
            conspectus.addWitness(witness);
        }
    }

    private void setupGUI() {
        this.setContentPaneTitle();
        this.createTextPanel();
        this.createMetadataSummaryPanel();
        this.createVariantsPanel();
        JSplitPane mainSplitPane = new JSplitPane(0, this.textPanel, this.variants_panel);
        mainSplitPane.setOneTouchExpandable(true);
        mainSplitPane.setContinuousLayout(true);
        mainSplitPane.setResizeWeight(0.95);
        mainSplitPane.setDividerLocation(0.7);
        JSplitPane metadataSplitPane = new JSplitPane(0, this.metadataSummaryPanel, mainSplitPane);
        metadataSplitPane.setOneTouchExpandable(true);
        metadataSplitPane.setResizeWeight(0.0);
        metadataSplitPane.setDividerLocation(this.metadataSummaryVisible ? 0.3 : 0.0);
        this.setLayout(new GridBagLayout());
        UITools.addComponent(this, metadataSplitPane, 0, 0, 1, 1, 100, 100, 1, 0);
        this.validate();
    }

    private boolean closeCurrentEdition() {
        boolean ok = IDE.checkUnsaved();
        if (ok) {
            this.edition = null;
            this.tearDown();
        }
        return ok;
    }

    private void defineCitation() {
        Citation citation = this.textPanel.defineToken(this.citation_definer);
        if (citation != null) {
            this.openCitationsFrame(citation);
        }
    }

    private void defineCrux() {
        Crux crux = this.textPanel.defineToken(this.crux_definer);
        if (crux != null) {
            this.openCrucesFrame(crux);
        }
    }

    private void defineEnunciatio() {
        Enunciatio enunciatio = this.textPanel.defineToken(this.enunciatio_definer);
        if (enunciatio != null) {
            this.openEnunciationesFrame(enunciatio);
        }
    }

    private void defineExpunctio() {
        Expunctio expunctio = this.textPanel.defineToken(this.expunctio_definer);
        if (expunctio != null) {
            this.openExpunctionesFrame(expunctio);
        }
    }

    private void defineFormula() {
        this.textPanel.defineToken(this.formula_definer);
    }

    private void definePlace() {
        Place place = this.textPanel.defineToken(this.placeDefiner);
        if (place != null) {
            this.openPlacesFrame(place);
        }
    }

    private void defineWork() {
        Work work = this.textPanel.defineToken(this.workDefiner);
        if (work != null) {
            this.openWorksFrame(work);
        }
    }

    private void defineTongue() {
        Tongue tongue = this.textPanel.defineToken(this.tongueDefiner);
        if (tongue != null) {
            this.openTonguesFrame(tongue);
        }
    }

    private void defineMathConcept() {
        MathConcept mathConcept = this.textPanel.defineToken(this.mathConceptDefiner);
        if (mathConcept != null) {
            this.openMathConceptsFrame(mathConcept);
        }
    }

    private void defineName() {
        Name name = this.textPanel.defineToken(this.name_definer);
        if (name != null) {
            this.openNamesFrame(name);
        }
    }

    private void defineDateToken() {
        DateToken date = this.textPanel.defineToken(this.dateToken_definer);
        if (date != null) {
            this.openDateTokensFrame(date);
        }
    }

    private void defineVariant() {
        Variant variant = this.textPanel.defineToken(this.variant_definer);
        if (variant != null) {
            this.openVariantFrame(variant);
        }
    }

    private void addAnnotation() {
        Annotation annotation = this.addToken(this.annotation_definer);
        if (annotation != null) {
            this.openAnnotationsFrame(annotation);
        }
    }

    private void addImage() {
        Image image = this.addToken(this.imageDefiner);
        if (image != null) {
            this.openImagesFrame(image);
        }
    }

    public <T extends AbstractValuedLeaf<T>> T addToken(Definer<T> definer) {
        AbstractValuedLeaf token = (AbstractValuedLeaf)this.textPanel.defineToken(definer);
        if (token != null) {
            token.setValue("");
        }
        return (T)token;
    }

    private void addComment() {
        Comment comment = this.textPanel.defineToken(this.comment_definer);
        if (comment != null) {
            String today = this.default_format.format(new Date());
            comment.setValue(String.valueOf(today) + ": ");
            this.openCommentsFrame(comment);
        }
    }

    private void addIntegratio() {
        Integratio integratio = this.textPanel.defineToken(this.integratio_definer);
        if (integratio != null) {
            integratio.setValue("");
            this.openIntegrationesFrame(integratio);
        }
    }

    private void insertDrawing() {
        Drawing drawing = this.textPanel.defineToken(this.drawing_definer);
        if (drawing != null) {
            this.openDrawingFrame(drawing);
        }
    }

    private void insertFolium() {
        Folium folium = this.textPanel.defineToken(this.folium_definer);
        if (folium != null) {
            this.openFoliaFrame(folium);
        }
    }

    private void insertListItem() {
        this.textPanel.defineToken(this.list_item_definer);
    }

    private void insertUnit() {
        this.textPanel.defineToken(this.unit_definer);
    }

    private void insertPart() {
        TextPart textPart = this.textPanel.defineToken(this.part_definer);
        if (textPart != null) {
            this.openTextPartsFrame(textPart);
        }
    }

    private void createMetadataSummaryPanel() {
        this.metadataSummaryPanel = new MetadataSummaryPanel(this.edition, this.namesOntology);
        this.metadataSummaryPanel.setBorder(new TitledBorder(new LineBorder(Color.black), this.metadataSummaryTitleString));
        this.metadataSummaryPanel.setup();
    }

    private void createTextPanel() {
        this.textPanel = new TextPanel(this);
        this.finder = new Finder(this.getStyledDocument());
    }

    private void createVariantsPanel() {
        this.variants_panel = new VariantsPanel(this, this.variantsOntology);
        this.variants_panel.setBorder(new TitledBorder(new LineBorder(Color.black), this.variantsTitleString));
    }

    @Override
    public void openAnnotationsFrame(Annotation annotation) {
        this.annotationsFrame.setup(this, annotation);
    }

    @Override
    public void openImagesFrame(Image image) {
        this.imagesFrame.setup(this, image);
    }

    @Override
    public void openCitationsFrame(Citation citation) {
        this.citationsFrame.setup(this, citation);
    }

    @Override
    public void openCommentsFrame(Comment comment) {
        this.commentsFrame.setup(this, comment);
    }

    private void openConspectusFrame() {
        this.conspectusFrame.setup(this);
    }

    @Override
    public void openCrucesFrame(Crux crux) {
        this.crucesFrame.setup(this, crux);
    }

    @Override
    public void openDateTokensFrame(DateToken date) {
        this.dateTokensFrame.setup(this, date);
    }

    @Override
    public void openDrawingFrame(Drawing drawing) {
        this.drawingFrame.setup(this, drawing);
    }

    @Override
    public void openEnunciationesFrame(Enunciatio enunciatio) {
        this.enunciationesFrame.setup(this, enunciatio);
    }

    @Override
    public void openExpunctionesFrame(Expunctio expunctio) {
        this.expunctionesFrame.setup(this, expunctio);
    }

    @Override
    public void openDrawingsFrame(Drawing drawing) {
        this.drawingsFrame.setup(this, drawing);
    }

    @Override
    public void openFoliaFrame(Folium folium) {
        this.foliaFrame.setup(this, folium);
    }

    @Override
    public void openIntegrationesFrame(Integratio integratio) {
        this.integrationesFrame.setup(this, integratio);
    }

    @Override
    public void openMathConceptsFrame(MathConcept mathConcept) {
        this.mathConceptsFrame.setup(this, mathConcept);
    }

    @Override
    public void openNamesFrame(Name name) {
        this.namesFrame.setup(this, name);
    }

    @Override
    public void openPlacesFrame(Place place) {
        this.placesFrame.setup(this, place);
    }

    private void openReferencesFrame() {
        this.referencesFrame.setup(this);
    }

    @Override
    public void openTextPartsFrame(TextPart textPart) {
        this.textPartsFrame.setup(this, textPart);
    }

    @Override
    public void openTonguesFrame(Tongue tongue) {
        this.tonguesFrame.setup(this, tongue);
    }

    @Override
    public void openUnitsFrame(Unit unit) {
        this.unitsFrame.setup(this, unit);
    }

    @Override
    public void openVariantFrame(Variant variant) {
        this.variants_panel.reload();
        this.variants_panel.selectVariant(variant);
        this.variants_panel.openVariantFrame(variant);
    }

    @Override
    public void openWorksFrame(Work work) {
        this.worksFrame.setup(this, work);
    }

    private void openEditionTitleFrame() {
        this.metadataFrame.setup(this);
        this.metadataFrame.setVisible(true);
    }

    private void openFindFrame() {
        this.findFrame.setup(this);
    }

    private static boolean checkUnsaved() {
        return true;
    }

    private static int getFocusedOffset(ScriptoriumTextPane pane) {
        Caret caret = pane.getCaret();
        return caret.getDot();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source == this.newJMI) {
            this.loadEdition(true);
        } else if (source == this.openJMI) {
            this.loadEdition(false);
        } else if (source == this.saveJMI || source == this.nameJMI) {
            this.saveEdition(source == this.nameJMI);
        } else if (source == this.importJMI) {
            this.editionManager.importBasicText(this);
        } else if (source == this.lockJMI) {
            this.textPanel.lockBasicText();
        } else if (source == this.unlockJMI) {
            this.textPanel.unlockBasicText();
        } else if (source == this.exportHtmlJMI) {
            this.editionManager.exportHTML(this.edition);
        } else if (source == this.exportTxtJMI) {
            this.editionManager.exportTXT(this.edition);
        } else if (source == this.exportLatexJMI) {
            this.editionManager.exportLatex(this.edition);
        } else if (source == this.closeJMI) {
            this.closeCurrentEdition();
        } else if (source == this.cutJMI) {
            this.textPanel.cut();
        } else if (source == this.copyJMI) {
            this.textPanel.copy();
        } else if (source == this.pasteJMI) {
            this.textPanel.paste();
        } else if (source == this.deleteJMI) {
            this.textPanel.delete();
        } else if (source == this.findJMI) {
            this.openFindFrame();
        } else if (source == this.findNextJMI) {
            this.findNext();
        } else if (!this.handleLangMenu(source)) {
            if (source == this.metadataJMI) {
                this.openEditionTitleFrame();
            } else if (source == this.witnessesJMI) {
                this.openConspectusFrame();
            } else if (source == this.referencesJMI) {
                this.openReferencesFrame();
            } else if (source == this.defineFormulaJMI) {
                this.defineFormula();
            } else if (source == this.defineVariantJMI) {
                this.defineVariant();
            } else if (source == this.insertFoliumJMI) {
                this.insertFolium();
            } else if (source == this.insertDrawingJMI) {
                this.insertDrawing();
            } else if (source == this.foliaJMI) {
                this.openFoliaFrame(null);
            } else if (source == this.drawingsJMI) {
                this.openDrawingsFrame(null);
            } else if (source == this.defineCitationJMI) {
                this.defineCitation();
            } else if (source == this.defineCruxJMI) {
                this.defineCrux();
            } else if (source == this.defineDateTokenJMI) {
                this.defineDateToken();
            } else if (source == this.defineEnunciatioJMI) {
                this.defineEnunciatio();
            } else if (source == this.defineExpunctioJMI) {
                this.defineExpunctio();
            } else if (source == this.defineMathConceptJMI) {
                this.defineMathConcept();
            } else if (source == this.defineNameJMI) {
                this.defineName();
            } else if (source == this.definePlaceJMI) {
                this.definePlace();
            } else if (source == this.defineWorkJMI) {
                this.defineWork();
            } else if (source == this.defineTongueJMI) {
                this.defineTongue();
            } else if (source == this.insertPartJMI) {
                this.insertPart();
            } else if (source == this.insertUnitJMI) {
                this.insertUnit();
            } else if (source == this.insertListItemJMI) {
                this.insertListItem();
            } else if (source == this.addIntegratioJMI) {
                this.addIntegratio();
            } else if (source == this.addAnnotationJMI) {
                this.addAnnotation();
            } else if (source == this.addImageJMI) {
                this.addImage();
            } else if (source == this.annotationsJMI) {
                this.openAnnotationsFrame(null);
            } else if (source == this.imagesJMI) {
                this.openImagesFrame(null);
            } else if (source == this.citationsJMI) {
                this.openCitationsFrame(null);
            } else if (source == this.crucesJMI) {
                this.openCrucesFrame(null);
            } else if (source == this.dateTokensJMI) {
                this.openDateTokensFrame(null);
            } else if (source == this.enunciationesJMI) {
                this.openEnunciationesFrame(null);
            } else if (source == this.expunctionesJMI) {
                this.openExpunctionesFrame(null);
            } else if (source == this.integrationesJMI) {
                this.openIntegrationesFrame(null);
            } else if (source == this.mathConceptsJMI) {
                this.openMathConceptsFrame(null);
            } else if (source == this.namesJMI) {
                this.openNamesFrame(null);
            } else if (source == this.placesJMI) {
                this.openPlacesFrame(null);
            } else if (source == this.textPartsJMI) {
                this.openTextPartsFrame(null);
            } else if (source == this.tonguesJMI) {
                this.openTonguesFrame(null);
            } else if (source == this.unitsJMI) {
                this.openUnitsFrame(null);
            } else if (source == this.worksJMI) {
                this.openWorksFrame(null);
            } else if (source == this.commentsJMI) {
                this.openCommentsFrame(null);
            } else if (source == this.addCommentJMI) {
                this.addComment();
            } else {
                JOptionPane.showMessageDialog(null, String.valueOf(this.unexpectedEventString) + ": " + evt.getActionCommand(), UIConstants.getInstance().errorString, 0);
            }
        }
        this.enableActions();
        this.validate();
        this.repaint();
    }

    private boolean handleLangMenu(Object source) {
        boolean handled = true;
        this.enableInputMethods(true);
        InputContext inputContext = this.getInputContext();
        if (source == this.latinJMI) {
            inputContext.selectInputMethod(this.getLocale());
            this.latinJMI.setSelected(true);
        } else if (source == this.greekJMI) {
            this.greekJMI.setSelected(true);
            inputContext.selectInputMethod(GREEK_LOCALE);
        } else {
            handled = false;
        }
        return handled;
    }

    private void findNext() {
        String match = this.finder.getLastSearch();
        int position = this.finder.find(match);
        if (position >= 0) {
            this.highlightText(position, match.length());
        }
    }

    @Override
    public EditionMapper getMapper() {
        return this.mapper;
    }

    @Override
    public Finder getFinder() {
        return this.finder;
    }

    @Override
    public TextPanel getTextPanel() {
        return this.textPanel;
    }

    @Override
    public ScriptoriumStyledDocument getStyledDocument() {
        ScriptoriumTextPane pane = this.textPanel.getScriptoriumTextPane();
        return pane.getScriptoriumStyledDocument();
    }

    @Override
    public void addComponentObserver(ComponentObserver observer) {
        this.observers.add(observer);
    }

    @Override
    public void removeComponentObserver(ComponentObserver observer) {
        this.observers.remove(observer);
    }

    @Override
    public void singleClickOn(ScriptoriumTextPane pane) {
        pane.getCaret().setVisible(true);
        int offset = IDE.getFocusedOffset(pane);
        EditionComponent<?> component = this.mapper.getComponentByOffset(offset);
        if (component != null) {
            for (ComponentObserver observer : this.observers) {
                if (observer == pane) continue;
                observer.selectComponent(component);
            }
        }
    }

    @Override
    public void doubleClickOn(ScriptoriumTextPane pane) {
        int offset = IDE.getFocusedOffset(pane);
        EditionComponent<?> component = this.mapper.getComponentByOffset(offset);
        OpenFrameVisitor openFrameVisitor = new OpenFrameVisitor(this);
        component.accept(openFrameVisitor);
    }

    @Override
    public <vC extends ValuedComposite<?>> void downgradeComponent(vC composite) {
        EditionComposite<?> parent = composite.getParent();
        parent.downgradeComponent(composite);
        parent.normalize();
        this.getTextPanel().updateText();
    }

    @Override
    public <eN extends EditionComponent<?>> void downgradeComponent(eN component) {
        EditionComposite<?> parent = component.getParent();
        parent.removeChild(component);
        parent.normalize();
        this.getTextPanel().updateText();
    }

    @Override
    public void valueChanged(VariantsPanel panel) {
        ScriptoriumTextPane pane = this.textPanel.getScriptoriumTextPane();
        Variant variant = panel.getSelectedVariant();
        pane.selectComponent(variant);
    }

    @Override
    public <T extends EditionComponent<?>> void valueChanged(ScriptoriumSelector<T> selector) {
        EditionComponent component = (EditionComponent)selector.getSelectedItem();
        this.textPanel.updateText();
        if (component != null && ScriptoriumTextPane.canShow(component)) {
            ScriptoriumTextPane pane = this.textPanel.getScriptoriumTextPane();
            pane.selectComponent(component);
        }
    }

    @Override
    public void valueChanged(VariantPanel panel) {
        this.variants_panel.reload();
    }

    @Override
    public void valueChanged(MetadataPanel panel) {
        this.setContentPaneTitle();
    }

    @Override
    public void updateSummaryPanel() {
        this.metadataSummaryPanel.setup();
    }

    @Override
    public void updateText() {
        this.getTextPanel().updateText();
    }

    @Override
    public void highlightText(int offset, int length) {
        this.getTextPanel().highlightText(offset, length);
    }

    public static void main(String[] argv) throws SAXException, ParserConfigurationException, IOException {
        IDE applet = new IDE();
        JFrame frame = new JFrame("ScriptoriumFrame");
        frame.setDefaultCloseOperation(3);
        frame.add(applet);
        applet.init();
        frame.setSize(800, 600);
        frame.setVisible(true);
    }

    @Override
    public Edition getEdition() {
        return this.edition;
    }
}

