/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui;

import java.awt.Color;
import java.util.List;
import javax.swing.border.LineBorder;
import org.homelinux.elabor.scriptorium.ecomponents.Edition;
import org.homelinux.elabor.scriptorium.ecomponents.Header;
import org.homelinux.elabor.scriptorium.ecomponents.Reference;
import org.homelinux.elabor.scriptorium.ecomponents.References;
import org.homelinux.elabor.scriptorium.gui.OldScriptoriumListArea;
import org.homelinux.elabor.scriptorium.gui.ReferenceFrame;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumDirector;
import org.homelinux.elabor.ui.DefaultGenericSelectionModel;

public class ReferencesPanel
extends OldScriptoriumListArea<Reference> {
    private static final long serialVersionUID = 1L;
    private References references;
    private ReferenceFrame referenceFrame;
    private DefaultGenericSelectionModel<Reference> referencesModel;

    public ReferencesPanel() {
        super(true, true, true);
        LineBorder lineBorder = new LineBorder(Color.black);
        this.setBorder(lineBorder);
    }

    @Override
    public void setup(ScriptoriumDirector director) {
        Edition edition = director.getEdition();
        Header header = edition.getHeader();
        this.references = header.getReferences();
        List<Reference> refsList = this.references.getReferences();
        this.referencesModel = new DefaultGenericSelectionModel<Reference>(refsList);
        super.setup(this.referencesModel);
    }

    private void openReferenceFrame(int index) {
        if (this.referenceFrame == null) {
            this.referenceFrame = new ReferenceFrame();
        }
        this.referenceFrame.setup(this.references, this.referencesModel, index);
    }

    @Override
    public void addAction() {
        this.openReferenceFrame(-1);
    }

    @Override
    public void remAction(int index, Reference reference) {
        this.references.removeReference(reference);
        this.referencesModel.removeElementAt(index);
    }

    @Override
    public void editAction(int index, Reference reference) {
        this.openReferenceFrame(index);
    }

    @Override
    public boolean closing() {
        if (this.referenceFrame != null) {
            this.referenceFrame.dispose();
        }
        return super.closing();
    }
}

