/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import org.homelinux.elabor.scriptorium.gui.Panel;
import org.homelinux.elabor.scriptorium.gui.Preferences;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumDirector;
import org.homelinux.elabor.tools.MessageCatalog;
import org.homelinux.elabor.ui.UITools;

public class ScriptoriumFrame<P extends Component>
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private P panel;
    private JButton okButton;

    public ScriptoriumFrame() {
    }

    public ScriptoriumFrame(P panel) {
        this.setPanel(panel);
    }

    public void setPanel(P panel) {
        MessageCatalog catalog = new MessageCatalog();
        Preferences preferences = Preferences.getInstance();
        String locale = preferences.getProperty("locale");
        Class<?> panelClass = panel.getClass();
        String className = panelClass.getName();
        catalog.loadCatalog(className, locale);
        this.panel = panel;
        this.setTitle(catalog.translate("titleString"));
        this.okButton = new JButton(catalog.translate("okString"));
        this.okButton.setToolTipText(catalog.translate("okTooltip"));
        this.okButton.addActionListener(this);
        Container content = this.getContentPane();
        content.setLayout(new GridBagLayout());
        UITools.addComponent(content, this.panel, 0, 0, 1, 1, 100, 100, 1, 0);
        UITools.addComponent(content, this.okButton, 0, 1, 1, 1, 1, 1, 0, 5);
    }

    public void setup(ScriptoriumDirector director) {
        ((Panel)this.getPanel()).setup(director);
        this.setVisible(true);
    }

    public P getPanel() {
        return this.panel;
    }

    @Override
    public void dispose() {
        if (((Panel)this.panel).closing()) {
            super.dispose();
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.okButton) {
            ((Panel)this.panel).callDefaultAction(this);
        }
    }
}

