/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTextPane;
import org.homelinux.elabor.scriptorium.ecomponents.EditionComponent;
import org.homelinux.elabor.scriptorium.ecomponents.EditionMapper;
import org.homelinux.elabor.scriptorium.ecomponents.TextPart;
import org.homelinux.elabor.scriptorium.ecomponents.Unit;
import org.homelinux.elabor.scriptorium.ecomponents.Variant;
import org.homelinux.elabor.scriptorium.gui.ComponentObserver;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumDirector;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumStyledDocument;

public class ScriptoriumTextPane
extends JTextPane
implements ComponentObserver {
    public static final long serialVersionUID = 1L;
    private ScriptoriumDirector director;
    private List<String> plainComponents;

    public ScriptoriumTextPane(ScriptoriumStyledDocument document) {
        this(null, document);
    }

    public ScriptoriumTextPane(ScriptoriumDirector director, ScriptoriumStyledDocument document) {
        super(document);
        this.director = director;
        this.plainComponents = new ArrayList<String>();
        this.plainComponents.add("text");
        this.plainComponents.add("drawing");
        this.plainComponents.add("comment");
    }

    public ScriptoriumStyledDocument getScriptoriumStyledDocument() {
        return (ScriptoriumStyledDocument)this.getStyledDocument();
    }

    private boolean isHighlightableComponent(EditionComponent<?> component) {
        boolean result = true;
        if (component == null) {
            result = false;
        } else if (this.plainComponents.contains(component.getElementName())) {
            result = false;
        }
        return result;
    }

    public static boolean canShow(EditionComponent<?> component) {
        String elementName = component.getElementName();
        return !elementName.equals("witness");
    }

    @Override
    public void selectComponent(EditionComponent<?> component) {
        if (this.director != null && component != null) {
            EditionComponent<?> sibling;
            EditionMapper mapper = this.director.getMapper();
            int offset = mapper.getComponentOffset(component);
            int length = component.getTextLength();
            if (component instanceof Variant && (sibling = component.getNextComponent()) != null) {
                length = mapper.getComponentOffset(component.getNextComponent()) - offset;
            }
            if (this.isHighlightableComponent(component)) {
                this.highlightText(offset, length);
            } else {
                this.setCaretPosition(offset);
                this.getCaret().setVisible(true);
            }
        }
    }

    public void highlightText(int offset, int length) {
        this.requestFocus();
        this.setSelectionColor(Color.yellow);
        this.setCaretPosition(offset);
        this.moveCaretPosition(offset + length);
    }

    public void highligthUnit(EditionMapper mapper, Unit unit) {
        int offset = mapper.getComponentOffset(unit);
        int length = unit.getTextLength();
        this.highlightText(offset, length);
    }

    public void highligthPart(EditionMapper mapper, TextPart part) {
        int offset = mapper.getComponentOffset(part);
        int length = part.getTextLength();
        this.highlightText(offset, length);
    }

    public void setDefaultFont(String font_name) {
        ScriptoriumStyledDocument ssd = this.getScriptoriumStyledDocument();
        ssd.setDefaultFont(font_name);
    }
}

