/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui;

import java.awt.GridBagLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.Caret;
import org.homelinux.elabor.scriptorium.definers.Definer;
import org.homelinux.elabor.scriptorium.definers.InvalidTokenDefinition;
import org.homelinux.elabor.scriptorium.ecomponents.Edition;
import org.homelinux.elabor.scriptorium.ecomponents.EditionComponent;
import org.homelinux.elabor.scriptorium.gui.Preferences;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumDirector;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumStyledDocument;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumTextPane;
import org.homelinux.elabor.tools.MessageCatalog;
import org.homelinux.elabor.ui.UIConstants;
import org.homelinux.elabor.ui.UITools;

public class TextPanel
extends JPanel
implements MouseListener {
    public static final long serialVersionUID = 0L;
    private ScriptoriumDirector director;
    private String invalidMarkup;
    private ScriptoriumTextPane pane;

    public TextPanel(ScriptoriumDirector director) {
        this.initLocale();
        this.director = director;
        this.loadContentPane();
        this.lockBasicText();
        JScrollPane scrollPane = new JScrollPane(this.pane);
        this.setLayout(new GridBagLayout());
        UITools.addComponent(this, scrollPane, 0, 1, 1, 1, 100, 100, 1, 0);
    }

    private void initLocale() {
        MessageCatalog catalog = new MessageCatalog();
        String locale = Preferences.getInstance().getProperty("locale");
        catalog.loadCatalog(this.getClass().getName(), locale);
        this.invalidMarkup = catalog.translate("invalidMarkup");
    }

    private void loadContentPane() {
        Edition edition = this.director.getEdition();
        ScriptoriumStyledDocument document = new ScriptoriumStyledDocument(edition);
        this.pane = new ScriptoriumTextPane(this.director, document);
        this.director.addComponentObserver(this.pane);
        this.pane.addMouseListener(this);
    }

    public void setCaretPosition(int position) {
        this.pane.setCaretPosition(position);
        this.pane.getCaret().setVisible(true);
    }

    public int getCaretPosition() {
        return this.pane.getCaretPosition();
    }

    public void highlightText(int offset, int length) {
        this.pane.highlightText(offset, length);
        this.pane.getCaret().setVisible(true);
    }

    public ScriptoriumTextPane getScriptoriumTextPane() {
        return this.pane;
    }

    public void dispose() {
        this.pane = null;
    }

    public void setDefaultFont(String font_name) {
        this.pane.setDefaultFont(font_name);
    }

    public void lockBasicText() {
        this.pane.setEditable(false);
        this.pane.getCaret().setVisible(true);
    }

    public void unlockBasicText() {
        this.pane.setEditable(true);
    }

    public boolean isBasicTextLocked() {
        return !this.pane.isEditable();
    }

    public void uploadBasicText(String text) {
        this.unlockBasicText();
        this.getScriptoriumTextPane().setText(text);
        this.lockBasicText();
    }

    public <eC extends EditionComponent<?>> eC defineToken(Definer<eC> tokenDefiner) {
        eC token = null;
        Caret caret = this.pane.getCaret();
        int offset = Math.min(caret.getDot(), caret.getMark());
        int length = Math.max(caret.getDot(), caret.getMark()) - offset;
        if (tokenDefiner.validate(length)) {
            try {
                token = tokenDefiner.defineToken(offset, length);
            }
            catch (InvalidTokenDefinition e) {
                JOptionPane.showMessageDialog(null, tokenDefiner.getCheckErrorMessage(), this.invalidMarkup, 1);
            }
        } else {
            JOptionPane.showMessageDialog(null, tokenDefiner.getCheckErrorMessage(), UIConstants.getInstance().attentionString, 1);
        }
        caret.setVisible(true);
        return token;
    }

    public void updateText() {
        int position = this.getCaretPosition();
        this.pane.getScriptoriumStyledDocument().fillStyledDocument();
        this.setCaretPosition(position);
    }

    public void cut() {
        this.pane.cut();
    }

    public void copy() {
        this.pane.copy();
    }

    public void paste() {
        this.pane.paste();
    }

    public void delete() {
        this.pane.replaceSelection(null);
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        switch (event.getClickCount()) {
            case 1: {
                this.director.singleClickOn(this.pane);
                break;
            }
            case 2: {
                this.director.doubleClickOn(this.pane);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
    }

    @Override
    public void mouseReleased(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }
}

