/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui.citations;

import java.awt.Color;
import java.awt.GridBagLayout;
import java.io.File;
import java.util.List;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.homelinux.elabor.scriptorium.ecomponents.Content;
import org.homelinux.elabor.scriptorium.ecomponents.Edition;
import org.homelinux.elabor.scriptorium.ecomponents.EditionComponent;
import org.homelinux.elabor.scriptorium.ecomponents.EditionMapper;
import org.homelinux.elabor.scriptorium.ecomponents.Reference;
import org.homelinux.elabor.scriptorium.ecomponents.Unit;
import org.homelinux.elabor.scriptorium.gui.Preferences;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumPanel;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumStyledDocument;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumTextPane;
import org.homelinux.elabor.scriptorium.gui.citations.CitationPanel;
import org.homelinux.elabor.scriptorium.services.EditionManager;
import org.homelinux.elabor.tools.MessageCatalog;
import org.homelinux.elabor.ui.DefaultGenericSelectionModel;
import org.homelinux.elabor.ui.UIConstants;
import org.homelinux.elabor.ui.UITools;

public class PropositionChooserPanel
extends ScriptoriumPanel<EditionComponent<?>>
implements ListSelectionListener {
    private static final long serialVersionUID = 1L;
    private CitationPanel citationPanel;
    private ScriptoriumTextPane textPane;
    private JScrollPane scrollPane;
    private JList<Unit> unitList;
    private Edition edition;
    private EditionMapper mapper;
    private DefaultGenericSelectionModel<Unit> unitListModel;
    String filenameNotSpecifiedString;
    String saxErrorString;
    private final EditionManager editionManager;

    public PropositionChooserPanel() {
        this.initLocale();
        this.scrollPane = new JScrollPane();
        this.unitList = new JList();
        JScrollPane scroll_list = new JScrollPane(this.unitList);
        this.setLayout(new GridBagLayout());
        this.setBorder(new LineBorder(Color.black));
        UITools.addComponent(this, scroll_list, 0, 0, 1, 1, 5, 1, 1, 2);
        UITools.addComponent(this, this.scrollPane, 1, 0, 1, 1, 100, 1, 1, 2);
        this.editionManager = EditionManager.getInstance();
    }

    private void initLocale() {
        MessageCatalog catalog = new MessageCatalog();
        String locale = Preferences.getInstance().getProperty("locale");
        catalog.loadCatalog(this.getClass().getName(), locale);
        this.filenameNotSpecifiedString = catalog.translate("noFileName");
        this.saxErrorString = catalog.translate("saxError");
    }

    public void setup(CitationPanel citation_panel) {
        this.citationPanel = citation_panel;
        Reference reference = this.citationPanel.getSelectedReference();
        if (reference == null) {
            JOptionPane.showMessageDialog(null, this.filenameNotSpecifiedString, UIConstants.getInstance().attentionString, 2);
        } else {
            String edition_file_name = reference.getFileName();
            File edition_file = new File(edition_file_name);
            this.edition = this.loadEdition(edition_file);
            this.loadIndex(this.citationPanel.getProposition() - 1);
        }
    }

    private Edition loadEdition(File edition_file) {
        Edition loadedEdition = null;
        loadedEdition = this.editionManager.loadEdition(edition_file);
        this.mapper = new EditionMapper(loadedEdition);
        ScriptoriumStyledDocument document = new ScriptoriumStyledDocument(loadedEdition);
        this.textPane = new ScriptoriumTextPane(document);
        this.scrollPane.setViewportView(this.textPane);
        return loadedEdition;
    }

    private void loadIndex(int index) {
        Content content = this.edition.getContent();
        this.unitList.removeListSelectionListener(this);
        List<Unit> units = content.getUnits();
        this.unitListModel = new DefaultGenericSelectionModel<Unit>(units);
        this.unitList.setModel(this.unitListModel);
        this.unitList.addListSelectionListener(this);
        if (index >= 0 && index < this.unitListModel.getSize()) {
            this.unitList.setSelectedIndex(index);
        }
    }

    @Override
    public boolean okAction() {
        int unit_number;
        int index = this.unitList.getSelectedIndex();
        if (index >= 0) {
            Unit unit = this.unitListModel.get(index);
            unit_number = unit.getOrder();
        } else {
            unit_number = -1;
        }
        this.citationPanel.setProposition(unit_number);
        return super.okAction();
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
        int index = this.unitList.getSelectedIndex();
        Unit selected_unit = this.edition.getContent().getUnits().get(index);
        this.textPane.highligthUnit(this.mapper, selected_unit);
    }
}

