/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui.drawings;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotUndoException;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.ScriptoriumPoint;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.ScriptoriumShape;
import org.homelinux.elabor.scriptorium.gui.drawings.DefaultDrawingDirector;

abstract class AbstractEdit
extends AbstractUndoableEdit {
    private static final long serialVersionUID = 1L;
    private DefaultDrawingDirector drawingDirector;
    private ScriptoriumPoint previousPoint;
    private ScriptoriumShape previousShape;

    public AbstractEdit(DefaultDrawingDirector drawingDirector, ScriptoriumPoint previousPoint, ScriptoriumShape previousShape) {
        this.drawingDirector = drawingDirector;
        this.previousPoint = previousPoint;
        this.previousShape = previousShape;
    }

    @Override
    public void undo() throws CannotUndoException {
        if (this.previousPoint == null) {
            if (this.previousShape == null) {
                this.unselectAllAction();
            } else {
                this.selectShapeAction(this.previousShape);
            }
        } else {
            this.selectPointAction(this.previousPoint);
        }
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    public void selectPointAction(ScriptoriumPoint point) {
        this.drawingDirector.selectPointAction(point);
    }

    public void selectShapeAction(ScriptoriumShape shape) {
        this.drawingDirector.selectShapeAction(shape);
    }

    public void unselectAllAction() {
        this.drawingDirector.unselectAllAction();
    }
}

