/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui.drawings;

import java.awt.Color;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.homelinux.elabor.itools.Tools;
import org.homelinux.elabor.scriptorium.ecomponents.EditionComponent;
import org.homelinux.elabor.scriptorium.gui.Preferences;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumFrame;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumPanel;
import org.homelinux.elabor.scriptorium.gui.drawings.DrawingDirector;
import org.homelinux.elabor.tools.MessageCatalog;
import org.homelinux.elabor.ui.UITools;

public class AttributesPanel
extends ScriptoriumPanel<EditionComponent<?>> {
    static final long serialVersionUID = 1L;
    private DrawingDirector director;
    private JTextField captionField;
    private JLabel captionLabel;
    private String captionString;
    private JTextField descriptionField;
    private JLabel descriptionLabel;
    private String descriptionString;

    public AttributesPanel(ScriptoriumFrame<?> frame) {
        this.initLocale();
        Preferences preferences = Preferences.getInstance();
        int fieldFontSize = preferences.getInteger("text_fields_font_size");
        int labelFontSize = preferences.getInteger("label_font_size");
        Color editableBgColor = preferences.getColor("text_fields_editable_bg_color");
        this.captionField = Tools.setupTextField(this, fieldFontSize, editableBgColor, frame);
        this.captionLabel = UITools.setupLabel(this.captionString, labelFontSize);
        this.descriptionField = Tools.setupTextField(this, fieldFontSize, editableBgColor, frame);
        this.descriptionLabel = UITools.setupLabel(this.descriptionString, labelFontSize);
        this.setLayout(new GridBagLayout());
        UITools.addComponent(this, this.captionLabel, 0, 0, 1, 1, 1, 100, 2, 2);
        UITools.addComponent(this, this.captionField, 1, 0, 1, 1, 100, 100, 2, 2);
        UITools.addComponent(this, this.descriptionLabel, 0, 1, 1, 1, 1, 100, 2, 2);
        UITools.addComponent(this, this.descriptionField, 1, 1, 1, 1, 100, 100, 2, 2);
    }

    private void initLocale() {
        MessageCatalog catalog = new MessageCatalog();
        String locale = Preferences.getInstance().getProperty("locale");
        catalog.loadCatalog(this.getClass().getName(), locale);
        this.captionString = catalog.translate("caption");
        this.descriptionString = catalog.translate("description");
    }

    public void setup(DrawingDirector director) {
        this.director = director;
        String caption = director.getCaption();
        String description = director.getDescription();
        this.captionField.setText(caption);
        this.descriptionField.setText(description);
    }

    @Override
    public boolean okAction() {
        String caption = this.captionField.getText();
        String description = this.descriptionField.getText();
        this.director.setAttributes(caption, description);
        return true;
    }
}

