/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui.drawings;

import java.awt.Color;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import org.homelinux.elabor.itools.DefaultPanel;
import org.homelinux.elabor.itools.Tools;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.Transform;
import org.homelinux.elabor.scriptorium.gui.Preferences;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumFrame;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumPanel;
import org.homelinux.elabor.scriptorium.gui.drawings.DrawingDirector;
import org.homelinux.elabor.tools.MessageCatalog;
import org.homelinux.elabor.ui.UITools;

public class BackgroundTransformPanel
extends ScriptoriumPanel<Transform> {
    private static final long serialVersionUID = 1L;
    private String magnificationLabelString;
    private String xTranslationLabelString;
    private String yTranslationLabelString;
    private String rotationLabelString;
    private JTextField magnificationField;
    private JTextField xTranslationField;
    private JTextField yTranslationField;
    private JTextField rotationField;
    private DrawingDirector director;
    private Transform transform;

    public BackgroundTransformPanel(ScriptoriumFrame<?> frame) {
        this.initLocale();
        Preferences preferences = Preferences.getInstance();
        int fontSize = preferences.getInteger("text_fields_font_size");
        Color editableBgColor = preferences.getColor("text_fields_editable_bg_color");
        JLabel magnification_label = new JLabel(this.magnificationLabelString, 4);
        this.magnificationField = Tools.setupTextField(this, fontSize, editableBgColor, frame);
        JLabel x_translation_label = new JLabel(this.xTranslationLabelString, 4);
        this.xTranslationField = Tools.setupTextField(this, fontSize, editableBgColor, frame);
        JLabel y_translation_label = new JLabel(this.yTranslationLabelString, 4);
        this.yTranslationField = Tools.setupTextField(this, fontSize, editableBgColor, frame);
        JLabel rotation_label = new JLabel(this.rotationLabelString, 4);
        this.rotationField = Tools.setupTextField(this, fontSize, editableBgColor, frame);
        this.setLayout(new GridBagLayout());
        this.setBorder(new LineBorder(Color.black));
        UITools.addComponent(this, magnification_label, 0, 0, 1, 1, 0, 0, 2, 2);
        UITools.addComponent(this, this.magnificationField, 1, 0, 1, 1, 100, 1, 2, 2);
        UITools.addComponent(this, x_translation_label, 0, 1, 1, 1, 0, 0, 2, 2);
        UITools.addComponent(this, this.xTranslationField, 1, 1, 1, 1, 100, 1, 2, 2);
        UITools.addComponent(this, y_translation_label, 0, 2, 1, 1, 0, 0, 2, 2);
        UITools.addComponent(this, this.yTranslationField, 1, 2, 1, 1, 100, 1, 2, 2);
        UITools.addComponent(this, rotation_label, 0, 3, 1, 1, 0, 0, 2, 2);
        UITools.addComponent(this, this.rotationField, 1, 3, 1, 1, 100, 1, 2, 2);
    }

    private void initLocale() {
        MessageCatalog catalog = new MessageCatalog();
        String locale = Preferences.getInstance().getProperty("locale");
        catalog.loadCatalog(this.getClass().getName(), locale);
        this.magnificationLabelString = catalog.translate("magnificationLabel");
        this.xTranslationLabelString = catalog.translate("xTranslationLabel");
        this.yTranslationLabelString = catalog.translate("yTranslationLabel");
        this.rotationLabelString = catalog.translate("rotationLabel");
    }

    public void setup(DrawingDirector drawingDirector) {
        this.director = drawingDirector;
        this.transform = this.director.getBackgroundTransform();
        this.magnificationField.setText(String.valueOf(this.transform.getMagnification()));
        this.xTranslationField.setText(String.valueOf(this.transform.getXTranslation()));
        this.yTranslationField.setText(String.valueOf(this.transform.getYTranslation()));
        this.rotationField.setText(String.valueOf(this.transform.getRotation()));
    }

    @Override
    public boolean okAction() {
        boolean ok;
        String xText = this.xTranslationField.getText();
        DefaultPanel.CheckDoubleField checkX = this.checkDoubleField(xText, this.xTranslationLabelString);
        String yText = this.yTranslationField.getText();
        DefaultPanel.CheckDoubleField checkY = this.checkDoubleField(yText, this.yTranslationLabelString);
        String magText = this.magnificationField.getText();
        DefaultPanel.CheckDoubleField checkMag = this.checkDoubleField(magText, this.magnificationLabelString);
        String rotText = this.rotationField.getText();
        DefaultPanel.CheckDoubleField checkRot = this.checkDoubleField(rotText, this.rotationLabelString);
        boolean bl = ok = checkX.ok && checkY.ok && checkMag.ok && checkRot.ok;
        if (ok) {
            this.director.setBackgroundTransform(checkX.value, checkY.value, checkMag.value, checkRot.value);
        }
        return ok;
    }
}

