/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui.drawings;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;
import org.homelinux.elabor.file.FileSystemTools;
import org.homelinux.elabor.scriptorium.ecomponents.Edition;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.BackgroundImage;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.Drawing;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.Glyph;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.GlyphGroup;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.LoadStylesException;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.AbstractPointReference;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.PointReference;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.ScriptoriumPoint;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.AbstractShape;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.Arc;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.Bezier;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.CircleByCenter;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.Ellipse;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.EllipseByPoints;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.Line;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.ScriptoriumShape;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.styles.ScriptoriumStyle;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.styles.StyleSet;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.styles.StyleSetReference;
import org.homelinux.elabor.scriptorium.ecomponents.visitors.SelectGlyphVisitor;
import org.homelinux.elabor.scriptorium.gui.Preferences;
import org.homelinux.elabor.scriptorium.gui.drawings.AbstractDrawingDirector;
import org.homelinux.elabor.scriptorium.gui.drawings.AddPointEffect;
import org.homelinux.elabor.scriptorium.gui.drawings.ChangePointLabelRectangleEffect;
import org.homelinux.elabor.scriptorium.gui.drawings.DrawingArea;
import org.homelinux.elabor.scriptorium.gui.drawings.DrawingPalette;
import org.homelinux.elabor.scriptorium.gui.drawings.DrawingTitleListener;
import org.homelinux.elabor.scriptorium.gui.drawings.MovePointEffect;
import org.homelinux.elabor.scriptorium.gui.drawings.RemovePointEffect;
import org.homelinux.elabor.scriptorium.gui.drawings.SelectManager;
import org.homelinux.elabor.scriptorium.gui.drawings.UndoAdapter;
import org.homelinux.elabor.scriptorium.gui.drawings.groups.GroupsArea;
import org.homelinux.elabor.scriptorium.gui.drawings.groups.GroupsModelAdaptor;
import org.homelinux.elabor.scriptorium.gui.drawings.points.PointPanel;
import org.homelinux.elabor.scriptorium.gui.drawings.points.PointsArea;
import org.homelinux.elabor.scriptorium.gui.drawings.shapes.ActionsArea;
import org.homelinux.elabor.scriptorium.gui.drawings.shapes.ShapeCreateVisitor;
import org.homelinux.elabor.scriptorium.gui.drawings.shapes.ShapeGUI;
import org.homelinux.elabor.scriptorium.gui.drawings.shapes.ShapesArea;
import org.homelinux.elabor.scriptorium.gui.drawings.shapes.ShapesModelAdaptor;
import org.homelinux.elabor.scriptorium.services.EditionManager;
import org.homelinux.elabor.tools.MessageCatalog;
import org.homelinux.elabor.ui.DefaultGenericSelectionModel;
import org.homelinux.elabor.ui.GenericSelectionModel;
import org.homelinux.elabor.ui.Selector;
import org.homelinux.elabor.ui.UIConstants;
import org.homelinux.elabor.ui.panel.ListArea;

public class DefaultDrawingDirector
extends AbstractDrawingDirector {
    private static final long serialVersionUID = 1L;
    private ListArea<?> shapesArea;
    private GroupsArea groupsArea;
    private ShapesModelAdaptor shapesModel;
    private GroupsModelAdaptor groupsModel;
    private GenericSelectionModel<ScriptoriumStyle> stylesModel;
    private DrawingPalette drawingPalette;
    private boolean editionChanged;
    private boolean stylesetChanged;
    private StyleSet styleset;
    private List<DrawingTitleListener> drawingListeners;
    private String pointString;
    private String shapeString;
    private String belongsString;
    private String curvesString;
    private String groupsString;
    private String removeString;
    private String removeImpossibleString;
    private String undoImpossisbleString;
    private String wantRemoveString;
    private UndoManager undoManager;
    private UndoableEditSupport undoSupport;
    private SelectManager selectManager;
    private boolean selectMode;
    private int pointSelectionDistance;

    public DefaultDrawingDirector(int pointSelectionDistance) {
        this.pointSelectionDistance = pointSelectionDistance;
        this.initLocale();
        this.drawingListeners = new ArrayList<DrawingTitleListener>();
        this.setupUndoSysyem();
    }

    private void initLocale() {
        MessageCatalog catalog = new MessageCatalog();
        Preferences preferences = Preferences.getInstance();
        String locale = preferences.getProperty("locale");
        catalog.loadCatalog(this.getClass().getName(), locale);
        this.pointString = catalog.translate("point");
        this.shapeString = catalog.translate("shape");
        this.belongsString = catalog.translate("belongs");
        this.curvesString = catalog.translate("curves");
        this.groupsString = catalog.translate("groups");
        this.removeString = catalog.translate("remove");
        this.removeImpossibleString = catalog.translate("removeImpossible");
        this.undoImpossisbleString = catalog.translate("undoImpossisble");
        this.wantRemoveString = catalog.translate("wantRemove");
    }

    private void setupUndoSysyem() {
        this.undoManager = new UndoManager();
        this.undoManager.setLimit(20);
        this.undoSupport = new UndoableEditSupport();
        UndoAdapter undoAdapter = new UndoAdapter(this.undoManager);
        this.undoSupport.addUndoableEditListener(undoAdapter);
        this.selectManager = new SelectManager(this, this.undoSupport);
    }

    @Override
    public void setup(Drawing drawing, PointsArea pointsArea, ShapesArea shapesArea, ActionsArea actionsArea, GroupsArea groupsArea, DrawingArea drawingArea, DrawingPalette drawingPalette) {
        this.setDrawing(drawing);
        drawing.setListener(this);
        this.setDrawingArea(drawingArea);
        this.shapesArea = shapesArea;
        this.groupsArea = groupsArea;
        this.pointsManager.setDrawing(this, drawing, pointsArea);
        this.shapesModel = new ShapesModelAdaptor(drawing, this.shapesArea);
        this.setupStylesetFromDrawing();
        this.groupsModel = new GroupsModelAdaptor(drawing, (Selector)this.groupsArea);
        this.drawingPalette = drawingPalette;
        this.setSelectMode(true);
    }

    @Override
    public void addStyleListener(DrawingTitleListener drawingListener) {
        this.drawingListeners.add(drawingListener);
    }

    @Override
    public StyleSet getStyleset() {
        return this.styleset;
    }

    @Override
    public void setStylesetChanged(boolean modified) {
        this.stylesetChanged = modified;
        StyleSetReference stylesetReference = this.drawing.getStylesetReference();
        for (DrawingTitleListener listener : this.drawingListeners) {
            listener.stylesetChanged(stylesetReference);
        }
    }

    @Override
    public boolean isStylesetChanged() {
        return this.stylesetChanged;
    }

    public void loadStyleset(Edition edition) {
        EditionManager editionManager = EditionManager.getInstance();
        StyleSet newStyleset = editionManager.loadStyleset();
        if (newStyleset != null) {
            this.styleset = newStyleset;
            StyleSetReference styleSetReference = this.drawing.getStylesetReference();
            File file = this.styleset.getFile();
            File stylesetDefaultFolder = EditionManager.getStylesetDefaultFolder(edition);
            URI fileURI = FileSystemTools.getRelativeURI(stylesetDefaultFolder, file);
            styleSetReference.setUri(fileURI);
            this.setupStyleset();
        }
    }

    public void saveStyleset() {
        EditionManager manager;
        boolean ok;
        String suggestedName = null;
        File file = this.styleset.getFile();
        if (file != null) {
            suggestedName = file.getName();
        }
        if (ok = (manager = EditionManager.getInstance()).saveStyleset(this.styleset, true, suggestedName)) {
            file = this.styleset.getFile();
            Edition edition = this.drawing.getEdition();
            File stylesetDefaultFolder = EditionManager.getStylesetDefaultFolder(edition);
            URI fileURI = FileSystemTools.getRelativeURI(stylesetDefaultFolder, file);
            StyleSetReference stylesetReference = this.drawing.getStylesetReference();
            stylesetReference.setUri(fileURI);
            this.setStylesetChanged(false);
        }
    }

    private void setupStylesetFromDrawing() {
        EditionManager editionManager = EditionManager.getInstance();
        StyleSetReference stylesetReference = this.drawing.getStylesetReference();
        try {
            this.styleset = editionManager.loadStyleset(stylesetReference);
        }
        catch (LoadStylesException e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), UIConstants.getInstance().errorString, 0);
        }
        this.setupStyleset();
    }

    public void setupStyleset() {
        List<ScriptoriumStyle> styles = this.styleset.getStyles();
        this.stylesModel = new DefaultGenericSelectionModel<ScriptoriumStyle>(styles);
        DrawingArea drawingArea = this.getDrawingArea();
        if (drawingArea != null) {
            drawingArea.repaint();
        }
        this.pointsManager.reloadStyles();
        this.setStylesetChanged(false);
    }

    @Override
    public void editionChanged(UndoableEdit undoEdit) {
        this.editionChanged = true;
        for (DrawingTitleListener listener : this.drawingListeners) {
            listener.drawingChanged();
        }
        this.pointsManager.updatePointPanel();
        if (undoEdit != null) {
            this.undoSupport.postEdit(undoEdit);
        }
        this.repaintMainWindow();
    }

    @Override
    public void resetEditionChanged() {
        this.editionChanged = false;
    }

    @Override
    public boolean isEditionChanged() {
        return this.editionChanged;
    }

    @Override
    public void setSelectMode(boolean selectMode) {
        this.selectMode = selectMode;
        DrawingArea drawingArea = this.getDrawingArea();
        drawingArea.setSelectMode(selectMode);
        this.drawingPalette.setSelectMode(selectMode);
    }

    private boolean isSelectMode() {
        return this.selectMode;
    }

    @Override
    public Dimension2D getDrawingDimension() {
        DrawingArea drawingArea = this.getDrawingArea();
        return drawingArea.getSize();
    }

    @Override
    public Iterable<ScriptoriumPoint> getPoints() {
        return this.pointsManager;
    }

    @Override
    public GenericSelectionModel<ScriptoriumShape> getShapesModel() {
        return this.shapesModel;
    }

    @Override
    public GenericSelectionModel<ScriptoriumPoint> getPointsModel() {
        return this.pointsManager.getPointsModel();
    }

    @Override
    public GenericSelectionModel<GlyphGroup> getGroupsModel() {
        return this.groupsModel;
    }

    @Override
    public void setPointPanel(PointPanel pointPanel) {
        this.pointsManager.setPointPanel(pointPanel);
    }

    @Override
    public void repaintMainWindow() {
        this.getDrawingArea().repaint();
        this.pointsManager.repaint();
        this.shapesArea.repaint();
        this.groupsArea.repaint();
    }

    public static List<ShapeGUI> getShapeGUIs() {
        ArrayList<ShapeGUI> shapeGUIs = new ArrayList<ShapeGUI>();
        shapeGUIs.add(new ShapeGUI(new Line()));
        shapeGUIs.add(new ShapeGUI(new CircleByCenter()));
        shapeGUIs.add(new ShapeGUI(new Ellipse()));
        shapeGUIs.add(new ShapeGUI(new EllipseByPoints()));
        shapeGUIs.add(new ShapeGUI(new Arc()));
        shapeGUIs.add(new ShapeGUI(new Bezier()));
        return shapeGUIs;
    }

    @Override
    public GenericSelectionModel<ScriptoriumStyle> getStylesModel() {
        return this.stylesModel;
    }

    @Override
    public Iterator<ScriptoriumStyle> getStyles() {
        return this.stylesModel.iterator();
    }

    @Override
    public void reloadGrid() {
        DrawingArea drawingArea = this.getDrawingArea();
        drawingArea.drawGrid();
    }

    @Override
    public void setSelectedShape(ScriptoriumShape shape) {
        this.shapesModel.setSelectedItem(shape, true);
    }

    @Override
    public void selectedShape(ScriptoriumShape shape, boolean notify) {
        this.shapesModel.addSelectedItem(shape, notify);
    }

    @Override
    public void setSelectedPoint(ScriptoriumPoint point) {
        this.pointsManager.setSelectedItem(point, true);
    }

    @Override
    public void selectedPoint(ScriptoriumPoint point, boolean notify) {
        this.pointsManager.addSelectedItem(point, notify);
    }

    @Override
    public void unselectAll() {
        this.pointsManager.setSelectedItem(null, true);
        this.shapesModel.setSelectedItem(null, true);
    }

    @Override
    public void selectShapeAction(ScriptoriumShape shape) {
        this.pointsManager.setSelectedItem(null, false);
        this.selectManager.setSelectedPoint(null);
        this.shapesModel.setSelectedItem(shape, false);
        this.selectManager.setSelectedShape(shape);
        this.postSelectionAction();
    }

    @Override
    public void selectPointAction(ScriptoriumPoint point) {
        this.shapesModel.setSelectedItem(null, false);
        this.selectManager.setSelectedShape(null);
        this.pointsManager.setSelectedItem(point, false);
        this.selectManager.setSelectedPoint(point);
        this.postSelectionAction();
    }

    @Override
    public void unselectAllAction() {
        this.pointsManager.setSelectedItem(null, false);
        this.selectManager.setSelectedPoint(null);
        this.shapesModel.setSelectedItem(null, false);
        this.selectManager.setSelectedShape(null);
        this.postSelectionAction();
    }

    @Override
    public void recordPointMove(ScriptoriumPoint point, Point2D newPosition) {
        double oldX = point.getX();
        double oldY = point.getY();
        double newX = newPosition.getX();
        double newY = newPosition.getY();
        MovePointEffect effect = new MovePointEffect(point, oldX, oldY, newX, newY);
        this.undoSupport.postEdit(effect);
    }

    @Override
    public void recordChangePointLabelRectangle(ScriptoriumPoint point, double oldLlX, double oldLlY, double oldUrX, double oldUrY, double newLlX, double newLlY, double newUrX, double newUrY) {
        ChangePointLabelRectangleEffect effect = new ChangePointLabelRectangleEffect(point, oldLlX, oldLlY, oldUrX, oldUrY, newLlX, newLlY, newUrX, newUrY);
        this.undoSupport.postEdit(effect);
    }

    public void undo() {
        this.undoManager.undo();
    }

    public void redo() {
        this.undoManager.redo();
    }

    @Override
    public ScriptoriumPoint getSelectedPoint() {
        return this.pointsManager.getSelectedItem();
    }

    @Override
    public List<ScriptoriumPoint> getSelectedPoints() {
        return this.pointsManager.getSelectedItems();
    }

    @Override
    public GlyphGroup getSelectedGroup() {
        return (GlyphGroup)this.groupsModel.getSelectedElement();
    }

    @Override
    public GlyphGroup addGroup(List<Glyph> glyphs) {
        GlyphGroup group = new GlyphGroup(this.drawing);
        group.setName("new group");
        for (Glyph glyph : glyphs) {
            group.addGlyph(glyph);
        }
        this.groupsModel.append(group);
        return group;
    }

    @Override
    public void removeGroup(GlyphGroup group) {
        this.groupsModel.removeElement(group);
    }

    @Override
    public ScriptoriumPoint addPoint(double x, double y) {
        ScriptoriumPoint point = this.pointsManager.addPoint(x, y);
        AddPointEffect effect = new AddPointEffect(point, this.pointsManager);
        this.getDrawingArea().changeLayout();
        this.undoSupport.postEdit(effect);
        return point;
    }

    @Override
    public void removePoint(ScriptoriumPoint point) {
        boolean found = this.drawing.isPointReferred(point);
        if (!found) {
            this.rmPoint(point);
        } else {
            UIConstants uiConstants = UIConstants.getInstance();
            int option = JOptionPane.showConfirmDialog(null, String.valueOf(this.pointString) + " " + this.belongsString + " " + this.curvesString + " " + uiConstants.confirmString + " " + this.removeString, uiConstants.warningString, 2);
            if (option == 0) {
                this.rmPoint(point);
                this.getDrawingArea().changeLayout();
            }
        }
    }

    private void rmPoint(ScriptoriumPoint point) {
        this.pointsManager.removePoint(point);
        RemovePointEffect effect = new RemovePointEffect(point, this.pointsManager);
        this.undoSupport.postEdit(effect);
    }

    public void setBackgroundImage(File imageFile) {
        BackgroundImage backgroundImage = new BackgroundImage(this.drawing);
        Edition edition = this.drawing.getEdition();
        File imageDefaultFolder = EditionManager.getImageDefaultFolder(edition);
        URI imageUri = FileSystemTools.getRelativeURI(imageDefaultFolder, imageFile);
        backgroundImage.setUri(imageUri);
        this.drawing.setBackgroundImage(backgroundImage);
        DrawingArea drawingArea = this.getDrawingArea();
        drawingArea.loadBackgroundImage(backgroundImage);
        this.setExportableAreaByBackground();
    }

    public void removeBackgroundImage() {
        this.drawing.removeBackgroundImage();
        DrawingArea drawingArea = this.getDrawingArea();
        drawingArea.unloadBackgroundImage();
    }

    @Override
    public void removeShape(ScriptoriumShape shape) {
        if (this.belongsToGroup(shape)) {
            UIConstants uiConstants = UIConstants.getInstance();
            JOptionPane.showMessageDialog(null, String.valueOf(this.shapeString) + " " + this.belongsString + " " + this.groupsString + " " + this.removeImpossibleString, uiConstants.warningString, 2);
        } else {
            int index = this.shapesModel.indexOf(shape);
            this.shapesModel.removeElementAt(index);
        }
    }

    private boolean belongsToGroup(ScriptoriumShape shape) {
        boolean found = false;
        GenericSelectionModel<GlyphGroup> groups = this.getGroupsModel();
        Iterator iterator = groups.iterator();
        while (!found && iterator.hasNext()) {
            GlyphGroup group = (GlyphGroup)iterator.next();
            List<Glyph> glyphs = group.getGlyphs();
            found = glyphs.contains(shape);
        }
        return found;
    }

    @Override
    public void removeSelectedShapes() {
        List<ScriptoriumShape> selectedShapes;
        UIConstants uiConstants = UIConstants.getInstance();
        int option = JOptionPane.showConfirmDialog(null, String.valueOf(this.undoImpossisbleString) + " " + uiConstants.confirmString + " " + this.wantRemoveString, UIConstants.getInstance().warningString, 2);
        if (option == 0 && (selectedShapes = this.getSelectedShapes()) != null) {
            for (ScriptoriumShape selectedShape : selectedShapes) {
                this.removeShape(selectedShape);
            }
        }
    }

    @Override
    public ScriptoriumShape addShape(AbstractShape<?> innerShape) {
        this.setSelectMode(false);
        ScriptoriumShape shape = this.createShape(innerShape);
        this.shapesModel.append(shape);
        this.setSelectedShape(shape);
        return shape;
    }

    public ScriptoriumShape addShape(AbstractShape<?> innerShape, ScriptoriumShape prev) {
        ScriptoriumShape shape = this.createShape(innerShape);
        this.shapesModel.addAfter(shape, prev);
        return shape;
    }

    @Override
    public void splitShape(int pointIndex) {
        ScriptoriumShape selectedShape = this.getSelectedShape();
        AbstractShape<PointReference> oldShape = selectedShape.getShape();
        ShapeCreateVisitor visitor = new ShapeCreateVisitor();
        oldShape.accept(visitor);
        AbstractShape<PointReference> newShape = visitor.getAbstractShape();
        this.addShape(newShape, selectedShape);
        List<PointReference> references = oldShape.getPointReferences();
        PointReference point = references.get(pointIndex);
        newShape.addPoint(point);
        int index = pointIndex + 1;
        while (index < references.size()) {
            point = references.get(index);
            newShape.addPoint(point);
            oldShape.removePoint(point);
            ++index;
        }
        this.setSelectMode(true);
    }

    @Override
    public ScriptoriumShape getShape(int index) {
        return (ScriptoriumShape)this.shapesModel.get(index);
    }

    @Override
    public ScriptoriumPoint getNearestPoint(Point2D clickPoint) {
        ScriptoriumPoint nearestPoint = null;
        double distance = this.pointSelectionDistance;
        for (ScriptoriumPoint point : this.pointsManager) {
            double y;
            double x = point.getX();
            double d = clickPoint.distance(x, y = point.getY());
            if (!(d < distance)) continue;
            nearestPoint = point;
            distance = d;
        }
        return nearestPoint;
    }

    @Override
    public boolean addPointToShape(AbstractPointReference<?> point, ScriptoriumShape shape) {
        AbstractShape<?> innerShape = shape.getShape();
        boolean ok = innerShape.addPoint(point);
        if (ok && !innerShape.canAddPoint()) {
            this.setSelectMode(true);
        }
        return ok;
    }

    @Override
    public void selectionChanged(GenericSelectionModel<?> source) {
        if (source == this.groupsModel) {
            this.pointsManager.setSelectedItem(null, false);
            this.shapesModel.setSelectedItem(null, false);
            SelectGlyphVisitor visitor = new SelectGlyphVisitor(this);
            GlyphGroup selectedGroup = this.getSelectedGroup();
            visitor.visit(selectedGroup);
        } else if (source == this.shapesModel) {
            ScriptoriumShape selectedShape = this.getSelectedShape();
            this.pointsManager.setSelectedItem(null, false);
            this.selectManager.recordShapeSelection(selectedShape);
            this.groupsModel.setSelectedItem(null, false);
        } else if (source == this.pointsManager.getPointsModel()) {
            ScriptoriumPoint selectedPoint = this.getSelectedPoint();
            ScriptoriumShape selectedShape = this.getSelectedShape();
            if (this.isSelectMode() || selectedShape == null) {
                this.shapesModel.setSelectedItem(null, false);
                this.selectManager.recordPointSelection(selectedPoint);
            } else {
                this.pointsManager.setSelectedItem(null, false);
                if (selectedPoint != null) {
                    this.addPointToShape(selectedPoint, selectedShape);
                }
            }
            this.groupsModel.setSelectedItem(null, false);
        }
        this.postSelectionAction();
    }

    private void postSelectionAction() {
        this.pointsManager.updateSelection();
        DrawingArea drawingArea = this.getDrawingArea();
        if (drawingArea != null) {
            drawingArea.repaint();
        }
    }

    @Override
    public ScriptoriumShape getSelectedShape() {
        return (ScriptoriumShape)this.shapesModel.getSelectedElement();
    }

    @Override
    public List<ScriptoriumShape> getSelectedShapes() {
        return this.shapesModel.getSelectedElements();
    }

    @Override
    public ScriptoriumStyle getSelectedStyle() {
        ScriptoriumStyle style = this.stylesModel.getSelectedElement();
        return style;
    }

    @Override
    public void setFocusToPointPanel() {
        this.pointsManager.setFocusToPanel();
    }

    @Override
    public void updatePointPanel(ScriptoriumPoint point) {
        this.pointsManager.updatePointPanel(point);
    }

    @Override
    public void setSelectedLabelRect(Point2D startPoint, Point2D endPoint) {
        Rectangle2D.Double newRect = new Rectangle2D.Double();
        newRect.setFrameFromDiagonal(startPoint, endPoint);
        ScriptoriumPoint selectedPoint = this.getSelectedPoint();
        double oldLlX = selectedPoint.getLabelLLCornerX();
        double oldLlY = selectedPoint.getLabelLLCornerY();
        double oldUrX = selectedPoint.getLabelURCornerX();
        double oldUrY = selectedPoint.getLabelURCornerY();
        double newLlX = newRect.getMinX() - selectedPoint.getX();
        double newLlY = newRect.getMinY() - selectedPoint.getY();
        double newUrX = newRect.getMaxX() - selectedPoint.getX();
        double newUrY = newRect.getMaxY() - selectedPoint.getY();
        selectedPoint.setLabelLLCornerX(newLlX);
        selectedPoint.setLabelLLCornerY(newLlY);
        selectedPoint.setLabelURCornerX(newUrX);
        selectedPoint.setLabelURCornerY(newUrY);
        this.recordChangePointLabelRectangle(selectedPoint, oldLlX, oldLlY, oldUrX, oldUrY, newLlX, newLlY, newUrX, newUrY);
    }
}

