/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui.drawings;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JToolBar;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.Arc;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.Bezier;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.CircleByCenter;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.Ellipse;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.EllipseByPoints;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.Line;
import org.homelinux.elabor.scriptorium.gui.Preferences;
import org.homelinux.elabor.scriptorium.gui.drawings.DefaultDrawingDirector;
import org.homelinux.elabor.scriptorium.gui.drawings.DrawingPalette;
import org.homelinux.elabor.scriptorium.services.EditionManager;
import org.homelinux.elabor.tools.MessageCatalog;
import org.homelinux.elabor.ui.UITools;

public class DefaultDrawingPalette
extends JToolBar
implements DrawingPalette {
    private static final long serialVersionUID = 1L;
    private JButton selectButton;
    private JButton pointButton;
    private JButton lineButton;
    private JButton circleByCenterButton;
    private JButton circleByApproxButton;
    private JButton ellipseButton;
    private JButton ellipseByPointsButton;
    private JButton arcButton;
    private JButton curveOfBezierButton;
    private DefaultDrawingDirector director;
    private String selectTooltip;
    private String pointTooltip;
    private String lineTooltip;
    private String circleByCenterTooltip;
    private String circleByApproxTooltip;
    private String ellipseTooltip;
    private String ellipseByPointsTooltip;
    private String arcTooltip;
    private String curveOfBezierTooltip;

    public DefaultDrawingPalette() {
        super(0);
        this.initLocale();
        this.setFloatable(false);
        this.selectButton = DefaultDrawingPalette.createButton("select", this.selectTooltip, this);
        this.pointButton = DefaultDrawingPalette.createButton("addPoint", this.pointTooltip, this);
        this.lineButton = DefaultDrawingPalette.createButton("addLine", this.lineTooltip, this);
        this.circleByCenterButton = DefaultDrawingPalette.createButton("addCircleCenter", this.circleByCenterTooltip, this);
        this.circleByApproxButton = DefaultDrawingPalette.createButton("addCircleApprox", this.circleByApproxTooltip, this);
        this.ellipseButton = DefaultDrawingPalette.createButton("addEllipse", this.ellipseTooltip, this);
        this.ellipseByPointsButton = DefaultDrawingPalette.createButton("addEllipseByPoints", this.ellipseByPointsTooltip, this);
        this.arcButton = DefaultDrawingPalette.createButton("addArc", this.arcTooltip, this);
        this.curveOfBezierButton = DefaultDrawingPalette.createButton("addBezierCurve", this.curveOfBezierTooltip, this);
        this.add(this.selectButton);
        this.add(this.pointButton);
        this.add(this.lineButton);
        this.add(this.circleByCenterButton);
        this.add(this.ellipseButton);
        this.add(this.arcButton);
        this.add(this.curveOfBezierButton);
        this.add(this.circleByApproxButton);
        this.add(this.ellipseByPointsButton);
    }

    private static JButton createButton(String iconName, String toolTip, ActionListener listener) {
        EditionManager manager = EditionManager.getInstance();
        URL iconUrl = manager.getIconUrl(iconName);
        URL selIconUrl = manager.getIconUrl(String.valueOf(iconName) + "_sel");
        JButton button = UITools.createButton(iconUrl, selIconUrl, toolTip, listener);
        return button;
    }

    public void setup(DefaultDrawingDirector drawingDirector) {
        this.director = drawingDirector;
    }

    private void initLocale() {
        MessageCatalog catalog = new MessageCatalog();
        String locale = Preferences.getInstance().getProperty("locale");
        catalog.loadCatalog(this.getClass().getName(), locale);
        this.selectTooltip = catalog.translate("select_tooltip");
        this.pointTooltip = catalog.translate("point_tooltip");
        this.lineTooltip = catalog.translate("line_tooltip");
        this.circleByCenterTooltip = catalog.translate("circleByCenter_tooltip");
        this.circleByApproxTooltip = catalog.translate("circleByApprox_tooltip");
        this.ellipseTooltip = catalog.translate("ellipse_tooltip");
        this.ellipseByPointsTooltip = catalog.translate("ellipseByPoints_tooltip");
        this.arcTooltip = catalog.translate("arc_tooltip");
        this.curveOfBezierTooltip = catalog.translate("curveOfBezier_tooltip");
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (this.director != null) {
            Object source = event.getSource();
            if (source == this.selectButton) {
                this.director.setSelectMode(true);
            } else if (source == this.pointButton) {
                this.director.setSelectMode(false);
            } else if (source == this.circleByCenterButton) {
                this.director.addShape(new CircleByCenter());
            } else if (source == this.circleByApproxButton) {
                EllipseByPoints innerShape = new EllipseByPoints();
                this.director.addShape(innerShape);
                innerShape.setCircle(true);
            } else if (source == this.arcButton) {
                this.director.addShape(new Arc());
            } else if (source == this.curveOfBezierButton) {
                this.director.addShape(new Bezier());
            } else if (source == this.ellipseButton) {
                this.director.addShape(new Ellipse());
            } else if (source == this.ellipseByPointsButton) {
                EllipseByPoints innerShape = new EllipseByPoints();
                this.director.addShape(innerShape);
                innerShape.setCircle(false);
            } else if (source == this.lineButton) {
                this.director.addShape(new Line());
            }
        }
    }

    @Override
    public void setSelectMode(boolean select) {
        DefaultDrawingPalette.setSelected(this.selectButton, select);
        DefaultDrawingPalette.setSelected(this.pointButton, !select);
        DefaultDrawingPalette.setSelected(this.curveOfBezierButton, false);
        DefaultDrawingPalette.setSelected(this.ellipseButton, false);
        DefaultDrawingPalette.setSelected(this.lineButton, false);
        DefaultDrawingPalette.setSelected(this.ellipseByPointsButton, false);
        DefaultDrawingPalette.setSelected(this.circleByApproxButton, false);
        DefaultDrawingPalette.setSelected(this.circleByCenterButton, false);
        DefaultDrawingPalette.setSelected(this.arcButton, false);
    }

    private static void setSelected(JButton button, boolean selected) {
        button.setSelected(selected);
    }
}

