/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui.drawings.groups;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.Glyph;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.GlyphGroup;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.ScriptoriumPoint;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.ScriptoriumShape;
import org.homelinux.elabor.scriptorium.gui.Preferences;
import org.homelinux.elabor.scriptorium.gui.drawings.DrawingDirector;
import org.homelinux.elabor.scriptorium.gui.drawings.groups.GroupFrame;
import org.homelinux.elabor.tools.MessageCatalog;
import org.homelinux.elabor.ui.GenericSelectionModel;
import org.homelinux.elabor.ui.UIConstants;
import org.homelinux.elabor.ui.panel.ListArea;

public class GroupsArea
extends ListArea<GlyphGroup> {
    private static final long serialVersionUID = 1L;
    private DrawingDirector director;
    private GroupFrame groupFrame;
    private String nothingSelectedString;

    public GroupsArea() {
        super(true, true, true);
        this.initLocale();
    }

    private void initLocale() {
        MessageCatalog catalog = new MessageCatalog();
        String locale = Preferences.getInstance().getProperty("locale");
        catalog.loadCatalog(GroupsArea.class.getName(), locale);
        this.nothingSelectedString = catalog.translate("nothingSelected");
    }

    public void setup(DrawingDirector drawingDirector) {
        this.director = drawingDirector;
        GenericSelectionModel<GlyphGroup> groups = this.director.getGroupsModel();
        super.setup(groups, null);
        this.groupFrame = null;
        groups.addSelectionListener(this.director);
    }

    private void openGroupFrame(GlyphGroup group) {
        if (this.groupFrame == null) {
            this.groupFrame = new GroupFrame();
        }
        this.groupFrame.setup(group);
    }

    @Override
    public void addAction() {
        List<ScriptoriumPoint> selectedPoints = this.director.getSelectedPoints();
        List<ScriptoriumShape> selectedShapes = this.director.getSelectedShapes();
        if (selectedPoints.size() > 0 || selectedShapes.size() > 0) {
            ArrayList<Glyph> glyphs = new ArrayList<Glyph>();
            glyphs.addAll(this.director.getSelectedPoints());
            glyphs.addAll(this.director.getSelectedShapes());
            GlyphGroup group = this.director.addGroup(glyphs);
            this.openGroupFrame(group);
        } else {
            UIConstants uiConstants = UIConstants.getInstance();
            JOptionPane.showMessageDialog(null, this.nothingSelectedString, uiConstants.warningString, 2);
        }
    }

    @Override
    public void remAction(int index, GlyphGroup group) {
        this.director.removeGroup(group);
    }

    @Override
    public void editAction(int index, GlyphGroup group) {
        this.openGroupFrame(group);
    }

    @Override
    public boolean closing() {
        if (this.groupFrame != null) {
            this.groupFrame.dispose();
        }
        return super.closing();
    }
}

