/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui.drawings.groups.keywords;

import java.awt.Color;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import org.homelinux.elabor.scriptorium.ecomponents.EditionComponent;
import org.homelinux.elabor.scriptorium.ecomponents.Ontology;
import org.homelinux.elabor.scriptorium.ecomponents.OntologyClass;
import org.homelinux.elabor.scriptorium.ecomponents.OntologyReference;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.GlyphGroup;
import org.homelinux.elabor.scriptorium.gui.Preferences;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumPanel;
import org.homelinux.elabor.scriptorium.gui.drawings.groups.keywords.GroupKeywordsArea;
import org.homelinux.elabor.scriptorium.gui.drawings.groups.keywords.KeywordsArea;
import org.homelinux.elabor.scriptorium.gui.drawings.groups.keywords.TypesArea;
import org.homelinux.elabor.scriptorium.gui.drawings.groups.keywords.TypesSelectionListener;
import org.homelinux.elabor.scriptorium.services.EditionManager;
import org.homelinux.elabor.tools.MessageCatalog;
import org.homelinux.elabor.ui.DefaultGenericSelectionModel;
import org.homelinux.elabor.ui.GenericSelectionModel;
import org.homelinux.elabor.ui.UIConstants;
import org.homelinux.elabor.ui.UITools;

public class KeywordsPanel
extends ScriptoriumPanel<EditionComponent<?>> {
    private static final long serialVersionUID = 1L;
    private Ontology ontology;
    private GlyphGroup group;
    private List<OntologyClass> types;
    private GenericSelectionModel<OntologyClass> keywordsModel;
    private TypesArea typesArea;
    private KeywordsArea keywordsArea;
    private String typesString;
    private String keywordsString;
    private String keywordBelongsString;
    private GroupKeywordsArea groupKeywordsArea;

    public KeywordsPanel() {
        this.initLocale();
        this.typesArea = new TypesArea();
        this.keywordsArea = new KeywordsArea();
        LineBorder border = new LineBorder(Color.BLACK);
        TitledBorder typesBorder = new TitledBorder(border, this.typesString);
        this.typesArea.setBorder(typesBorder);
        TitledBorder keywordsBorder = new TitledBorder(border, this.keywordsString);
        this.keywordsArea.setBorder(keywordsBorder);
        this.setLayout(new GridBagLayout());
        UITools.addComponent(this, this.typesArea, 0, 1, 1, 1, 100, 100, 1, 2);
        UITools.addComponent(this, this.keywordsArea, 0, 2, 2, 1, 100, 100, 1, 2);
        EditionManager manager = EditionManager.getInstance();
        this.ontology = manager.getKeywordsOntology();
    }

    private void initLocale() {
        MessageCatalog catalog = new MessageCatalog();
        String locale = Preferences.getInstance().getProperty("locale");
        catalog.loadCatalog(this.getClass().getName(), locale);
        this.typesString = catalog.translate("types");
        this.keywordsString = catalog.translate("keywords");
        this.keywordBelongsString = catalog.translate("keywordBelongs");
    }

    public void setup(GlyphGroup group, GroupKeywordsArea groupKeywordsArea) {
        this.group = group;
        this.groupKeywordsArea = groupKeywordsArea;
        this.types = this.ontology.getClassTypes();
        DefaultGenericSelectionModel<OntologyClass> typesModel = new DefaultGenericSelectionModel<OntologyClass>(this.types);
        this.typesArea.setup(typesModel);
        TypesSelectionListener typesSelectionListener = new TypesSelectionListener(this);
        typesModel.addSelectionListener(typesSelectionListener);
    }

    public void setSelectedIndex(int selectedIndex) {
        OntologyClass selectedType = this.types.get(selectedIndex);
        List<OntologyClass> keywords = this.ontology.getChildren(selectedType);
        this.setKeywordsArea(keywords);
    }

    private void setKeywordsArea(List<OntologyClass> keywords) {
        this.keywordsModel = new DefaultGenericSelectionModel<OntologyClass>(keywords);
        this.keywordsArea.setup(this.keywordsModel);
    }

    @Override
    public boolean okAction() {
        OntologyClass keyword = this.keywordsModel.getSelectedElement();
        String keywordId = keyword.getId();
        List<OntologyReference> references = this.group.getOntologyReferences();
        boolean notAlready = true;
        for (OntologyReference reference : references) {
            String referenceId = reference.getOntologyId();
            if (!keywordId.equals(referenceId)) continue;
            notAlready = false;
            this.notAddable();
            break;
        }
        if (notAlready) {
            this.addKeywordToReferences(keywordId, references);
        }
        return notAlready;
    }

    private void addKeywordToReferences(String keywordId, List<OntologyReference> references) {
        OntologyReference newReference = new OntologyReference(this.group);
        newReference.setOntologyId(keywordId);
        references.add(newReference);
        this.group.addOntologyReference(newReference);
        ArrayList<OntologyClass> keywords = new ArrayList<OntologyClass>();
        this.setKeywordsArea(keywords);
        this.groupKeywordsArea.setup(this.group);
    }

    private void notAddable() {
        UIConstants uiConstants = UIConstants.getInstance();
        JOptionPane.showMessageDialog(null, this.keywordBelongsString, uiConstants.warningString, 2);
    }
}

