/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui.drawings.points;

import java.awt.Color;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import org.homelinux.elabor.itools.DefaultPanel;
import org.homelinux.elabor.itools.Tools;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.CharRotation;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.ScriptoriumPoint;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.styles.ScriptoriumStyle;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.styles.Style;
import org.homelinux.elabor.scriptorium.gui.Preferences;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumFrame;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumPanel;
import org.homelinux.elabor.scriptorium.gui.drawings.CharRotationRenderer;
import org.homelinux.elabor.scriptorium.gui.drawings.DrawingArea;
import org.homelinux.elabor.scriptorium.gui.drawings.DrawingDirector;
import org.homelinux.elabor.scriptorium.gui.drawings.labels.LabelField;
import org.homelinux.elabor.scriptorium.gui.drawings.points.PointLabelListener;
import org.homelinux.elabor.tools.MessageCatalog;
import org.homelinux.elabor.ui.EnumComboBox;
import org.homelinux.elabor.ui.GenericSelectionModel;
import org.homelinux.elabor.ui.UITools;

public class PointPanel
extends ScriptoriumPanel<ScriptoriumPoint>
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private DrawingDirector director;
    private ScriptoriumPoint point;
    private JTextField idField;
    private JTextField subidField;
    private JTextField xField;
    private JTextField yField;
    private LabelField labelField;
    private JTextField labelRotationField;
    private EnumComboBox<CharRotation> charRotationMenu;
    private JTextField charInterspaceField;
    private JTextField llxField;
    private JTextField llyField;
    private JTextField urxField;
    private JTextField uryField;
    private JComboBox<ScriptoriumStyle> styleMenu;
    private JCheckBox visibleBox;
    private JButton resetButton;
    private String idString;
    private String subidString;
    private String xString;
    private String yString;
    private String labelString;
    private String labelAreaString;
    private String labelRotationString;
    private String charRotationString;
    private String charInterspaceString;
    private String llxString;
    private String llyString;
    private String urxString;
    private String uryString;
    private String resetString;
    private String resetTooltip;
    private String styleString;
    private String visibleString;
    private ScriptoriumFrame<?> frame;
    private PointLabelListener pointLabelListener;
    private JLabel charInterspaceLabel;

    public PointPanel(ScriptoriumFrame<?> frame) {
        this.initLocale();
        this.frame = frame;
        JLabel idLabel = new JLabel(this.idString, 4);
        JLabel subidLabel = new JLabel(this.subidString, 4);
        JLabel xLabel = new JLabel(this.xString, 4);
        JLabel yLabel = new JLabel(this.yString, 4);
        JLabel labelLabel = new JLabel(this.labelString, 4);
        JLabel labelRotationLabel = new JLabel(this.labelRotationString, 4);
        JLabel charRotationLabel = new JLabel(this.charRotationString, 4);
        this.charInterspaceLabel = new JLabel(this.charInterspaceString, 4);
        JLabel styleLabel = new JLabel(this.styleString, 4);
        JLabel visibleLabel = new JLabel(this.visibleString, 4);
        Preferences preferences = Preferences.getInstance();
        Color editableBgColor = preferences.getColor("text_fields_editable_bg_color");
        Color noneditableBgColor = preferences.getColor("text_fields_protected_bg_color");
        int fontSize = preferences.getInteger("text_fields_font_size");
        this.idField = Tools.setupTextField(this, fontSize, noneditableBgColor, frame);
        this.idField.setEditable(false);
        this.subidField = Tools.setupTextField(this, fontSize, editableBgColor, frame);
        this.xField = Tools.setupTextField(this, fontSize, editableBgColor, frame);
        this.yField = Tools.setupTextField(this, fontSize, editableBgColor, frame);
        this.labelField = new LabelField(this, fontSize, editableBgColor, frame);
        this.labelRotationField = Tools.setupTextField(this, fontSize, editableBgColor, frame);
        CharRotationRenderer charRotationRenderer = new CharRotationRenderer();
        this.charRotationMenu = new EnumComboBox<CharRotation>(CharRotation.class, charRotationRenderer);
        this.charRotationMenu.addActionListener(this);
        this.charInterspaceField = Tools.setupTextField(this, fontSize, editableBgColor, frame);
        this.llxField = Tools.setupTextField(this, fontSize, editableBgColor, frame);
        this.llyField = Tools.setupTextField(this, fontSize, editableBgColor, frame);
        this.urxField = Tools.setupTextField(this, fontSize, editableBgColor, frame);
        this.uryField = Tools.setupTextField(this, fontSize, editableBgColor, frame);
        this.resetButton = new JButton(this.resetString);
        this.resetButton.setToolTipText(this.resetTooltip);
        this.resetButton.addActionListener(this);
        this.styleMenu = new JComboBox();
        this.visibleBox = new JCheckBox();
        this.setLayout(new GridBagLayout());
        UITools.addComponent(this, idLabel, 0, 0, 1, 1, 0, 0, 2, 2);
        UITools.addComponent(this, this.idField, 1, 0, 1, 1, 100, 1, 2, 2);
        UITools.addComponent(this, subidLabel, 0, 1, 1, 1, 0, 0, 2, 2);
        UITools.addComponent(this, this.subidField, 1, 1, 1, 1, 100, 1, 2, 2);
        UITools.addComponent(this, labelLabel, 0, 4, 1, 1, 0, 0, 2, 2);
        UITools.addComponent(this, this.labelField, 1, 4, 1, 1, 100, 1, 2, 2);
        UITools.addComponent(this, styleLabel, 0, 14, 1, 1, 1, 1, 2, 2);
        UITools.addComponent(this, this.styleMenu, 1, 14, 1, 1, 100, 1, 2, 2);
        UITools.addComponent(this, visibleLabel, 0, 15, 1, 1, 0, 0, 2, 2);
        UITools.addComponent(this, this.visibleBox, 1, 15, 1, 1, 100, 1, 2, 2);
        if (this.isStandalone()) {
            UITools.addComponent(this, xLabel, 0, 2, 1, 1, 0, 0, 2, 2);
            UITools.addComponent(this, this.xField, 1, 2, 1, 1, 100, 1, 2, 2);
            UITools.addComponent(this, yLabel, 0, 3, 1, 1, 0, 0, 2, 2);
            UITools.addComponent(this, this.yField, 1, 3, 1, 1, 100, 1, 2, 2);
            UITools.addComponent(this, labelRotationLabel, 0, 6, 1, 1, 0, 0, 2, 2);
            UITools.addComponent(this, this.labelRotationField, 1, 6, 1, 1, 100, 1, 2, 2);
            UITools.addComponent(this, charRotationLabel, 0, 7, 1, 1, 0, 0, 2, 2);
            UITools.addComponent(this, this.charRotationMenu, 1, 7, 1, 1, 100, 1, 0, 2);
            UITools.addComponent(this, this.charInterspaceLabel, 0, 8, 1, 1, 1, 1, 2, 2);
            UITools.addComponent(this, this.charInterspaceField, 1, 8, 1, 1, 100, 1, 2, 2);
            JPanel labelPositionPanel = this.buildLabelPositionPanel();
            UITools.addComponent(this, labelPositionPanel, 0, 9, 2, 1, 100, 100, 1, 2);
        } else {
            this.pointLabelListener = new PointLabelListener();
            this.labelField.addKeyListener(this.pointLabelListener);
        }
        this.setBorder(new LineBorder(Color.BLACK));
        this.enableFields();
    }

    private JPanel buildLabelPositionPanel() {
        JLabel llxLabel = new JLabel(this.llxString, 4);
        JLabel llyLabel = new JLabel(this.llyString, 4);
        JLabel urxLabel = new JLabel(this.urxString, 4);
        JLabel uryLabel = new JLabel(this.uryString, 4);
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.setBorder(new TitledBorder(new LineBorder(Color.BLACK), this.labelAreaString));
        UITools.addComponent(panel, llxLabel, 0, 9, 1, 1, 0, 0, 2, 2);
        UITools.addComponent(panel, this.llxField, 1, 9, 1, 1, 100, 1, 2, 2);
        UITools.addComponent(panel, llyLabel, 0, 10, 1, 1, 0, 0, 2, 2);
        UITools.addComponent(panel, this.llyField, 1, 10, 1, 1, 100, 1, 2, 2);
        UITools.addComponent(panel, urxLabel, 0, 11, 1, 1, 0, 0, 2, 2);
        UITools.addComponent(panel, this.urxField, 1, 11, 1, 1, 100, 1, 2, 2);
        UITools.addComponent(panel, uryLabel, 0, 12, 1, 1, 0, 0, 2, 2);
        UITools.addComponent(panel, this.uryField, 1, 12, 1, 1, 100, 1, 2, 2);
        UITools.addComponent(panel, this.resetButton, 0, 13, 2, 1, 100, 1, 0, 2);
        return panel;
    }

    private boolean isStandalone() {
        return this.frame != null;
    }

    protected void initLocale() {
        MessageCatalog catalog = new MessageCatalog();
        String locale = Preferences.getInstance().getProperty("locale");
        catalog.loadCatalog(this.getClass().getName(), locale);
        this.idString = catalog.translate("id");
        this.subidString = catalog.translate("subid");
        this.xString = catalog.translate("x");
        this.yString = catalog.translate("y");
        this.labelString = catalog.translate("label");
        this.labelRotationString = catalog.translate("labelRotation");
        this.charRotationString = catalog.translate("charRotation");
        this.charInterspaceString = catalog.translate("charInterspace");
        this.labelAreaString = catalog.translate("labelArea");
        this.llxString = catalog.translate("labelLLCornerX");
        this.llyString = catalog.translate("labelLLCornerY");
        this.urxString = catalog.translate("labelURCornerX");
        this.uryString = catalog.translate("labelURCornerY");
        this.resetString = catalog.translate("reset");
        this.resetTooltip = catalog.translate("resetTooltip");
        this.styleString = catalog.translate("style");
        this.visibleString = catalog.translate("visible");
    }

    public void setup(DrawingDirector director, ScriptoriumPoint point) {
        this.director = director;
        this.point = point;
        this.update();
    }

    public void update() {
        if (!this.listenerIsChanging()) {
            if (this.isStandalone()) {
                this.reloadStyles();
            } else {
                this.director.setPointPanel(this);
                this.pointLabelListener.setPoint(this.point, this.labelField);
            }
            this.enableFields();
            this.styleMenu.removeActionListener(this);
            this.visibleBox.removeActionListener(this);
            if (this.point == null) {
                this.setNewPoint();
            } else {
                this.setExistingPoint();
            }
            this.styleMenu.addActionListener(this);
            this.visibleBox.addActionListener(this);
        }
    }

    private boolean listenerIsChanging() {
        return this.pointLabelListener != null && this.pointLabelListener.isChanging();
    }

    private void setNewPoint() {
        String id;
        if (this.isStandalone()) {
            int newPointId = this.director.newPointId();
            id = String.valueOf(newPointId);
        } else {
            id = "";
        }
        this.idField.setText(id);
        this.subidField.setText("0");
        this.xField.setText("0.0");
        this.yField.setText("0.0");
        this.labelField.setText("");
        this.labelRotationField.setText("0");
        this.charRotationMenu.setSelectedItem((Object)CharRotation.NORMAL);
        this.charInterspaceField.setText("0.0");
        this.llxField.setText("0.0");
        this.llyField.setText("0.0");
        this.urxField.setText("0.0");
        this.uryField.setText("0.0");
        this.visibleBox.setSelected(true);
    }

    private void setExistingPoint() {
        String styleName = this.point.getStyleName();
        Style style = this.director.getStyle(styleName);
        this.styleMenu.setSelectedItem(style);
        this.idField.setText(String.valueOf(this.point.getId()));
        this.subidField.setText(String.valueOf(this.point.getSubId()));
        this.xField.setText(String.valueOf(this.point.getX()));
        this.yField.setText(String.valueOf(this.point.getY()));
        String label = this.point.getLabel();
        this.labelField.setText(label);
        int labelRotation = this.point.getLabelRotation();
        this.labelRotationField.setText(String.valueOf(labelRotation));
        CharRotation charRotation = this.point.getCharRotation();
        this.charRotationMenu.setSelectedItem((Object)charRotation);
        double charInterspace = this.point.getCharInterspace();
        this.charInterspaceField.setText(String.valueOf(charInterspace));
        this.llxField.setText(String.valueOf(this.point.getLabelLLCornerX()));
        this.llyField.setText(String.valueOf(this.point.getLabelLLCornerY()));
        this.urxField.setText(String.valueOf(this.point.getLabelURCornerX()));
        this.uryField.setText(String.valueOf(this.point.getLabelURCornerY()));
        boolean visible = this.point.isVisible();
        this.visibleBox.setSelected(visible);
    }

    private void updateCharInterspaceField() {
        int charRotationIndex = this.charRotationMenu.getSelectedIndex();
        CharRotation charRotation = CharRotation.values()[charRotationIndex];
        boolean isOblique = charRotation == CharRotation.OBLIQUE;
        this.charInterspaceLabel.setVisible(isOblique);
        this.charInterspaceField.setVisible(isOblique);
    }

    public void reloadStyles() {
        GenericSelectionModel<ScriptoriumStyle> styles = this.director.getStylesModel();
        this.styleMenu.removeActionListener(this);
        this.styleMenu.setModel(styles);
        this.styleMenu.addActionListener(this);
    }

    public void setFocus() {
        this.labelField.requestFocusInWindow();
    }

    private void enableFields() {
        boolean enable = this.isStandalone() || this.point != null;
        this.subidField.setEnabled(enable);
        this.labelField.setEnabled(enable);
        this.styleMenu.setEnabled(enable);
        this.visibleBox.setEnabled(enable);
        enable = this.isStandalone();
        this.labelRotationField.setEnabled(enable);
        this.charRotationMenu.setEnabled(enable);
        this.llxField.setEnabled(enable);
        this.llyField.setEnabled(enable);
        this.urxField.setEnabled(enable);
        this.uryField.setEnabled(enable);
        this.resetButton.setEnabled(true);
    }

    @Override
    public boolean okAction() {
        boolean ok;
        String subidText = this.subidField.getText();
        DefaultPanel.CheckIntField checkSubid = this.checkIntField(subidText, this.subidString);
        String xText = this.xField.getText();
        DefaultPanel.CheckDoubleField checkX = this.checkDoubleField(xText, this.xString);
        String yText = this.yField.getText();
        DefaultPanel.CheckDoubleField checkY = this.checkDoubleField(yText, this.yString);
        String labelRotationText = this.labelRotationField.getText();
        DefaultPanel.CheckIntField checkLabelRotation = this.checkIntField(labelRotationText, this.labelRotationString);
        String llxText = this.llxField.getText();
        DefaultPanel.CheckDoubleField checkLLX = this.checkDoubleField(llxText, this.llxString);
        String llyText = this.llyField.getText();
        DefaultPanel.CheckDoubleField checkLLY = this.checkDoubleField(llyText, this.llxString);
        String urxText = this.urxField.getText();
        DefaultPanel.CheckDoubleField checkURX = this.checkDoubleField(urxText, this.urxString);
        String uryText = this.uryField.getText();
        DefaultPanel.CheckDoubleField checkURY = this.checkDoubleField(uryText, this.urxString);
        boolean bl = ok = checkSubid.ok && checkX.ok && checkY.ok && checkLabelRotation.ok && checkLLX.ok && checkLLY.ok && checkURX.ok && checkURY.ok;
        if (ok) {
            if (this.point == null) {
                this.point = this.director.addPoint(checkX.value, checkY.value);
                this.director.setSelectedPoint(this.point);
            } else {
                this.point.setX(checkX.value);
                this.point.setY(checkY.value);
            }
            this.point.setSubId(checkSubid.value);
            this.point.setLabel(this.labelField.getText(), true);
            this.point.setLabelRotation(checkLabelRotation.value);
            int selectedIndex = this.charRotationMenu.getSelectedIndex();
            CharRotation charRotation = CharRotation.values()[selectedIndex];
            this.point.setCharRotation(charRotation);
            String charInterspaceText = this.charInterspaceField.getText();
            double charInterspace = Double.parseDouble(charInterspaceText);
            this.point.setCharInterspace(charInterspace);
            this.point.setLabelLLCornerX(checkLLX.value);
            this.point.setLabelLLCornerY(checkLLY.value);
            this.point.setLabelURCornerX(checkURX.value);
            this.point.setLabelURCornerY(checkURY.value);
            this.setPointStyle();
            boolean selected = this.visibleBox.isSelected();
            this.point.setVisible(selected);
            DrawingArea drawingArea = this.director.getDrawingArea();
            drawingArea.requestFocusInWindow();
        }
        return ok;
    }

    private void setPointStyle() {
        int selectedIndex = this.styleMenu.getSelectedIndex();
        if (selectedIndex < 0) {
            this.point.setStyleName("");
        } else {
            GenericSelectionModel<ScriptoriumStyle> styles = this.director.getStylesModel();
            ScriptoriumStyle style = (ScriptoriumStyle)styles.get(selectedIndex);
            String name = style.getName();
            this.point.setStyleName(name);
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.charRotationMenu) {
            this.updateCharInterspaceField();
        } else if (source == this.resetButton) {
            this.llxField.setText("0.0");
            this.llyField.setText("0.0");
            this.urxField.setText("0.0");
            this.uryField.setText("0.0");
        } else if (this.point != null && !this.isStandalone()) {
            boolean selected = this.visibleBox.isSelected();
            this.point.setVisible(selected);
            this.setPointStyle();
        }
    }

    @Override
    public boolean closing() {
        this.labelField.closing();
        return super.closing();
    }
}

