/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui.drawings.points;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.List;
import javax.swing.JOptionPane;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.ScriptoriumPoint;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.AbstractShape;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.ScriptoriumShape;
import org.homelinux.elabor.scriptorium.gui.Preferences;
import org.homelinux.elabor.scriptorium.gui.drawings.DrawingDirector;
import org.homelinux.elabor.tools.MessageCatalog;
import org.homelinux.elabor.ui.UIConstants;

public class RemovePointKeyListener
implements KeyListener {
    private DrawingDirector director;
    private String severalShapesString;

    public RemovePointKeyListener() {
        this.initLocale();
    }

    public void setDrawingDirector(DrawingDirector director) {
        this.director = director;
    }

    private void initLocale() {
        MessageCatalog catalog = new MessageCatalog();
        String locale = Preferences.getInstance().getProperty("locale");
        catalog.loadCatalog(this.getClass().getName(), locale);
        this.severalShapesString = catalog.translate("severalShapes");
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        AbstractShape<ScriptoriumPoint> innerShape;
        ScriptoriumShape selected_shape = this.director.getSelectedShape();
        if (selected_shape != null && (innerShape = selected_shape.getShape()) != null && e.getKeyCode() == 8) {
            List<ScriptoriumShape> shapes = this.director.getSelectedShapes();
            int size = shapes.size();
            if (size > 1) {
                JOptionPane.showMessageDialog(null, this.severalShapesString, UIConstants.getInstance().errorString, 0);
            } else {
                List<ScriptoriumPoint> points = this.director.getShapePoints(innerShape);
                int points_number = points.size();
                if (points_number > 0) {
                    ScriptoriumPoint last = points.get(points_number - 1);
                    innerShape.removePoint(last);
                }
                this.director.getDrawingArea().repaint();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }
}

