/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui.drawings.styles;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.styles.ScriptoriumStyle;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.styles.Style;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.styles.StyleSet;
import org.homelinux.elabor.scriptorium.gui.Preferences;
import org.homelinux.elabor.scriptorium.gui.drawings.DrawingDirector;
import org.homelinux.elabor.scriptorium.gui.drawings.styles.DefaultStroke;
import org.homelinux.elabor.scriptorium.gui.drawings.styles.DefaultStyle;
import org.homelinux.elabor.scriptorium.gui.drawings.styles.ElementColorListener;
import org.homelinux.elabor.scriptorium.gui.drawings.styles.FillColorListener;
import org.homelinux.elabor.scriptorium.gui.drawings.styles.LabelColorListener;
import org.homelinux.elabor.scriptorium.gui.drawings.styles.StylesManager;
import org.homelinux.elabor.tools.MessageCatalog;
import org.homelinux.elabor.ui.ColorButtonListener;
import org.homelinux.elabor.ui.UIConstants;
import org.homelinux.elabor.ui.UITools;
import org.homelinux.elabor.ui.panel.DefaultPanel;
import org.homelinux.elabor.ui.panel.ListCellStrokeRenderer;

public class StylePanel
extends DefaultPanel<StylesManager> {
    static final long serialVersionUID = 1L;
    private JTextField nameField;
    private JTextField lineWidthField;
    private JComboBox<DefaultStroke> lineDashMenu;
    private JTextField pointSizeField;
    private JTextField labelFontSizeField;
    private JComboBox<String> fontMenu;
    private String nameString;
    private String chooseString;
    private String elementColorString;
    private String elementOrigColorString;
    private String lineWidthString;
    private String lineDashString;
    private String fillColorString;
    private String fillOrigColorString;
    private String pointSizeString;
    private String labelColorString;
    private String labelFontSizeString;
    private String fontString;
    private StylesManager manager;
    private ScriptoriumStyle scriptoriumStyle;
    private List<DefaultStroke> strokes;
    private String[] fonts;
    private Color elementColor;
    private JButton elementColorButton;
    private ColorButtonListener elementColorButtonListener;
    private Color elementOrigColor;
    private JButton elementOrigColorButton;
    private ColorButtonListener elementOrigColorButtonListener;
    private Color labelColor;
    private JButton labelColorButton;
    private ColorButtonListener labelColorButtonListener;
    private Color fillColor;
    private JButton fillColorButton;
    private ColorButtonListener fillColorButtonListener;
    private Color fillOrigColor;
    private JButton fillOrigColorButton;
    private ColorButtonListener fillOrigColorButtonListener;

    public StylePanel() {
        this.initLocale();
        Preferences preferences = Preferences.getInstance();
        this.initStrokes();
        this.initFonts();
        int fieldsFontSize = preferences.getInteger("text_fields_font_size");
        Color editableBgColor = preferences.getColor("text_fields_editable_bg_color");
        JLabel nameLabel = new JLabel(this.nameString, 4);
        JLabel elementColorLabel = new JLabel(this.elementColorString, 4);
        JLabel elementOrigColorLabel = new JLabel(this.elementOrigColorString, 4);
        JLabel lineWidthLabel = new JLabel(this.lineWidthString, 4);
        JLabel lineDashLabel = new JLabel(this.lineDashString, 4);
        JLabel fillColorLabel = new JLabel(this.fillColorString, 4);
        JLabel fillOrigColorLabel = new JLabel(this.fillOrigColorString, 4);
        JLabel pointSizeLabel = new JLabel(this.pointSizeString, 4);
        JLabel labelColorLabel = new JLabel(this.labelColorString, 4);
        JLabel labelFontSizeLabel = new JLabel(this.labelFontSizeString, 4);
        JLabel fontLabel = new JLabel(this.fontString, 4);
        this.nameField = UITools.setupTextField(this, fieldsFontSize, editableBgColor);
        this.elementColorButton = new JButton(this.chooseString);
        ElementColorListener elementColorListener = new ElementColorListener(this, false);
        this.elementColorButtonListener = new ColorButtonListener(elementColorListener);
        this.elementColorButton.addActionListener(this.elementColorButtonListener);
        this.elementOrigColorButton = new JButton(this.chooseString);
        ElementColorListener elementOrigColorListener = new ElementColorListener(this, true);
        this.elementOrigColorButtonListener = new ColorButtonListener(elementOrigColorListener);
        this.elementOrigColorButton.addActionListener(this.elementOrigColorButtonListener);
        this.lineWidthField = UITools.setupTextField(this, fieldsFontSize, editableBgColor);
        this.lineDashMenu = new JComboBox<DefaultStroke>(this.strokes.toArray(new DefaultStroke[this.strokes.size()]));
        this.lineDashMenu.setRenderer(new ListCellStrokeRenderer());
        this.fillColorButton = new JButton(this.chooseString);
        FillColorListener fillColorListener = new FillColorListener(this, false);
        this.fillColorButtonListener = new ColorButtonListener(fillColorListener);
        this.fillColorButton.addActionListener(this.fillColorButtonListener);
        this.fillOrigColorButton = new JButton(this.chooseString);
        FillColorListener fillOrigColorListener = new FillColorListener(this, true);
        this.fillOrigColorButtonListener = new ColorButtonListener(fillOrigColorListener);
        this.fillOrigColorButton.addActionListener(this.fillOrigColorButtonListener);
        this.pointSizeField = UITools.setupTextField(this, fieldsFontSize, editableBgColor);
        this.labelColorButton = new JButton(this.chooseString);
        LabelColorListener labelColorListener = new LabelColorListener(this);
        this.labelColorButtonListener = new ColorButtonListener(labelColorListener);
        this.labelColorButton.addActionListener(this.labelColorButtonListener);
        this.labelFontSizeField = UITools.setupTextField(this, fieldsFontSize, editableBgColor);
        this.fontMenu = new JComboBox<String>(this.fonts);
        this.setLayout(new GridBagLayout());
        this.setBorder(new LineBorder(Color.black));
        UITools.addComponent(this, nameLabel, 0, 0, 1, 1, 1, 1, 2, 1);
        UITools.addComponent(this, this.nameField, 1, 0, 1, 1, 1, 1, 2, 1);
        UITools.addComponent(this, elementColorLabel, 0, 1, 1, 1, 1, 1, 2, 1);
        UITools.addComponent(this, this.elementColorButton, 1, 1, 1, 1, 100, 1, 0, 2);
        UITools.addComponent(this, elementOrigColorLabel, 0, 2, 1, 1, 1, 1, 2, 1);
        UITools.addComponent(this, this.elementOrigColorButton, 1, 2, 1, 1, 100, 1, 0, 2);
        UITools.addComponent(this, lineWidthLabel, 0, 3, 1, 1, 1, 1, 2, 1);
        UITools.addComponent(this, this.lineWidthField, 1, 3, 1, 1, 100, 1, 2, 1);
        UITools.addComponent(this, lineDashLabel, 0, 4, 1, 1, 1, 1, 2, 1);
        UITools.addComponent(this, this.lineDashMenu, 1, 4, 1, 1, 100, 1, 2, 1);
        UITools.addComponent(this, fillColorLabel, 0, 5, 1, 1, 1, 1, 2, 1);
        UITools.addComponent(this, this.fillColorButton, 1, 5, 1, 1, 100, 1, 0, 2);
        UITools.addComponent(this, fillOrigColorLabel, 0, 6, 1, 1, 1, 1, 2, 1);
        UITools.addComponent(this, this.fillOrigColorButton, 1, 6, 1, 1, 100, 1, 0, 2);
        UITools.addComponent(this, pointSizeLabel, 0, 7, 1, 1, 1, 1, 2, 1);
        UITools.addComponent(this, this.pointSizeField, 1, 7, 1, 1, 100, 1, 2, 1);
        UITools.addComponent(this, labelColorLabel, 0, 8, 1, 1, 1, 1, 2, 1);
        UITools.addComponent(this, this.labelColorButton, 1, 8, 1, 1, 100, 1, 0, 2);
        UITools.addComponent(this, labelFontSizeLabel, 0, 9, 1, 1, 1, 1, 2, 1);
        UITools.addComponent(this, this.labelFontSizeField, 1, 9, 1, 1, 100, 1, 2, 1);
        UITools.addComponent(this, fontLabel, 0, 10, 1, 1, 1, 1, 2, 1);
        UITools.addComponent(this, this.fontMenu, 1, 10, 1, 1, 100, 1, 2, 1);
    }

    private void initFonts() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.fonts = ge.getAvailableFontFamilyNames();
    }

    private void initStrokes() {
        String name;
        String pattern;
        this.strokes = new ArrayList<DefaultStroke>();
        Preferences preferences = Preferences.getInstance();
        int index = 0;
        while ((pattern = preferences.getString(name = "stroke_" + ++index)) != null) {
            DefaultStroke stroke = new DefaultStroke(pattern);
            this.strokes.add(stroke);
        }
    }

    private void initLocale() {
        Class<?> thisClass = this.getClass();
        String className = thisClass.getName();
        ClassLoader classLoader = thisClass.getClassLoader();
        MessageCatalog catalog = new MessageCatalog(classLoader);
        catalog.loadCatalog(className);
        this.nameString = catalog.translate("name");
        this.chooseString = catalog.translate("choose");
        this.elementColorString = catalog.translate("elementColor");
        this.elementOrigColorString = catalog.translate("elementOrigColor");
        this.lineWidthString = catalog.translate("lineWidth");
        this.lineDashString = catalog.translate("lineDash");
        this.fillColorString = catalog.translate("fillColor");
        this.fillOrigColorString = catalog.translate("fillOrigColor");
        this.pointSizeString = catalog.translate("pointSize");
        this.labelColorString = catalog.translate("labelColor");
        this.labelFontSizeString = catalog.translate("labelFontSize");
        this.fontString = catalog.translate("font");
    }

    public Color getElementColor(boolean original) {
        return original ? this.elementOrigColor : this.elementColor;
    }

    public void setElementColor(Color color, boolean original) {
        if (original) {
            this.elementOrigColor = color;
        } else {
            this.elementColor = color;
        }
        JButton button = original ? this.elementOrigColorButton : this.elementColorButton;
        StylePanel.setButtonColor(button, color);
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public void setLabelColor(Color color) {
        this.labelColor = color;
        StylePanel.setButtonColor(this.labelColorButton, color);
    }

    public Color getFillColor(boolean original) {
        return original ? this.fillOrigColor : this.fillColor;
    }

    public void setFillColor(Color color, boolean original) {
        if (original) {
            this.fillOrigColor = color;
        } else {
            this.fillColor = color;
        }
        JButton button = original ? this.fillOrigColorButton : this.fillColorButton;
        StylePanel.setButtonColor(button, color);
    }

    private static void setButtonColor(JButton button, Color color) {
        Color btColor = color == null ? Color.WHITE : color;
        button.setBackground(color);
        int red = (btColor.getRed() + 128) % 256;
        int green = (btColor.getGreen() + 128) % 256;
        int blue = (btColor.getBlue() + 128) % 256;
        Color foreColor = new Color(red, green, blue);
        button.setForeground(foreColor);
    }

    @Override
    public void setup(StylesManager manager) {
        String name;
        Style style;
        this.manager = manager;
        this.scriptoriumStyle = (ScriptoriumStyle)this.manager.getItem();
        if (this.scriptoriumStyle == null) {
            style = this.manager.getStylePrototype();
            if (style == null) {
                style = new DefaultStyle();
            }
            name = "";
        } else {
            style = this.scriptoriumStyle;
            name = style.getName();
        }
        Color elemColor = style.getElementColor(false);
        Color elemOrigColor = style.getElementColor(true);
        BasicStroke stroke = style.getStroke();
        int pointSize = style.getPointSize();
        Color labColor = style.getLabelColor();
        int labFontSize = style.getLabelFontSize();
        String fontName = style.getFontName();
        float styleWidth = stroke.getLineWidth();
        this.nameField.setText(name);
        this.setElementColor(elemColor, false);
        this.setElementColor(elemOrigColor, true);
        this.lineWidthField.setText(String.valueOf(styleWidth));
        this.lineDashMenu.setSelectedItem(stroke);
        Color fillLocalColor = style.getFillColor(false);
        this.setFillColor(fillLocalColor, false);
        Color fillLocalOrigColor = style.getFillColor(true);
        this.setFillColor(fillLocalOrigColor, true);
        this.pointSizeField.setText(String.valueOf(pointSize));
        this.setLabelColor(labColor);
        this.labelFontSizeField.setText(String.valueOf(labFontSize));
        this.fontMenu.setSelectedItem(fontName);
    }

    @Override
    public boolean okAction() {
        boolean ok;
        DrawingDirector director = this.manager.getDrawingDirector();
        UIConstants uiConstants = UIConstants.getInstance();
        String name = this.nameField.getText();
        if (name.length() > 0) {
            try {
                float width = Float.parseFloat(this.lineWidthField.getText());
                int selectedIndex = this.lineDashMenu.getSelectedIndex();
                String pattern = this.strokes.get(selectedIndex).getPattern();
                DefaultStroke stroke = new DefaultStroke(width, pattern);
                int pointSize = Integer.parseInt(this.pointSizeField.getText());
                int labFontSize = Integer.parseInt(this.labelFontSizeField.getText());
                String fontName = this.fonts[this.fontMenu.getSelectedIndex()];
                StyleSet styleSet = director.getStyleset();
                if (this.scriptoriumStyle == null) {
                    this.scriptoriumStyle = new ScriptoriumStyle(styleSet);
                    styleSet.addStyle(this.scriptoriumStyle);
                    this.manager.addItem(this.scriptoriumStyle);
                } else {
                    styleSet.replaceStyle(this.scriptoriumStyle);
                }
                this.scriptoriumStyle.setName(name);
                this.scriptoriumStyle.setElementColor(this.elementColor, false);
                this.scriptoriumStyle.setElementColor(this.elementOrigColor, true);
                this.scriptoriumStyle.setStroke(stroke);
                this.scriptoriumStyle.setPointSize(pointSize);
                this.scriptoriumStyle.setLabelColor(this.labelColor);
                this.scriptoriumStyle.setFillColor(this.fillColor, false);
                this.scriptoriumStyle.setFillColor(this.fillOrigColor, true);
                this.scriptoriumStyle.setLabelFontSize(labFontSize);
                this.scriptoriumStyle.setFontName(fontName);
                director.setStylesetChanged(true);
                director.repaintMainWindow();
                ok = true;
            }
            catch (NumberFormatException exc) {
                JOptionPane.showMessageDialog(null, String.valueOf(uiConstants.invalidNumberString) + ": " + exc.getMessage(), uiConstants.errorString, 0);
                ok = false;
            }
        } else {
            JOptionPane.showMessageDialog(null, uiConstants.invalidNameString, uiConstants.errorString, 0);
            ok = false;
        }
        return ok && super.okAction();
    }

    @Override
    public boolean closing() {
        this.elementColorButtonListener.dispose();
        this.elementOrigColorButtonListener.dispose();
        this.fillColorButtonListener.dispose();
        this.fillOrigColorButtonListener.dispose();
        this.labelColorButtonListener.dispose();
        return super.closing();
    }
}

