/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui.parts;

import java.awt.Color;
import java.util.List;
import javax.swing.border.LineBorder;
import org.homelinux.elabor.scriptorium.ecomponents.Content;
import org.homelinux.elabor.scriptorium.ecomponents.Edition;
import org.homelinux.elabor.scriptorium.ecomponents.TextPart;
import org.homelinux.elabor.scriptorium.gui.EditionNodeRenderer;
import org.homelinux.elabor.scriptorium.gui.OldScriptoriumListArea;
import org.homelinux.elabor.scriptorium.gui.OntologyInitialiser;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumDirector;
import org.homelinux.elabor.scriptorium.gui.parts.TextPartFrame;
import org.homelinux.elabor.ui.GenericSelectionModel;

public class TextPartsPanel
extends OldScriptoriumListArea<TextPart> {
    private static final long serialVersionUID = 1L;
    private TextPartFrame textPartFrame;

    public TextPartsPanel() {
        super(false, true, true);
        EditionNodeRenderer renderer = new EditionNodeRenderer(OntologyInitialiser.TEXT_PARTS);
        this.setCellRenderer(renderer);
        LineBorder border = new LineBorder(Color.black);
        this.setBorder(border);
        this.textPartFrame = new TextPartFrame();
    }

    @Override
    public void setup(ScriptoriumDirector director, TextPart textPart) {
        Edition edition = director.getEdition();
        Content content = edition.getContent();
        List<TextPart> textParts = content.getTextParts();
        super.setup(director, textParts, textPart);
    }

    private void openTextPartFrame(int index) {
        GenericSelectionModel<TextPart> model = this.getModel();
        this.textPartFrame.setup(model, index);
    }

    @Override
    public void addAction() {
    }

    @Override
    public void remAction(int index, TextPart textPart) {
        GenericSelectionModel model = this.getModel();
        model.removeElementAt(index);
        this.getDirector().downgradeComponent(textPart);
    }

    @Override
    public void editAction(int index, TextPart textPart) {
        this.openTextPartFrame(index);
    }

    @Override
    public boolean closing() {
        if (this.textPartFrame != null) {
            this.textPartFrame.dispose();
        }
        return super.closing();
    }
}

