/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ndraft;

import java.awt.Color;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import org.homelinux.elabor.exceptions.InvalidValueException;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.PointReference;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.ScriptoriumPoint;
import org.homelinux.elabor.scriptorium.ndraft.DirectionListener;
import org.homelinux.elabor.scriptorium.ndraft.FieldsEnabler;
import org.homelinux.elabor.scriptorium.ndraft.FixedLineDirection;
import org.homelinux.elabor.scriptorium.ndraft.LineDirection;
import org.homelinux.elabor.scriptorium.ndraft.ParallelLineDirection;
import org.homelinux.elabor.scriptorium.ndraft.PointCheckBox;
import org.homelinux.elabor.scriptorium.ndraft.PointsListener;
import org.homelinux.elabor.ui.UITools;

public class DirectionArea
extends JPanel
implements FieldsEnabler {
    private static final long serialVersionUID = 1L;
    private static final Iterable<ScriptoriumPoint> NO_DIRECTION_POINT = Arrays.asList(new ScriptoriumPoint[0]);
    private final JTextField directionField = new JTextField();
    private final List<ScriptoriumPoint> selectedPoints;
    private final List<PointCheckBox> checkBoxes;
    private final boolean directionPoints;

    public DirectionArea(String label) {
        this(label, NO_DIRECTION_POINT);
    }

    public DirectionArea(String label, Iterable<ScriptoriumPoint> drawingPoints) {
        super(new GridBagLayout());
        DirectionListener directionListener = new DirectionListener(this);
        this.directionField.getDocument().addDocumentListener(directionListener);
        this.selectedPoints = new ArrayList<ScriptoriumPoint>();
        this.checkBoxes = new ArrayList<PointCheckBox>();
        LineBorder lineBorder = new LineBorder(Color.black);
        TitledBorder titledBorder = new TitledBorder(lineBorder, label);
        this.setBorder(titledBorder);
        JPanel fixedArea = this.buildFixedArea();
        UITools.addComponent(this, fixedArea, 0, 0, 1, 1, 100, 100, 1, 20);
        this.directionPoints = drawingPoints.iterator().hasNext();
        if (this.directionPoints) {
            JPanel parallelArea = this.buildParallelPanel(drawingPoints);
            UITools.addComponent(this, parallelArea, 1, 0, 1, 1, 100, 100, 1, 2);
        }
    }

    private JPanel buildFixedArea() {
        JPanel fixedArea = new JPanel(new GridBagLayout());
        JLabel fixedLabel = new JLabel("degrees");
        UITools.addComponent(fixedArea, fixedLabel, 0, 0, 1, 1, 1, 1, 0, 2);
        UITools.addComponent(fixedArea, this.directionField, 1, 0, 1, 1, 100, 100, 2, 2);
        return fixedArea;
    }

    private JPanel buildParallelPanel(Iterable<ScriptoriumPoint> drawingPoints) {
        JPanel parallelArea = new JPanel(new GridBagLayout());
        JLabel parallelLabel = new JLabel("parallel to");
        UITools.addComponent(parallelArea, parallelLabel, 0, 0, 1, 1, 1, 1, 0, 2);
        JPanel parallelChoice = new JPanel(new GridBagLayout());
        int position = 0;
        for (ScriptoriumPoint point : drawingPoints) {
            PointCheckBox checkBox = new PointCheckBox(point);
            this.checkBoxes.add(checkBox);
            PointsListener listener = new PointsListener(checkBox, this.selectedPoints, this);
            checkBox.addActionListener(listener);
            UITools.addComponent(parallelChoice, checkBox, 1, position, 1, 1, 100, 1, 2, 2);
            ++position;
        }
        UITools.addComponent(parallelArea, parallelChoice, 1, 0, 1, 1, 100, 100, 1, 2);
        return parallelArea;
    }

    public LineDirection getLineDirection() throws InvalidValueException {
        LineDirection lineDirection;
        String text = this.directionField.getText();
        if (text.isEmpty()) {
            if (!this.directionPoints) {
                throw new InvalidValueException("an angle value should be selected");
            }
            if (this.selectedPoints.size() != 2) {
                throw new InvalidValueException("an angle value or two points should be selected");
            }
            Iterator<ScriptoriumPoint> iterator = this.selectedPoints.iterator();
            PointReference firstPointReference = iterator.next().getReference();
            PointReference secondPointReference = iterator.next().getReference();
            lineDirection = new ParallelLineDirection(firstPointReference, secondPointReference);
        } else {
            lineDirection = this.getFixedLineDirection();
        }
        return lineDirection;
    }

    public FixedLineDirection getFixedLineDirection() throws InvalidValueException {
        double degrees;
        String text = this.directionField.getText();
        try {
            degrees = Double.parseDouble(text);
        }
        catch (NumberFormatException exc) {
            throw new InvalidValueException("<" + text + "> is not a valid direction");
        }
        double radiants = degrees * Math.PI / 180.0;
        return new FixedLineDirection(Math.cos(radiants), Math.sin(radiants));
    }

    @Override
    public void enableFields() {
        int count = this.selectedPoints.size();
        this.directionField.setEnabled(count == 0);
        boolean parallelEnabled = this.directionField.getText().isEmpty();
        for (PointCheckBox checkBox : this.checkBoxes) {
            ScriptoriumPoint point = checkBox.getPoint();
            boolean checkBoxSelected = this.selectedPoints.contains(point);
            checkBox.setSelected(parallelEnabled && checkBoxSelected);
            boolean checkBoxEnabled = count < 2 || checkBoxSelected;
            checkBox.setEnabled(parallelEnabled && checkBoxEnabled);
        }
    }
}

