/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ndraft;

import java.awt.Color;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.PointReference;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.ScriptoriumPoint;
import org.homelinux.elabor.scriptorium.ndraft.ChoosePointsArea;
import org.homelinux.elabor.scriptorium.ndraft.EqualToListener;
import org.homelinux.elabor.scriptorium.ndraft.NDraftDrawingFrame;
import org.homelinux.elabor.scriptorium.ndraft.PointCheckBox;
import org.homelinux.elabor.scriptorium.ndraft.SingleButtonHandler;
import org.homelinux.elabor.ui.UITools;

public class EqualToActionDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private final NDraftDrawingFrame frame;
    private final List<ScriptoriumPoint> points;
    private final List<PointCheckBox> checkBoxes;
    private final Set<ScriptoriumPoint> selectedPoints;
    private SingleButtonHandler handler;

    public EqualToActionDialog(NDraftDrawingFrame frame, List<ScriptoriumPoint> points, Iterable<ScriptoriumPoint> drawingPoints) {
        this.setModal(false);
        this.frame = frame;
        this.setSize(500, 400);
        this.setTitle("choose fixed point and distance");
        this.setDefaultCloseOperation(2);
        this.points = points;
        this.checkBoxes = new ArrayList<PointCheckBox>();
        this.selectedPoints = new HashSet<ScriptoriumPoint>();
        this.handler = new SingleButtonHandler();
        ChoosePointsArea pointsArea = new ChoosePointsArea(this.handler, "point", this.points, false, false);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new GridBagLayout());
        UITools.addComponent(contentPane, pointsArea, 0, 0, 1, 1, 100, 1, 1, 2);
        JPanel equalToArea = this.buildEqualToArea(drawingPoints);
        UITools.addComponent(this, equalToArea, 0, 1, 1, 1, 100, 100, 1, 2);
        JButton button = new JButton("ok");
        button.addActionListener(this);
        UITools.addComponent(contentPane, button, 0, 3, 1, 1, 100, 10, 0, 2);
    }

    private JPanel buildEqualToArea(Iterable<ScriptoriumPoint> drawingPoints) {
        JPanel equalToArea = new JPanel(new GridBagLayout());
        LineBorder lineBorder = new LineBorder(Color.black);
        TitledBorder titledBorder = new TitledBorder(lineBorder, "distance equal to distance from");
        equalToArea.setBorder(titledBorder);
        JPanel pointChoiche = new JPanel(new GridBagLayout());
        int position = 0;
        for (ScriptoriumPoint point : drawingPoints) {
            PointCheckBox checkBox = new PointCheckBox(point);
            this.checkBoxes.add(checkBox);
            EqualToListener listener = new EqualToListener(checkBox, this.selectedPoints, this);
            checkBox.addActionListener(listener);
            UITools.addComponent(pointChoiche, checkBox, 1, position, 1, 1, 100, 1, 2, 2);
            ++position;
        }
        JScrollPane scrollPane = new JScrollPane(pointChoiche);
        UITools.addComponent(equalToArea, scrollPane, 1, 0, 1, 1, 100, 100, 1, 2);
        return equalToArea;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        ScriptoriumPoint fixedPoint = this.handler.getSelectedPoint();
        if (fixedPoint == null) {
            JOptionPane.showMessageDialog(null, "you should select the fixed point");
        } else if (this.selectedPoints.size() == 2) {
            Iterator<ScriptoriumPoint> iterator = this.selectedPoints.iterator();
            PointReference firstPoint = iterator.next().getReference();
            PointReference secondPoint = iterator.next().getReference();
            PointReference movingPoint = this.getMovingPoint(fixedPoint);
            PointReference fixedPointReference = fixedPoint.getReference();
            this.frame.addEqualToAction(fixedPointReference, movingPoint, firstPoint, secondPoint);
            this.dispose();
        } else {
            JOptionPane.showMessageDialog(null, "two points should be selected");
        }
    }

    private PointReference getMovingPoint(ScriptoriumPoint fixedPoint) {
        ScriptoriumPoint firstPoint = this.points.get(0);
        ScriptoriumPoint secondPoint = this.points.get(1);
        return (firstPoint.equals(fixedPoint) ? secondPoint : firstPoint).getReference();
    }

    public void enableFields() {
        int count = this.selectedPoints.size();
        for (PointCheckBox checkBox : this.checkBoxes) {
            ScriptoriumPoint point = checkBox.getPoint();
            boolean checkBoxSelected = this.selectedPoints.contains(point);
            checkBox.setSelected(checkBoxSelected);
            boolean checkBoxEnabled = count < 2 || checkBoxSelected;
            checkBox.setEnabled(checkBoxEnabled);
        }
    }
}

