/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ndraft;

import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import org.homelinux.elabor.arrays.Condition;
import org.homelinux.elabor.arrays.Filter;
import org.homelinux.elabor.exceptions.InvalidValueException;
import org.homelinux.elabor.scriptorium.ecomponents.Annotation;
import org.homelinux.elabor.scriptorium.ecomponents.Citation;
import org.homelinux.elabor.scriptorium.ecomponents.Comment;
import org.homelinux.elabor.scriptorium.ecomponents.Content;
import org.homelinux.elabor.scriptorium.ecomponents.Crux;
import org.homelinux.elabor.scriptorium.ecomponents.DateToken;
import org.homelinux.elabor.scriptorium.ecomponents.Edition;
import org.homelinux.elabor.scriptorium.ecomponents.EditionComponent;
import org.homelinux.elabor.scriptorium.ecomponents.EditionListener;
import org.homelinux.elabor.scriptorium.ecomponents.EditionMapper;
import org.homelinux.elabor.scriptorium.ecomponents.Enunciatio;
import org.homelinux.elabor.scriptorium.ecomponents.Expunctio;
import org.homelinux.elabor.scriptorium.ecomponents.Folium;
import org.homelinux.elabor.scriptorium.ecomponents.Image;
import org.homelinux.elabor.scriptorium.ecomponents.Integratio;
import org.homelinux.elabor.scriptorium.ecomponents.MathConcept;
import org.homelinux.elabor.scriptorium.ecomponents.Name;
import org.homelinux.elabor.scriptorium.ecomponents.Place;
import org.homelinux.elabor.scriptorium.ecomponents.TextPart;
import org.homelinux.elabor.scriptorium.ecomponents.Tongue;
import org.homelinux.elabor.scriptorium.ecomponents.Unit;
import org.homelinux.elabor.scriptorium.ecomponents.ValuedComposite;
import org.homelinux.elabor.scriptorium.ecomponents.Variant;
import org.homelinux.elabor.scriptorium.ecomponents.Work;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.BackgroundImage;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.Drawing;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.PointReference;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.ScriptoriumPoint;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.ShapeAdapter;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.styles.StyleSetReference;
import org.homelinux.elabor.scriptorium.ecomponents.visitors.EditionUpgrade;
import org.homelinux.elabor.scriptorium.gui.ComponentObserver;
import org.homelinux.elabor.scriptorium.gui.EditionComponentFrame;
import org.homelinux.elabor.scriptorium.gui.Preferences;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumDirector;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumSelector;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumStyledDocument;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumTextPane;
import org.homelinux.elabor.scriptorium.gui.TextPanel;
import org.homelinux.elabor.scriptorium.gui.VariantsPanel;
import org.homelinux.elabor.scriptorium.gui.drawings.DrawingTitleListener;
import org.homelinux.elabor.scriptorium.gui.metadata.MetadataPanel;
import org.homelinux.elabor.scriptorium.gui.variants.VariantPanel;
import org.homelinux.elabor.scriptorium.ndraft.AxisMenuListener;
import org.homelinux.elabor.scriptorium.ndraft.DirectionLineDialog;
import org.homelinux.elabor.scriptorium.ndraft.EllipseActionDialog;
import org.homelinux.elabor.scriptorium.ndraft.EllipseMenuListener;
import org.homelinux.elabor.scriptorium.ndraft.EqualToActionDialog;
import org.homelinux.elabor.scriptorium.ndraft.EqualToMenuListener;
import org.homelinux.elabor.scriptorium.ndraft.HyperbolaActionDialog;
import org.homelinux.elabor.scriptorium.ndraft.HyperbolaMenuListener;
import org.homelinux.elabor.scriptorium.ndraft.LineDirection;
import org.homelinux.elabor.scriptorium.ndraft.NDraftDrawingDirector;
import org.homelinux.elabor.scriptorium.ndraft.NDraftDrawingPanel;
import org.homelinux.elabor.scriptorium.ndraft.NDraftExportDirectoryFactory;
import org.homelinux.elabor.scriptorium.ndraft.ParabolaActionDialog;
import org.homelinux.elabor.scriptorium.ndraft.ParabolaMenuListener;
import org.homelinux.elabor.scriptorium.ndraft.PointsLineDialog;
import org.homelinux.elabor.scriptorium.ndraft.RedoActionListener;
import org.homelinux.elabor.scriptorium.ndraft.SnapActionDialog;
import org.homelinux.elabor.scriptorium.ndraft.SnapMenuListener;
import org.homelinux.elabor.scriptorium.ndraft.StraightMenuListener;
import org.homelinux.elabor.scriptorium.ndraft.TangentActionDialog;
import org.homelinux.elabor.scriptorium.ndraft.TangentMenuListener;
import org.homelinux.elabor.scriptorium.ndraft.UndoActionListener;
import org.homelinux.elabor.scriptorium.ndraft.UndoAddComputeAction;
import org.homelinux.elabor.scriptorium.ndraft.actions.AbstractAction;
import org.homelinux.elabor.scriptorium.ndraft.actions.ActionPoint;
import org.homelinux.elabor.scriptorium.ndraft.actions.AxisAction;
import org.homelinux.elabor.scriptorium.ndraft.actions.ComputeAction;
import org.homelinux.elabor.scriptorium.ndraft.actions.DraftProjection;
import org.homelinux.elabor.scriptorium.ndraft.actions.EllipseAction;
import org.homelinux.elabor.scriptorium.ndraft.actions.EqualToAction;
import org.homelinux.elabor.scriptorium.ndraft.actions.HyperbolaAction;
import org.homelinux.elabor.scriptorium.ndraft.actions.ParabolaAction;
import org.homelinux.elabor.scriptorium.ndraft.actions.SnapAction;
import org.homelinux.elabor.scriptorium.ndraft.actions.StraightLineAction;
import org.homelinux.elabor.scriptorium.ndraft.actions.StraightLineDirectionAction;
import org.homelinux.elabor.scriptorium.ndraft.actions.TangentAction;
import org.homelinux.elabor.scriptorium.services.EditionManager;
import org.homelinux.elabor.scriptorium.services.Finder;
import org.homelinux.elabor.scriptorium.utils.Version;
import org.homelinux.elabor.structures.StructuresHelper;
import org.homelinux.elabor.structures.extractors.KeyExtractor;
import org.homelinux.elabor.tools.MessageCatalog;
import org.homelinux.elabor.ui.GenericSelectionModel;
import org.homelinux.elabor.ui.UIConstants;

public class NDraftDrawingFrame
extends EditionComponentFrame<Drawing, NDraftDrawingPanel>
implements ScriptoriumDirector,
WindowListener,
DrawingTitleListener {
    private static final long serialVersionUID = 1L;
    private String fileMenuLabel;
    private String newLabel;
    private String openLabel;
    private String saveExportLabel;
    private String saveasLabel;
    private String newFileTitleString;
    private String newStylesetTitleString;
    private String editionFileName;
    private String editMenuLabel;
    private String undoLabel;
    private String redoLabel;
    private String drawMenuLabel;
    private String straightLabel;
    private String axisLabel;
    private String equalToLabel;
    private String parabolaLabel;
    private String ellipseLabel;
    private String hyperbolaLabel;
    private String snapLabel;
    private String tangentLabel;
    private String stylesetFileName;
    private String theresADrawingString;
    private String wantSaveString;
    private String theresAStylesetString;
    private String stylesLabel;
    private String loadStylesLabel;
    private String editStylesLabel;
    private String saveStylesLabel;
    private String toggleOriginalLabel;
    private JMenuItem newJMI;
    private JMenuItem openJMI;
    private JMenuItem saveExportJMI;
    private JMenuItem saveasJMI;
    private JMenuItem loadStylesJMI;
    private JMenuItem editStylesJMI;
    private JMenuItem saveStylesJMI;
    private JMenuItem toggleOriginalJMI;
    private Edition edition;

    public NDraftDrawingFrame() {
        super(new NDraftDrawingPanel());
        this.setSize(1200, 1000);
        this.initLocale();
        this.initMenubar();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
        NDraftDrawingDirector drawingDirector = this.getDrawingDirector();
        drawingDirector.addStyleListener(this);
    }

    private void initLocale() {
        MessageCatalog catalog = new MessageCatalog();
        Preferences preferences = Preferences.getInstance();
        String locale = preferences.getProperty("locale");
        catalog.loadCatalog(this.getClass().getName(), locale);
        this.fileMenuLabel = catalog.translate("fileMenu");
        this.newLabel = catalog.translate("newItem");
        this.openLabel = catalog.translate("openItem");
        this.saveExportLabel = catalog.translate("save_exportItem");
        this.saveasLabel = catalog.translate("saveasItem");
        this.newFileTitleString = catalog.translate("newFileTitle");
        this.newStylesetTitleString = catalog.translate("newStyleset");
        this.theresADrawingString = catalog.translate("theresADrawing");
        this.wantSaveString = catalog.translate("wantSave");
        this.theresAStylesetString = catalog.translate("theresAStyleset");
        this.editMenuLabel = catalog.translate("edit");
        this.undoLabel = catalog.translate("undo");
        this.redoLabel = catalog.translate("redo");
        this.drawMenuLabel = catalog.translate("drawMenu");
        this.straightLabel = catalog.translate("straightItem");
        this.axisLabel = catalog.translate("axisItem");
        this.equalToLabel = catalog.translate("equalToItem");
        this.parabolaLabel = catalog.translate("parabolaItem");
        this.ellipseLabel = catalog.translate("ellipseItem");
        this.hyperbolaLabel = catalog.translate("hyperbolaItem");
        this.snapLabel = catalog.translate("snapItem");
        this.tangentLabel = catalog.translate("tangentItem");
        this.stylesLabel = catalog.translate("styles");
        this.loadStylesLabel = catalog.translate("loadStyles");
        this.editStylesLabel = catalog.translate("editStyles");
        this.saveStylesLabel = catalog.translate("saveStyles");
        this.toggleOriginalLabel = catalog.translate("toggleOriginal");
    }

    private void initMenubar() {
        Preferences prefer = Preferences.getInstance();
        boolean magnetic = prefer.getBoolean("snap_to_grid");
        boolean showInvisibles = prefer.getBoolean("show_invisibles");
        boolean showBackground = prefer.getBoolean("show_background_image");
        boolean showLabels = prefer.getBoolean("show_labels");
        boolean shading = prefer.getBoolean("shading");
        boolean showGrid = prefer.getBoolean("show_grid");
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = this.initFileMenu();
        menuBar.add(fileMenu);
        JMenu editMenu = this.initEditMenu();
        menuBar.add(editMenu);
        JMenu drawMenu = this.initDrawMenu();
        menuBar.add(drawMenu);
        JMenu styleMenu = this.initStyleMenu();
        menuBar.add(styleMenu);
        this.setJMenuBar(menuBar);
        this.loadStylesJMI.addActionListener(this);
        this.editStylesJMI.addActionListener(this);
        this.saveStylesJMI.addActionListener(this);
        this.toggleOriginalJMI.addActionListener(this);
        NDraftDrawingPanel panel = (NDraftDrawingPanel)this.getPanel();
        panel.setShowInvisibles(showInvisibles);
        panel.setShowBackground(showBackground);
        panel.setShowDrawing(true);
        panel.setShowLabels(showLabels);
        panel.setShowPointRectangles(true);
        panel.setShading(shading);
        panel.setShowGrid(showGrid);
        panel.setMagnetic(magnetic);
    }

    private JMenu initFileMenu() {
        JMenu fileMenu = new JMenu(this.fileMenuLabel);
        this.newJMI = new JMenuItem(this.newLabel);
        this.newJMI.addActionListener(this);
        fileMenu.add(this.newJMI);
        this.openJMI = new JMenuItem(this.openLabel);
        this.openJMI.addActionListener(this);
        fileMenu.add(this.openJMI);
        this.saveExportJMI = new JMenuItem(this.saveExportLabel);
        this.saveExportJMI.addActionListener(this);
        fileMenu.add(this.saveExportJMI);
        this.saveasJMI = new JMenuItem(this.saveasLabel);
        this.saveasJMI.addActionListener(this);
        fileMenu.add(this.saveasJMI);
        return fileMenu;
    }

    private JMenu initEditMenu() {
        NDraftDrawingDirector director = this.getDrawingDirector();
        JMenu editMenu = new JMenu(this.editMenuLabel);
        JMenuItem undoJMI = new JMenuItem(this.undoLabel);
        undoJMI.addActionListener(new UndoActionListener(director));
        undoJMI.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        editMenu.add(undoJMI);
        JMenuItem redoJMI = new JMenuItem(this.redoLabel);
        redoJMI.addActionListener(new RedoActionListener(director));
        redoJMI.setAccelerator(KeyStroke.getKeyStroke(89, 2));
        editMenu.add(redoJMI);
        return editMenu;
    }

    private JMenu initDrawMenu() {
        JMenu drawMenu = new JMenu(this.drawMenuLabel);
        JMenuItem straightJMI = new JMenuItem(this.straightLabel);
        StraightMenuListener straightMenuListener = new StraightMenuListener(this);
        straightJMI.addActionListener(straightMenuListener);
        drawMenu.add(straightJMI);
        JMenuItem axisJMI = new JMenuItem(this.axisLabel);
        AxisMenuListener axisMenuListener = new AxisMenuListener(this);
        axisJMI.addActionListener(axisMenuListener);
        drawMenu.add(axisJMI);
        JMenuItem equalToJMI = new JMenuItem(this.equalToLabel);
        EqualToMenuListener equalToMenuListener = new EqualToMenuListener(this);
        equalToJMI.addActionListener(equalToMenuListener);
        drawMenu.add(equalToJMI);
        JMenuItem parabolaJMI = new JMenuItem(this.parabolaLabel);
        ParabolaMenuListener parabolaMenuListener = new ParabolaMenuListener(this);
        parabolaJMI.addActionListener(parabolaMenuListener);
        drawMenu.add(parabolaJMI);
        JMenuItem ellipseJMI = new JMenuItem(this.ellipseLabel);
        EllipseMenuListener ellipseMenuListener = new EllipseMenuListener(this);
        ellipseJMI.addActionListener(ellipseMenuListener);
        drawMenu.add(ellipseJMI);
        JMenuItem hyperbolaJMI = new JMenuItem(this.hyperbolaLabel);
        HyperbolaMenuListener hyperbolaMenuListener = new HyperbolaMenuListener(this);
        hyperbolaJMI.addActionListener(hyperbolaMenuListener);
        drawMenu.add(hyperbolaJMI);
        JMenuItem snapJMI = new JMenuItem(this.snapLabel);
        SnapMenuListener snapMenuListener = new SnapMenuListener(this);
        snapJMI.addActionListener(snapMenuListener);
        drawMenu.add(snapJMI);
        JMenuItem tangentJMI = new JMenuItem(this.tangentLabel);
        TangentMenuListener tangentMenuListener = new TangentMenuListener(this);
        tangentJMI.addActionListener(tangentMenuListener);
        drawMenu.add(tangentJMI);
        return drawMenu;
    }

    private JMenu initStyleMenu() {
        JMenu styles = new JMenu(this.stylesLabel);
        this.loadStylesJMI = new JMenuItem(this.loadStylesLabel);
        this.editStylesJMI = new JMenuItem(this.editStylesLabel);
        this.saveStylesJMI = new JMenuItem(this.saveStylesLabel);
        styles.add(this.loadStylesJMI);
        styles.add(this.editStylesJMI);
        styles.add(this.saveStylesJMI);
        styles.add(new JSeparator());
        this.toggleOriginalJMI = new JMenuItem(this.toggleOriginalLabel);
        styles.add(this.toggleOriginalJMI);
        return styles;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        NDraftDrawingDirector director = this.getDrawingDirector();
        NDraftDrawingPanel panel = (NDraftDrawingPanel)this.getPanel();
        if (source == this.newJMI) {
            if (this.checkSaved()) {
                this.resetOptions();
                this.newDrawing();
            }
        } else if (source == this.openJMI) {
            if (this.checkSaved()) {
                this.resetOptions();
                this.openDrawing();
            }
        } else if (source == this.saveStylesJMI) {
            director.saveStyleset();
        } else if (source == this.toggleOriginalJMI) {
            director.toggleOriginal();
        } else if (source == this.saveExportJMI) {
            this.saveDrawing(false);
        } else if (source == this.loadStylesJMI) {
            if (this.checkStylesetSaved()) {
                panel.loadStyleset();
            }
        } else if (source == this.editStylesJMI) {
            panel.openStylesFrame();
        } else if (source == this.saveasJMI) {
            this.saveDrawing(true);
        } else {
            super.actionPerformed(event);
        }
    }

    public boolean checkStylesetSaved() {
        boolean save = true;
        NDraftDrawingDirector director = this.getDrawingDirector();
        if (director.isStylesetChanged()) {
            int option = JOptionPane.showConfirmDialog(null, String.valueOf(this.theresAStylesetString) + " " + this.wantSaveString, UIConstants.getInstance().warningString, 1);
            if (option == 0) {
                director.saveStyleset();
            } else {
                save = option == 1;
            }
        }
        return save;
    }

    public void resetOptions() {
        NDraftDrawingPanel panel = (NDraftDrawingPanel)this.getPanel();
        panel.setShowDrawing(true);
        panel.setShowBackground(true);
    }

    @Override
    public void drawingChanged() {
        this.setWindowTitle();
    }

    private void setWindowTitle() {
        Version version = Version.getInstance();
        String relNumber = version.getReleaseNumber();
        String relDate = version.getReleaseDate();
        NDraftDrawingDirector drawingDirector = this.getDrawingDirector();
        String title = "NDraft " + relNumber + " - " + relDate + " - " + this.editionFileName;
        if (drawingDirector.isEditionChanged()) {
            title = String.valueOf(title) + " *";
        }
        title = String.valueOf(title) + " (";
        title = this.stylesetFileName == null ? String.valueOf(title) + this.newStylesetTitleString : String.valueOf(title) + this.stylesetFileName;
        if (drawingDirector.isStylesetChanged()) {
            title = String.valueOf(title) + " *";
        }
        title = String.valueOf(title) + ")";
        this.setTitle(title);
    }

    public boolean checkSaved() {
        return this.checkDrawingSaved();
    }

    private boolean checkDrawingSaved() {
        boolean modify = true;
        NDraftDrawingDirector director = this.getDrawingDirector();
        if (director.isEditionChanged()) {
            int option = JOptionPane.showConfirmDialog(null, String.valueOf(this.theresADrawingString) + " " + this.wantSaveString, UIConstants.getInstance().warningString, 1);
            if (option == 0) {
                this.saveDrawing(false);
            }
            modify = option != 2;
        }
        return modify;
    }

    public void newDrawing() {
        this.edition = new Edition();
        this.editionFileName = this.newFileTitleString;
        this.setupEdition(this.edition);
    }

    private void openDrawing() {
        try {
            EditionManager editionManager = EditionManager.getInstance();
            Edition newEdition = editionManager.loadEdition(null);
            if (newEdition != null) {
                this.edition = newEdition;
                File file = this.edition.getFile();
                this.editionFileName = file.getName();
                this.setupEdition(this.edition);
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            UIConstants uiConstants = UIConstants.getInstance();
            JOptionPane.showMessageDialog(null, String.valueOf(uiConstants.errorOccurredString) + " " + e.getMessage(), uiConstants.errorString, 0);
        }
    }

    private void setupEdition(Edition edition) {
        Drawing drawing;
        NDraftDrawingDirector drawingDirector = this.getDrawingDirector();
        EditionUpgrade visitor = new EditionUpgrade();
        visitor.visit(edition);
        Content content = edition.getContent();
        List<Drawing> drawings = content.getDrawings();
        if (drawings.size() == 0) {
            drawing = new Drawing(content, drawingDirector);
            content.addChild(drawing);
        } else {
            drawing = drawings.get(0);
            drawing.setListener(drawingDirector);
        }
        this.setup(this, drawing);
        this.setWindowTitle();
        this.repaint();
    }

    public void saveDrawing(boolean withName) {
        NDraftDrawingDirector director = this.getDrawingDirector();
        if (director.handleHistorySave()) {
            NDraftExportDirectoryFactory exportDirectorFactory;
            boolean ok;
            NDraftDrawingPanel panel = (NDraftDrawingPanel)this.getPanel();
            panel.okAction();
            String suggestedFileName = null;
            EditionManager editionManager = EditionManager.getInstance();
            Content content = this.edition.getContent();
            List<Drawing> drawings = content.getDrawings();
            Drawing drawing = drawings.get(0);
            BackgroundImage backgroundImage = drawing.getBackgroundImage();
            if (backgroundImage != null) {
                URI imageUri = backgroundImage.getUri();
                File backgroundFile = editionManager.getImageFile(imageUri, this.edition);
                String backgroundFileName = backgroundFile.getAbsolutePath();
                int index = backgroundFileName.lastIndexOf(".");
                suggestedFileName = String.valueOf(backgroundFileName.substring(0, index)) + ".xml";
            }
            if (ok = editionManager.saveEdition(this.edition, withName, suggestedFileName, exportDirectorFactory = new NDraftExportDirectoryFactory())) {
                this.exportDiaDiagram();
                NDraftDrawingDirector drawingDirector = this.getDrawingDirector();
                drawingDirector.resetEditionChanged();
                this.setWindowTitle();
            }
        }
    }

    private void exportDiaDiagram() {
        NDraftDrawingPanel panel = (NDraftDrawingPanel)this.getPanel();
        panel.okAction();
        File file = this.edition.getFile();
        this.editionFileName = file.getName();
        this.setWindowTitle();
        EditionManager editionManager = EditionManager.getInstance();
        editionManager.export(this.edition, "diagrams.xst", ".dia");
    }

    @Override
    public void stylesetChanged(StyleSetReference styleSet) {
        File ssDefaultFolder = EditionManager.getStylesetDefaultFolder(this.edition);
        File stylesetFile = styleSet.getFile(ssDefaultFolder);
        this.stylesetFileName = stylesetFile == null ? null : stylesetFile.getName();
        this.setWindowTitle();
    }

    @Override
    public Edition getEdition() {
        return this.edition;
    }

    @Override
    public EditionMapper getMapper() {
        return null;
    }

    @Override
    public Finder getFinder() {
        return null;
    }

    @Override
    public ScriptoriumStyledDocument getStyledDocument() {
        return null;
    }

    @Override
    public TextPanel getTextPanel() {
        return null;
    }

    @Override
    public void singleClickOn(ScriptoriumTextPane pane) {
    }

    @Override
    public void doubleClickOn(ScriptoriumTextPane pane) {
    }

    @Override
    public void valueChanged(VariantsPanel panel) {
    }

    @Override
    public void valueChanged(VariantPanel panel) {
    }

    @Override
    public void valueChanged(MetadataPanel panel) {
    }

    @Override
    public <T extends EditionComponent<?>> void valueChanged(ScriptoriumSelector<T> panel) {
    }

    @Override
    public void updateText() {
    }

    @Override
    public void highlightText(int offset, int length) {
    }

    @Override
    public <eN extends EditionComponent<?>> void downgradeComponent(eN component) {
    }

    @Override
    public <vC extends ValuedComposite<?>> void downgradeComponent(vC composite) {
    }

    @Override
    public void downloadEdition(URI uuid) {
    }

    @Override
    public void addComponentObserver(ComponentObserver observer) {
    }

    @Override
    public void removeComponentObserver(ComponentObserver observer) {
    }

    public File getCurrentDirectory() {
        return null;
    }

    @Override
    public void windowOpened(WindowEvent arg0) {
    }

    @Override
    public void windowClosing(WindowEvent arg0) {
        if (this.checkSaved()) {
            this.dispose();
        }
    }

    @Override
    public void windowClosed(WindowEvent arg0) {
    }

    @Override
    public void windowIconified(WindowEvent arg0) {
    }

    @Override
    public void windowDeiconified(WindowEvent arg0) {
    }

    @Override
    public void windowActivated(WindowEvent arg0) {
    }

    @Override
    public void windowDeactivated(WindowEvent arg0) {
    }

    @Override
    public void updateSummaryPanel() {
    }

    @Override
    public void openAnnotationsFrame(Annotation annotation) {
    }

    @Override
    public void openCitationsFrame(Citation citation) {
    }

    @Override
    public void openCommentsFrame(Comment comment) {
    }

    @Override
    public void openCrucesFrame(Crux crux) {
    }

    @Override
    public void openDateTokensFrame(DateToken dateToken) {
    }

    @Override
    public void openDrawingFrame(Drawing drawing) {
    }

    @Override
    public void openEnunciationesFrame(Enunciatio enunciatio) {
    }

    @Override
    public void openExpunctionesFrame(Expunctio expunctio) {
    }

    @Override
    public void openFoliaFrame(Folium folium) {
    }

    @Override
    public void openIntegrationesFrame(Integratio integratio) {
    }

    @Override
    public void openMathConceptsFrame(MathConcept mathConcept) {
    }

    @Override
    public void openNamesFrame(Name name) {
    }

    @Override
    public void openPlacesFrame(Place place) {
    }

    @Override
    public void openTextPartsFrame(TextPart textPart) {
    }

    @Override
    public void openTonguesFrame(Tongue tongue) {
    }

    @Override
    public void openUnitsFrame(Unit unit) {
    }

    @Override
    public void openVariantFrame(Variant variant) {
    }

    @Override
    public void openWorksFrame(Work work) {
    }

    @Override
    public void openImagesFrame(Image image) {
    }

    @Override
    public void openDrawingsFrame(Drawing drawing) {
    }

    private NDraftDrawingDirector getDrawingDirector() {
        NDraftDrawingPanel panel = (NDraftDrawingPanel)this.getPanel();
        return panel.getDrawingDirector();
    }

    public void addAxisAction() throws InvalidValueException {
        NDraftDrawingDirector drawingDirector = this.getDrawingDirector();
        List<ScriptoriumPoint> selectedPoints = drawingDirector.getSelectedPoints();
        if (selectedPoints.size() != 3) {
            throw new InvalidValueException("at least 3 points have to be selected");
        }
        int option = NDraftDrawingFrame.choosePoint(selectedPoints, "choose the point to move", "point");
        if (option >= 0 && option < selectedPoints.size()) {
            ScriptoriumPoint mobilePoint = selectedPoints.get(option);
            DraftProjection projection = NDraftDrawingFrame.chooseProjection();
            if (projection != null) {
                AxisAction innerAction = new AxisAction();
                ComputeAction action = this.createAction(innerAction);
                List<ActionPoint> actionPoints = NDraftDrawingFrame.buildActionPoints(mobilePoint, projection, (EditionListener)drawingDirector);
                innerAction.setActionPoints(actionPoints);
                List<ScriptoriumPoint> fixedPoints = NDraftDrawingFrame.getFixedPoints(selectedPoints, mobilePoint);
                innerAction.setFixedPoints(fixedPoints);
                this.appendAction(action);
            }
        }
    }

    private static List<ScriptoriumPoint> getFixedPoints(List<ScriptoriumPoint> selectedPoints, final ScriptoriumPoint mobilePoint) {
        Condition<ScriptoriumPoint> condition = new Condition<ScriptoriumPoint>(){

            @Override
            public boolean check(ScriptoriumPoint item) {
                return !item.equals(mobilePoint);
            }
        };
        Filter<ScriptoriumPoint> filter = new Filter<ScriptoriumPoint>(condition);
        List<ScriptoriumPoint> fixedPoints = filter.filter(selectedPoints);
        return fixedPoints;
    }

    public void addEqualToAction() throws InvalidValueException {
        NDraftDrawingDirector drawingDirector = this.getDrawingDirector();
        List<ScriptoriumPoint> selectedPoints = drawingDirector.getSelectedPoints();
        if (selectedPoints.size() != 2) {
            throw new InvalidValueException("exactly 2 points have to be selected");
        }
        this.addEqualToAction(selectedPoints);
    }

    public void addParabolaAction() throws InvalidValueException {
        NDraftDrawingDirector drawingDirector = this.getDrawingDirector();
        List<ScriptoriumPoint> selectedPoints = drawingDirector.getSelectedPoints();
        if (selectedPoints.size() != 2) {
            throw new InvalidValueException("exactly 2 points have to be selected");
        }
        this.addParabolaAction(selectedPoints);
    }

    public void addEllipseAction() throws InvalidValueException {
        NDraftDrawingDirector drawingDirector = this.getDrawingDirector();
        List<ScriptoriumPoint> selectedPoints = drawingDirector.getSelectedPoints();
        int size = selectedPoints.size();
        if (size != 2 && size != 3) {
            throw new InvalidValueException("2 or 3 points have to be selected");
        }
        this.addEllipseAction(selectedPoints);
    }

    public void addHyperbolaAction() throws InvalidValueException {
        NDraftDrawingDirector drawingDirector = this.getDrawingDirector();
        List<ScriptoriumPoint> selectedPoints = drawingDirector.getSelectedPoints();
        int size = selectedPoints.size();
        if (size != 2 && size != 3) {
            throw new InvalidValueException("2 or 3 points have to be selected");
        }
        this.addHyperbolaAction(selectedPoints);
    }

    public void addSnapAction() throws InvalidValueException {
        NDraftDrawingDirector drawingDirector = this.getDrawingDirector();
        List<ScriptoriumPoint> selectedPoints = drawingDirector.getSelectedPoints();
        if (selectedPoints.isEmpty()) {
            throw new InvalidValueException("some points have to be selected");
        }
        Drawing drawing = drawingDirector.getDrawing();
        List<ComputeAction> actions = drawing.getComputeActions();
        if (actions.isEmpty()) {
            throw new InvalidValueException("no computed action is defined");
        }
        this.addSnapAction(selectedPoints, actions);
    }

    private void addEqualToAction(List<ScriptoriumPoint> points) {
        NDraftDrawingDirector drawingDirector = this.getDrawingDirector();
        GenericSelectionModel<ScriptoriumPoint> drawingPoints = drawingDirector.getPointsModel();
        EqualToActionDialog dialog = new EqualToActionDialog(this, points, drawingPoints);
        dialog.setVisible(true);
    }

    public void addTangentAction() throws InvalidValueException {
        NDraftDrawingDirector drawingDirector = this.getDrawingDirector();
        List<ScriptoriumPoint> selectedPoints = drawingDirector.getSelectedPoints();
        if (selectedPoints.size() < 1) {
            throw new InvalidValueException("some point have to be selected");
        }
        Drawing drawing = drawingDirector.getDrawing();
        GenericSelectionModel<ScriptoriumPoint> drawingPoints = drawingDirector.getPointsModel();
        List<ComputeAction> drawingActions = drawing.getComputeActions();
        TangentActionDialog dialog = new TangentActionDialog(this, selectedPoints, drawingPoints, drawingActions);
        dialog.setVisible(true);
    }

    private void addParabolaAction(List<ScriptoriumPoint> points) {
        NDraftDrawingDirector drawingDirector = this.getDrawingDirector();
        GenericSelectionModel<ScriptoriumPoint> drawingPoints = drawingDirector.getPointsModel();
        ParabolaActionDialog dialog = new ParabolaActionDialog(this, points, drawingPoints);
        dialog.setVisible(true);
    }

    private void addEllipseAction(List<ScriptoriumPoint> points) {
        NDraftDrawingDirector drawingDirector = this.getDrawingDirector();
        GenericSelectionModel<ScriptoriumPoint> drawingPoints = drawingDirector.getPointsModel();
        EllipseActionDialog dialog = new EllipseActionDialog(this, points, drawingPoints);
        dialog.setVisible(true);
    }

    private void addHyperbolaAction(List<ScriptoriumPoint> points) {
        NDraftDrawingDirector drawingDirector = this.getDrawingDirector();
        GenericSelectionModel<ScriptoriumPoint> drawingPoints = drawingDirector.getPointsModel();
        HyperbolaActionDialog dialog = new HyperbolaActionDialog(this, points, drawingPoints);
        dialog.setVisible(true);
    }

    private void addSnapAction(List<ScriptoriumPoint> points, List<ComputeAction> actions) {
        NDraftDrawingDirector drawingDirector = this.getDrawingDirector();
        GenericSelectionModel<ScriptoriumPoint> drawingPoints = drawingDirector.getPointsModel();
        SnapActionDialog dialog = new SnapActionDialog(this, points, actions, drawingPoints);
        dialog.setVisible(true);
    }

    public void addStraightLine() throws InvalidValueException {
        NDraftDrawingDirector drawingDirector = this.getDrawingDirector();
        List<ScriptoriumPoint> selectedPoints = drawingDirector.getSelectedPoints();
        if (selectedPoints.size() < 2) {
            throw new InvalidValueException("at least 2 points have to be selected");
        }
        int option = JOptionPane.showOptionDialog(null, "choose an option", "type of straight line", 0, 3, null, new String[]{"some fixed points", "one point fixed and direction"}, null);
        switch (option) {
            case 0: {
                this.addManyPointsLine(selectedPoints);
                break;
            }
            case 1: {
                this.addDirectionLine(selectedPoints);
                break;
            }
        }
    }

    private void addDirectionLine(List<ScriptoriumPoint> points) {
        NDraftDrawingDirector drawingDirector = this.getDrawingDirector();
        Iterable<ComputeAction> actions = drawingDirector.getComputeActions();
        GenericSelectionModel<ScriptoriumPoint> drawingPoints = drawingDirector.getPointsModel();
        DirectionLineDialog dialog = new DirectionLineDialog(this, points, actions, drawingPoints);
        dialog.setVisible(true);
    }

    public void addEqualToAction(PointReference fixedPoint, PointReference movingPoint, PointReference firstPoint, PointReference secondPoint) {
        EqualToAction innerAction = new EqualToAction();
        ComputeAction action = this.createAction(innerAction);
        innerAction.setFixedPoint(fixedPoint);
        innerAction.setMovingPoint(movingPoint);
        innerAction.setFirstDistancePoint(firstPoint);
        innerAction.setSecondDistancePoint(secondPoint);
        this.appendAction(action);
    }

    public void addParabolaAction(ScriptoriumPoint vertex, ScriptoriumPoint passingByPoint, LineDirection diameterDirection, LineDirection tangentDirection, ScriptoriumPoint startPoint, ScriptoriumPoint endPoint) {
        ParabolaAction innerAction = new ParabolaAction();
        ComputeAction action = this.createAction(innerAction);
        innerAction.setVertex(vertex);
        innerAction.setPassingByPoint(passingByPoint);
        innerAction.setDiameterDirection(diameterDirection);
        innerAction.setTangentDirection(tangentDirection);
        innerAction.setStartPoint(startPoint);
        innerAction.setEndPoint(endPoint);
        this.appendAction(action);
    }

    public void addEclipseAction(ScriptoriumPoint vertex1, ScriptoriumPoint vertex2, ScriptoriumPoint center, ScriptoriumPoint passingBy, List<ScriptoriumPoint> fixedPoints) {
        EllipseAction innerAction = new EllipseAction();
        ComputeAction action = this.createAction(innerAction);
        innerAction.setVertex1(vertex1);
        innerAction.setVertex2(vertex2);
        innerAction.setCenter(center);
        innerAction.setPassingByPoint(passingBy);
        innerAction.setFixedPoints(fixedPoints);
        this.appendAction(action);
    }

    public void addHyperbolaAction(int numBranches, boolean asymptotes, ScriptoriumPoint vertex1, ScriptoriumPoint vertex2, ScriptoriumPoint center, ScriptoriumPoint passingBy, List<ScriptoriumPoint> fixedPoints, ScriptoriumPoint startPoint, ScriptoriumPoint endPoint) {
        HyperbolaAction innerAction = new HyperbolaAction();
        ComputeAction action = this.createAction(innerAction);
        innerAction.setNumBranches(numBranches);
        innerAction.setAsymptotes(asymptotes);
        innerAction.setVertex1(vertex1);
        innerAction.setVertex2(vertex2);
        innerAction.setCenter(center);
        innerAction.setPassingByPoint(passingBy);
        innerAction.setFixedPoints(fixedPoints);
        innerAction.setStartPoint(startPoint);
        innerAction.setEndPoint(endPoint);
        this.appendAction(action);
    }

    public void addPointsLine(Map<ScriptoriumPoint, ComputeAction> pointsAction, List<ScriptoriumPoint> fixedPoints, DraftProjection projection) {
        NDraftDrawingDirector drawingDirector = this.getDrawingDirector();
        StraightLineAction innerAction = new StraightLineAction();
        ComputeAction action = this.createAction(innerAction);
        List<ActionPoint> actionPoints = NDraftDrawingFrame.buildActionPoints(pointsAction, projection, (EditionListener)drawingDirector);
        innerAction.setActionPoints(actionPoints);
        innerAction.setFixedPoints(fixedPoints);
        this.appendAction(action);
    }

    public void addDirectionLine(Map<ScriptoriumPoint, ComputeAction> pointsAction, ScriptoriumPoint fixedPoint, LineDirection lineDirection, DraftProjection defaultProjection) {
        NDraftDrawingDirector drawingDirector = this.getDrawingDirector();
        StraightLineDirectionAction innerAction = new StraightLineDirectionAction();
        ComputeAction action = this.createAction(innerAction);
        innerAction.setLineDirection(lineDirection);
        innerAction.setFixedPoint(fixedPoint);
        List<ActionPoint> actionPoints = NDraftDrawingFrame.buildActionPoints(pointsAction, defaultProjection, (EditionListener)drawingDirector);
        innerAction.setActionPoints(actionPoints);
        this.appendAction(action);
    }

    public void addSnapAction(List<ScriptoriumPoint> points, ComputeAction action) {
        SnapAction innerAction = new SnapAction();
        ComputeAction computeAction = this.createAction(innerAction);
        innerAction.setTarget(action);
        List<PointReference> references = ShapeAdapter.getReferences(points);
        innerAction.setPoints(references);
        this.appendAction(computeAction);
    }

    public void addTangentAction(ScriptoriumPoint fixedPoint, List<ScriptoriumPoint> points, ComputeAction selectedCurve, ScriptoriumPoint startPoint, ScriptoriumPoint endPoint) {
        NDraftDrawingDirector drawingDirector = this.getDrawingDirector();
        DraftProjection projection = DraftProjection.getValue("ORTHOGONAL");
        KeyExtractor<ActionPoint, ScriptoriumPoint> extractor = point -> point.equals(fixedPoint) ? null : new ActionPoint((ScriptoriumPoint)point, projection, drawingDirector);
        List<ActionPoint> movingPoints = StructuresHelper.buildList(points, extractor);
        TangentAction innerAction = new TangentAction();
        ComputeAction computeAction = this.createAction(innerAction);
        innerAction.setFixedPoint(fixedPoint);
        innerAction.setCurve(selectedCurve);
        innerAction.setActionPoints(movingPoints);
        innerAction.setStartPoint(startPoint);
        innerAction.setEndPoint(endPoint);
        this.appendAction(computeAction);
    }

    private void appendAction(ComputeAction action) {
        NDraftDrawingDirector drawingDirector = this.getDrawingDirector();
        drawingDirector.appendAction(action);
        drawingDirector.applyActions();
        Iterable<ComputeAction> actions = drawingDirector.getComputeActions();
        UndoAddComputeAction undoAction = new UndoAddComputeAction(drawingDirector, action, actions);
        drawingDirector.editionChanged(undoAction);
    }

    private void addManyPointsLine(List<ScriptoriumPoint> points) {
        NDraftDrawingDirector drawingDirector = this.getDrawingDirector();
        Iterable<ComputeAction> actions = drawingDirector.getComputeActions();
        GenericSelectionModel<ScriptoriumPoint> drawingPoints = drawingDirector.getPointsModel();
        PointsLineDialog dialog = new PointsLineDialog(this, points, actions, drawingPoints);
        dialog.setVisible(true);
    }

    private static List<ActionPoint> buildActionPoints(ScriptoriumPoint point, DraftProjection projection, EditionListener listener) {
        ArrayList<ActionPoint> actionPoints = new ArrayList<ActionPoint>();
        actionPoints.add(new ActionPoint(point, projection, listener));
        return actionPoints;
    }

    private static List<ActionPoint> buildActionPoints(Map<ScriptoriumPoint, ComputeAction> pointsAction, DraftProjection defaultProjection, EditionListener listener) {
        ArrayList<ActionPoint> actionPoints = new ArrayList<ActionPoint>();
        for (Map.Entry<ScriptoriumPoint, ComputeAction> entry : pointsAction.entrySet()) {
            ScriptoriumPoint point = entry.getKey();
            ComputeAction action = entry.getValue();
            DraftProjection projection = NDraftDrawingFrame.getProjection(action, defaultProjection);
            ActionPoint actionPoint = new ActionPoint(point, projection, listener);
            actionPoints.add(actionPoint);
        }
        return actionPoints;
    }

    private static DraftProjection getProjection(ComputeAction action, DraftProjection defaultProjection) {
        return action == null ? defaultProjection : new DraftProjection(action);
    }

    private static int choosePoint(List<ScriptoriumPoint> points, String description, String label) {
        Object[] options = NDraftDrawingFrame.buildOptions(points);
        int option = JOptionPane.showOptionDialog(null, description, label, 0, 3, null, options, null);
        return option;
    }

    private static DraftProjection chooseProjection() {
        ArrayList<DraftProjection> projections = new ArrayList<DraftProjection>(DraftProjection.values());
        Object[] options = NDraftDrawingFrame.buildOptions(projections);
        int option = JOptionPane.showOptionDialog(null, "choose a projection type", "projection type", 0, 3, null, options, null);
        return option >= 0 && option < projections.size() ? (DraftProjection)projections.get(option) : null;
    }

    private static String[] buildOptions(Collection<?> values) {
        String[] options = new String[values.size()];
        int index = 0;
        for (Object value : values) {
            options[index] = value.toString();
            ++index;
        }
        return options;
    }

    private ComputeAction createAction(AbstractAction<?> innerAction) {
        NDraftDrawingDirector drawingDirector = this.getDrawingDirector();
        int key = NDraftDrawingFrame.getNextActionId(drawingDirector);
        Drawing drawing = drawingDirector.getDrawing();
        ComputeAction action = new ComputeAction(drawing, key);
        action.createChild(innerAction);
        return action;
    }

    private static int getNextActionId(NDraftDrawingDirector drawingDirector) {
        Iterable<ComputeAction> actions = drawingDirector.getComputeActions();
        int key = 0;
        for (ComputeAction action : actions) {
            key = Math.max(key, action.getKey());
        }
        return ++key;
    }
}

