/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ndraft;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.io.File;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import org.homelinux.elabor.scriptorium.ecomponents.Edition;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.Drawing;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.styles.ScriptoriumStyle;
import org.homelinux.elabor.scriptorium.gui.Preferences;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumDirector;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumPanel;
import org.homelinux.elabor.scriptorium.gui.drawings.AttributesFrame;
import org.homelinux.elabor.scriptorium.gui.drawings.BackgroundTransformFrame;
import org.homelinux.elabor.scriptorium.gui.drawings.DrawingArea;
import org.homelinux.elabor.scriptorium.gui.drawings.ExportableAreaFrame;
import org.homelinux.elabor.scriptorium.gui.drawings.GridFrame;
import org.homelinux.elabor.scriptorium.gui.drawings.groups.GroupsArea;
import org.homelinux.elabor.scriptorium.gui.drawings.points.PointPanel;
import org.homelinux.elabor.scriptorium.gui.drawings.points.PointsArea;
import org.homelinux.elabor.scriptorium.gui.drawings.shapes.ActionsArea;
import org.homelinux.elabor.scriptorium.gui.drawings.shapes.ShapesArea;
import org.homelinux.elabor.scriptorium.gui.drawings.styles.StylesManager;
import org.homelinux.elabor.scriptorium.gui.drawings.styles.StylesPanel;
import org.homelinux.elabor.scriptorium.gui.drawings.transformations.DrawingInversionFrame;
import org.homelinux.elabor.scriptorium.gui.drawings.transformations.DrawingMagnificationFrame;
import org.homelinux.elabor.scriptorium.gui.drawings.transformations.DrawingRotationFrame;
import org.homelinux.elabor.scriptorium.gui.drawings.transformations.DrawingTranslationFrame;
import org.homelinux.elabor.scriptorium.ndraft.NDraftDrawingAreaMouseListener;
import org.homelinux.elabor.scriptorium.ndraft.NDraftDrawingDirector;
import org.homelinux.elabor.scriptorium.ndraft.NDraftDrawingPalette;
import org.homelinux.elabor.scriptorium.services.EditionManager;
import org.homelinux.elabor.scriptorium.utils.Version;
import org.homelinux.elabor.tools.MessageCatalog;
import org.homelinux.elabor.ui.GenericSelectionModel;
import org.homelinux.elabor.ui.UITools;
import org.homelinux.elabor.ui.window.DefaultFrame;

public class NDraftDrawingPanel
extends ScriptoriumPanel<Drawing> {
    static final long serialVersionUID = 1L;
    private NDraftDrawingDirector director;
    private DrawingArea drawingArea;
    private PointsArea pointsArea;
    private ShapesArea shapesArea;
    private ActionsArea actionsArea;
    private NDraftDrawingPalette palette;
    private String pointsAreaTitle;
    private String pointsPanelTitle;
    private String shapesAreaTitle;
    private String actionsAreaTitle;
    private String releaseString;
    private AttributesFrame attributesFrame;
    private ExportableAreaFrame exportableAreaFrame;
    private DrawingTranslationFrame drawingTranslationFrame;
    private DrawingMagnificationFrame drawingMagnificationFrame;
    private DrawingRotationFrame drawingRotationFrame;
    private DrawingInversionFrame drawingInversionFrame;
    private GridFrame gridFrame;
    private BackgroundTransformFrame bgImageTransformFrame;
    private DefaultFrame<StylesPanel, StylesManager> stylesFrame;
    private PointPanel pointPanel;
    private final EditionManager editionManager;

    public NDraftDrawingPanel() {
        this.initLocale();
        Preferences preferences = Preferences.getInstance();
        int pointSelectionDistance = preferences.getInteger("point_selection_distance");
        this.director = new NDraftDrawingDirector(pointSelectionDistance);
        this.palette = new NDraftDrawingPalette();
        NDraftDrawingAreaMouseListener mouseListener = new NDraftDrawingAreaMouseListener();
        this.drawingArea = new DrawingArea(mouseListener, true, false);
        mouseListener.setDrawingArea(this.drawingArea);
        JScrollPane scroll_pane = new JScrollPane(this.drawingArea);
        this.pointsArea = new PointsArea(false, false, false);
        LineBorder lineBorder = new LineBorder(Color.black);
        TitledBorder titledBorder = new TitledBorder(lineBorder, this.pointsAreaTitle);
        this.pointsArea.setBorder(titledBorder);
        this.pointsArea.setMaximumSize(new Dimension(260, 0));
        this.pointsArea.setMinimumSize(new Dimension(260, 0));
        this.pointsArea.setPreferredSize(new Dimension(260, 0));
        this.pointPanel = new PointPanel(null);
        TitledBorder pointTitledBorder = new TitledBorder(lineBorder, this.pointsPanelTitle);
        this.pointPanel.setBorder(pointTitledBorder);
        this.shapesArea = new ShapesArea(false, false, false);
        TitledBorder shapeTitledBorder = new TitledBorder(lineBorder, this.shapesAreaTitle);
        this.shapesArea.setBorder(shapeTitledBorder);
        this.shapesArea.setMaximumSize(new Dimension(0, 150));
        this.shapesArea.setMinimumSize(new Dimension(0, 150));
        this.shapesArea.setPreferredSize(new Dimension(0, 150));
        this.actionsArea = new ActionsArea();
        TitledBorder actionTitledBorder = new TitledBorder(lineBorder, this.actionsAreaTitle);
        this.actionsArea.setBorder(actionTitledBorder);
        this.actionsArea.setMaximumSize(new Dimension(0, 150));
        this.actionsArea.setMinimumSize(new Dimension(0, 150));
        this.actionsArea.setPreferredSize(new Dimension(0, 150));
        this.setLayout(new GridBagLayout());
        UITools.addComponent(this, this.palette, 0, 0, 3, 1, 100, 0, 2, 2);
        UITools.addComponent(this, scroll_pane, 0, 1, 2, 2, 100, 100, 1, 2);
        UITools.addComponent(this, this.pointsArea, 2, 1, 1, 3, 0, 100, 1, 2);
        UITools.addComponent(this, this.pointPanel, 2, 4, 1, 1, 0, 0, 1, 2);
        UITools.addComponent(this, this.shapesArea, 0, 3, 2, 1, 100, 0, 1, 2);
        UITools.addComponent(this, this.actionsArea, 0, 4, 2, 1, 100, 0, 1, 2);
        this.setBorder(lineBorder);
        this.editionManager = EditionManager.getInstance();
    }

    private void initLocale() {
        MessageCatalog catalog = new MessageCatalog();
        String locale = Preferences.getInstance().getProperty("locale");
        catalog.loadCatalog(this.getClass().getName(), locale);
        this.pointsAreaTitle = catalog.translate("pointsAreaTitle");
        this.pointsPanelTitle = catalog.translate("pointsPanelTitle");
        this.shapesAreaTitle = catalog.translate("shapesAreaTitle");
        this.actionsAreaTitle = catalog.translate("actionsAreaTitle");
        this.releaseString = catalog.translate("releaseLabel");
    }

    @Override
    public void setup(ScriptoriumDirector scriptoriumDirector, Drawing drawing) {
        super.setup(scriptoriumDirector, drawing);
        GroupsArea groupsArea = new GroupsArea();
        this.director.setup(drawing, this.pointsArea, this.shapesArea, this.actionsArea, groupsArea, this.drawingArea, this.palette);
        this.palette.setup(this.director);
        this.drawingArea.setup(this.director);
        this.pointsArea.setup(this.director);
        this.pointPanel.setup(this.director, null);
        this.shapesArea.setup(this.director);
        this.actionsArea.setup(this.director);
    }

    public NDraftDrawingDirector getDrawingDirector() {
        return this.director;
    }

    public void setGrid() {
        if (this.gridFrame == null) {
            this.gridFrame = new GridFrame();
        }
        this.gridFrame.setup(this.director);
    }

    public void openAttributesForm() {
        if (this.attributesFrame == null) {
            this.attributesFrame = new AttributesFrame();
        }
        this.attributesFrame.setup(this.director);
    }

    public void openExportableAreaForm() {
        if (this.exportableAreaFrame == null) {
            this.exportableAreaFrame = new ExportableAreaFrame();
        }
        this.exportableAreaFrame.setup(this.director);
    }

    public void openDrawingTranslationForm() {
        if (this.drawingTranslationFrame == null) {
            this.drawingTranslationFrame = new DrawingTranslationFrame();
        }
        this.drawingTranslationFrame.setup(this.director);
    }

    public void openDrawingMagnificationForm() {
        if (this.drawingMagnificationFrame == null) {
            this.drawingMagnificationFrame = new DrawingMagnificationFrame();
        }
        this.drawingMagnificationFrame.setup(this.director);
    }

    public void openDrawingRotationForm() {
        if (this.drawingRotationFrame == null) {
            this.drawingRotationFrame = new DrawingRotationFrame();
        }
        this.drawingRotationFrame.setup(this.director);
    }

    public void openDrawingInversionForm() {
        if (this.drawingInversionFrame == null) {
            this.drawingInversionFrame = new DrawingInversionFrame();
        }
        this.drawingInversionFrame.setup(this.director);
    }

    public void openBackgroundImageTransformForm() {
        if (this.bgImageTransformFrame == null) {
            this.bgImageTransformFrame = new BackgroundTransformFrame();
        }
        this.bgImageTransformFrame.setup(this.director);
    }

    public void setShowInvisibles(boolean showInvisibles) {
        this.drawingArea.setShowInvisibles(showInvisibles);
    }

    public void setShowBackground(boolean showBgImage) {
        this.drawingArea.setShowBackground(showBgImage);
    }

    public void setShowDrawing(boolean showDrawing) {
        this.drawingArea.setShowDrawing(showDrawing);
    }

    public void setShowLabels(boolean showLabels) {
        this.drawingArea.setShowLabels(showLabels);
    }

    public void setShowPointRectangles(boolean showRectangles) {
        this.drawingArea.setShowPointRectangles(showRectangles);
    }

    public void setShading(boolean shading) {
        this.drawingArea.setShading(shading);
    }

    public void setShowGrid(boolean showGrid) {
        this.drawingArea.setShowGrid(showGrid);
    }

    public void setMagnetic(boolean magnetic) {
        this.drawingArea.setMagnetic(magnetic);
    }

    public void loadBackgroundImage() {
        File imageFile = this.editionManager.chooseImageFile();
        if (imageFile != null) {
            this.director.setBackgroundImage(imageFile);
            this.validate();
        }
    }

    public void unloadBackgroundImage() {
        this.director.removeBackgroundImage();
        this.validate();
    }

    public void loadStyleset() {
        Drawing drawing = this.director.getDrawing();
        Edition edition = drawing.getEdition();
        this.director.loadStyleset(edition);
        this.validate();
    }

    @Override
    public boolean closing() {
        this.pointsArea.closing();
        this.shapesArea.closing();
        this.pointPanel.closing();
        if (this.stylesFrame != null) {
            this.stylesFrame.dispose();
        }
        if (this.drawingTranslationFrame != null) {
            this.drawingTranslationFrame.dispose();
        }
        if (this.drawingMagnificationFrame != null) {
            this.drawingMagnificationFrame.dispose();
        }
        if (this.drawingRotationFrame != null) {
            this.drawingRotationFrame.dispose();
        }
        if (this.bgImageTransformFrame != null) {
            this.bgImageTransformFrame.dispose();
        }
        if (this.exportableAreaFrame != null) {
            this.exportableAreaFrame.dispose();
        }
        return super.closing();
    }

    public void openStylesFrame() {
        if (this.stylesFrame == null) {
            StylesPanel stylesPanel = new StylesPanel();
            this.stylesFrame = new DefaultFrame(stylesPanel);
            this.stylesFrame.setSize(300, 400);
            this.stylesFrame.setDefaultCloseOperation(2);
        }
        GenericSelectionModel<ScriptoriumStyle> styles = this.director.getStylesModel();
        StylesManager manager = new StylesManager(this.director);
        manager.setModel(styles);
        this.stylesFrame.setup(manager);
    }

    public void showReleaseFrame() {
        Version version = Version.getInstance();
        String releaseNumber = version.getReleaseNumber();
        String releaseDate = version.getReleaseDate();
        String message = String.valueOf(this.releaseString) + releaseNumber + " (" + releaseDate + ")";
        JOptionPane.showMessageDialog(null, message, "Scriptorium", 1);
    }
}

