/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ndraft.actions;

import java.awt.geom.Point2D;
import java.util.List;
import org.homelinux.elabor.scriptorium.ecomponents.EditionComponent;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.ScriptoriumPoint;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.ShapeAdapter;
import org.homelinux.elabor.scriptorium.gui.drawings.GeometricHelper;
import org.homelinux.elabor.scriptorium.ndraft.actions.AbstractAction;
import org.homelinux.elabor.scriptorium.ndraft.actions.ComputeAction;
import org.homelinux.elabor.scriptorium.ndraft.actions.DraftVector;
import org.w3c.dom.Element;

public abstract class AbstractConicAction<T extends EditionComponent<T>>
extends AbstractAction<T> {
    private static final String VERTEX1 = "vertex1";
    private static final String VERTEX2 = "vertex2";
    private static final String CENTER = "center";
    private static final String PASSING_BY_POINT = "passing_by_point";

    public AbstractConicAction() {
    }

    public AbstractConicAction(Element element) {
        super(element);
    }

    public void setVertex1(ScriptoriumPoint point) {
        this.setIntAttribute(VERTEX1, point.getId());
    }

    public void setVertex2(ScriptoriumPoint point) {
        if (point != null) {
            this.setIntAttribute(VERTEX2, point.getId());
        }
    }

    public void setCenter(ScriptoriumPoint point) {
        if (point != null) {
            this.setIntAttribute(CENTER, point.getId());
        }
    }

    public void setPassingByPoint(ScriptoriumPoint point) {
        this.setIntAttribute(PASSING_BY_POINT, point.getId());
    }

    public int getVertex1() {
        return this.getIntAttribute(VERTEX1);
    }

    public int getVertex2() {
        return this.getIntAttribute(VERTEX2);
    }

    public int getCenter() {
        return this.getIntAttribute(CENTER);
    }

    public int getPassingBy() {
        return this.getIntAttribute(PASSING_BY_POINT);
    }

    @Override
    protected void execute(Iterable<ScriptoriumPoint> drawingPoints, Iterable<ComputeAction> actions) {
        List<ScriptoriumPoint> fixedPoints = this.getFixedPoints(drawingPoints);
        if (!fixedPoints.isEmpty()) {
            ScriptoriumPoint center = this.getCenterPoint(drawingPoints);
            ScriptoriumPoint vertex1 = this.getVertex1Point(drawingPoints);
            ScriptoriumPoint vertex2 = this.getVertex2Point(drawingPoints);
            Point2D center2D = center.getPoint2D();
            Point2D vertex12D = vertex1.getPoint2D();
            Point2D vertex22D = vertex2.getPoint2D();
            if (fixedPoints.size() == 1) {
                DraftVector axis = AbstractConicAction.getAxis(center2D, vertex12D, vertex22D);
                double semiAxis = vertex12D.distance(vertex22D) / 2.0;
                vertex12D = GeometricHelper.shift(axis, -semiAxis);
                vertex1.setSnap(vertex12D);
                vertex22D = GeometricHelper.shift(axis, semiAxis);
                vertex2.setSnap(vertex22D);
            } else if (!fixedPoints.contains(center)) {
                center2D = GeometricHelper.middlePoint(vertex12D, vertex22D);
                center.setSnap(center2D);
            } else if (!fixedPoints.contains(vertex1)) {
                vertex12D = GeometricHelper.symmetric(vertex22D, center2D);
                vertex1.setSnap(vertex12D);
            } else {
                vertex22D = GeometricHelper.symmetric(vertex12D, center2D);
                vertex2.setSnap(vertex22D);
            }
        }
    }

    private static DraftVector getAxis(Point2D center2D, Point2D vertex12D, Point2D vertex22D) {
        double dx = vertex22D.getX() - vertex12D.getX();
        double dy = vertex22D.getY() - vertex12D.getY();
        return new DraftVector(center2D, dx, dy);
    }

    public ScriptoriumPoint getCenterPoint(Iterable<ScriptoriumPoint> drawingPoints) {
        return ShapeAdapter.getReferredItem(this.getCenter(), drawingPoints);
    }

    public ScriptoriumPoint getVertex1Point(Iterable<ScriptoriumPoint> drawingPoints) {
        return ShapeAdapter.getReferredItem(this.getVertex1(), drawingPoints);
    }

    public ScriptoriumPoint getVertex2Point(Iterable<ScriptoriumPoint> drawingPoints) {
        return ShapeAdapter.getReferredItem(this.getVertex2(), drawingPoints);
    }

    public ScriptoriumPoint getPassingByPoint(Iterable<ScriptoriumPoint> drawingPoints) {
        return ShapeAdapter.getReferredItem(this.getPassingBy(), drawingPoints);
    }

    @Override
    protected void project(DraftVector vector, ScriptoriumPoint point, Iterable<ScriptoriumPoint> drawingPoints, Iterable<ComputeAction> drawingActions) {
    }

    @Override
    protected boolean isTarget() {
        return true;
    }

    @Override
    public boolean isConicBy(ScriptoriumPoint point) {
        int passingBy = this.getPassingBy();
        int vertex1 = this.getVertex1();
        int vertex2 = this.getVertex2();
        int id = point.getId();
        return id == passingBy || id == vertex1 || id == vertex2;
    }

    @Override
    public boolean isConic() {
        return true;
    }
}

