/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ndraft.actions;

import java.awt.geom.Point2D;
import java.util.Iterator;
import java.util.List;
import org.homelinux.elabor.exceptions.InvalidValueException;
import org.homelinux.elabor.scriptorium.ndraft.actions.ComputeAction;

public class ActionHelper {
    private ActionHelper() {
    }

    public static Point2D getDirectionVector(List<Point2D> points) throws InvalidValueException {
        Point2D last;
        Point2D first = points.get(0);
        double length = first.distance(last = points.get(1));
        if (length < 1.0E-5) {
            throw new InvalidValueException("the two points are too closed");
        }
        double dy = (last.getY() - first.getY()) / length;
        double dx = (last.getX() - first.getX()) / length;
        return new Point2D.Double(dx, dy);
    }

    public static ComputeAction getAction(Integer id, Iterable<ComputeAction> actions) {
        ComputeAction action = null;
        Iterator<ComputeAction> iterator = actions.iterator();
        while (action == null && iterator.hasNext()) {
            ComputeAction current = iterator.next();
            if (!current.getKey().equals(id)) continue;
            action = current;
        }
        return action;
    }
}

