/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ndraft.actions;

import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.ScriptoriumPoint;
import org.homelinux.elabor.scriptorium.ndraft.actions.ComputeAction;
import org.homelinux.elabor.scriptorium.ndraft.actions.DraftProjectionManager;
import org.homelinux.elabor.scriptorium.ndraft.actions.DraftVector;
import org.homelinux.elabor.tools.MathUtils;

class OrthogonalManager
implements DraftProjectionManager {
    OrthogonalManager() {
    }

    @Override
    public void execute(DraftVector vector, ScriptoriumPoint point, Iterable<ScriptoriumPoint> drawingPoints, Iterable<ComputeAction> drawingActions) {
        double x = vector.getX();
        double y = vector.getY();
        double dx = vector.getDx();
        double dy = vector.getDy();
        double dx2 = dx * dx;
        double dy2 = dy * dy;
        double dxy = dx * dy;
        double norm = dx2 + dy2;
        double xx = dx2 / norm;
        double yy = dy2 / norm;
        double xy = dxy / norm;
        double xp = point.getX() - x;
        double yp = point.getY() - y;
        double xt = MathUtils.round(xx * xp + xy * yp + x, 3);
        double yt = MathUtils.round(xy * xp + yy * yp + y, 3);
        point.setSnap(xt, yt);
    }

    public String toString() {
        return "ORTHOGONAL".toLowerCase();
    }
}

