/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ndraft.actions;

import java.awt.Shape;
import java.awt.geom.Point2D;
import org.homelinux.elabor.exceptions.InvalidValueException;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.PointReference;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.ScriptoriumPoint;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.ShapeAdapter;
import org.homelinux.elabor.scriptorium.ecomponents.visitors.EditionVisitor;
import org.homelinux.elabor.scriptorium.gui.drawings.GeometricHelper;
import org.homelinux.elabor.scriptorium.ndraft.DiameterDirectionHandler;
import org.homelinux.elabor.scriptorium.ndraft.LineDirection;
import org.homelinux.elabor.scriptorium.ndraft.TangentDirectionHandler;
import org.homelinux.elabor.scriptorium.ndraft.actions.AbstractAction;
import org.homelinux.elabor.scriptorium.ndraft.actions.ComputeAction;
import org.homelinux.elabor.scriptorium.ndraft.actions.DraftVector;
import org.homelinux.elabor.scriptorium.ndraft.actions.ParabolaEquation;
import org.w3c.dom.Element;

public final class ParabolaAction
extends AbstractAction<ParabolaAction> {
    private static final String VERTEX = "vertex";
    private static final String PASSING_BY_POINT = "passing_by_point";
    private static final String DIAMETER_DX = "diam_dx";
    private static final String DIAMETER_DY = "diam_dy";
    private static final String TANGENT_DX = "tang_dx";
    private static final String TANGENT_DY = "tang_dy";
    private static final String TANGENT_FIRST_POINT = "tang_first_point";
    private static final String TANGENT_SECOND_POINT = "tang_second_point";
    private static final String START_POINT = "start_point";
    private static final String END_POINT = "end_point";

    public ParabolaAction() {
    }

    public ParabolaAction(Element element) {
        super(element);
    }

    @Override
    public String getElementName() {
        return "parabola";
    }

    @Override
    protected ParabolaAction make(Element element) {
        return new ParabolaAction(element);
    }

    public void setVertex(ScriptoriumPoint point) {
        this.setIntAttribute(VERTEX, point.getId());
    }

    public void setPassingByPoint(ScriptoriumPoint point) {
        this.setIntAttribute(PASSING_BY_POINT, point.getId());
    }

    public void setStartPoint(ScriptoriumPoint point) {
        this.setIntAttribute(START_POINT, point.getId());
    }

    public void setEndPoint(ScriptoriumPoint point) {
        this.setIntAttribute(END_POINT, point.getId());
    }

    public void setTangentFirstPoint(PointReference point) {
        this.setIntAttribute(TANGENT_FIRST_POINT, point.getId());
    }

    public void setTangentSecondPoint(PointReference point) {
        this.setIntAttribute(TANGENT_SECOND_POINT, point.getId());
    }

    public void setDiameterDirection(LineDirection lineDirection) {
        lineDirection.setDirectionAttributes(new DiameterDirectionHandler(this));
    }

    public void setDiameterDirectionAttributes(Point2D directionVector) {
        float dx = (float)directionVector.getX();
        float dy = (float)directionVector.getY();
        this.setDiameterDirectionAttributes(dx, dy);
    }

    private void setDiameterDirectionAttributes(float dx, float dy) {
        this.setFloatAttribute(DIAMETER_DX, dx);
        this.setFloatAttribute(DIAMETER_DY, dy);
    }

    public void setTangentDirection(LineDirection lineDirection) {
        lineDirection.setDirectionAttributes(new TangentDirectionHandler(this));
    }

    public void setTangentDirectionAttributes(Point2D directionVector) {
        float dx = (float)directionVector.getX();
        float dy = (float)directionVector.getY();
        this.setTangentDirectionAttributes(dx, dy);
    }

    private void setTangentDirectionAttributes(float dx, float dy) {
        this.setFloatAttribute(TANGENT_DX, dx);
        this.setFloatAttribute(TANGENT_DY, dy);
    }

    public void setTangentParallelDirectionAttributes(PointReference firstPoint, PointReference secondPoint) {
        this.setTangentFirstPoint(firstPoint);
        this.setTangentSecondPoint(secondPoint);
    }

    public int getVertex() {
        return this.getIntAttribute(VERTEX);
    }

    public int getPassingByPoint() {
        return this.getIntAttribute(PASSING_BY_POINT);
    }

    public int getStartPoint() {
        return this.getIntAttribute(START_POINT);
    }

    public int getEndPoint() {
        return this.getIntAttribute(END_POINT);
    }

    public double getDiameterDx() {
        return this.getDoubleAttribute(DIAMETER_DX);
    }

    public double getDiameterDy() {
        return this.getDoubleAttribute(DIAMETER_DY);
    }

    public double getTangentDx() {
        return this.getDoubleAttribute(TANGENT_DX);
    }

    public double getTangentDy() {
        return this.getDoubleAttribute(TANGENT_DY);
    }

    public int getTangentFirstPoint() {
        return this.getIntAttribute(TANGENT_FIRST_POINT);
    }

    public int getTangentSecondPoint() {
        return this.getIntAttribute(TANGENT_SECOND_POINT);
    }

    @Override
    public String toString() {
        return "Parabola " + this.getStringAttribute(VERTEX) + " - " + this.getStringAttribute(PASSING_BY_POINT);
    }

    @Override
    public void accept(EditionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    protected void execute(Iterable<ScriptoriumPoint> drawingPoints, Iterable<ComputeAction> actions) {
    }

    @Override
    protected void project(DraftVector vector, ScriptoriumPoint point, Iterable<ScriptoriumPoint> drawingPoints, Iterable<ComputeAction> drawingActions) {
    }

    @Override
    protected void project(Iterable<ScriptoriumPoint> points, Iterable<ScriptoriumPoint> drawingPoints, Iterable<ComputeAction> drawingActions) throws InvalidValueException {
        double diameterDx = this.getDiameterDx();
        double diameterDy = this.getDiameterDy();
        ScriptoriumPoint vertex = this.getVertexPoint(drawingPoints);
        Point2D pointA = vertex.getPoint2D();
        DraftVector diamVector = new DraftVector(pointA, diameterDx, diameterDy);
        ScriptoriumPoint passingByPoint = this.getPassingByPoint(drawingPoints);
        DraftVector ordVector = this.getOrdVector(passingByPoint, drawingPoints);
        double ordDx = ordVector.getDx();
        double ordDy = ordVector.getDy();
        Point2D pointC = GeometricHelper.intersection(diamVector, ordVector);
        Point2D pointB = passingByPoint.getPoint2D();
        double dAC = pointA.distance(pointC);
        double p = Math.pow(pointB.distance(pointC), 2.0) / dAC;
        for (ScriptoriumPoint point : points) {
            Point2D point2D = point.getPoint2D();
            Point2D parabolaPoint = ParabolaEquation.getParabolaPoint(diamVector, ordDx, ordDy, p, point2D);
            point.setSnap(parabolaPoint);
        }
    }

    public ScriptoriumPoint getVertexPoint(Iterable<ScriptoriumPoint> drawingPoints) {
        int vertexRef = this.getVertex();
        return ShapeAdapter.getReferredItem(vertexRef, drawingPoints);
    }

    @Override
    protected Shape computeShape(Iterable<ScriptoriumPoint> drawingPoints, Iterable<ComputeAction> drawingActions) {
        ParabolaEquation equation = new ParabolaEquation(this, drawingPoints);
        return equation.getShape();
    }

    public ScriptoriumPoint getPassingByPoint(Iterable<ScriptoriumPoint> drawingPoints) {
        int passingByPointRef = this.getPassingByPoint();
        return ShapeAdapter.getReferredItem(passingByPointRef, drawingPoints);
    }

    public DraftVector getOrdVector(ScriptoriumPoint passingByPoint, Iterable<ScriptoriumPoint> drawingPoints) {
        double ordDx = this.getTangentDx();
        double ordDy = this.getTangentDy();
        int ordFirstPointId = this.getTangentFirstPoint();
        int ordSecondPointId = this.getTangentSecondPoint();
        return GeometricHelper.getVector(passingByPoint, ordDx, ordDy, ordFirstPointId, ordSecondPointId, drawingPoints);
    }

    @Override
    protected boolean isTarget() {
        return true;
    }

    @Override
    public boolean isConicBy(ScriptoriumPoint point) {
        int vertex = this.getVertex();
        int passingBy = this.getPassingByPoint();
        int id = point.getId();
        return id == vertex || id == passingBy;
    }

    @Override
    protected DraftVector getTangent(ScriptoriumPoint point, Iterable<ScriptoriumPoint> drawingPoints) {
        ParabolaEquation equation = new ParabolaEquation(this, drawingPoints);
        return equation.tangent(point);
    }

    @Override
    public boolean isConic() {
        return true;
    }
}

