/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ndraft.actions;

import java.awt.Shape;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import org.homelinux.elabor.exceptions.InvalidValueException;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.ScriptoriumPoint;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.Equation;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.ShapeAdapter;
import org.homelinux.elabor.scriptorium.gui.drawings.GeometricHelper;
import org.homelinux.elabor.scriptorium.ndraft.actions.DraftVector;
import org.homelinux.elabor.scriptorium.ndraft.actions.ParabolaAction;

public class ParabolaEquation {
    private final Point2D startPoint;
    private final Point2D endPoint;
    private Point2D[] parabolaPoints;
    private Equation equation;
    private DraftVector diamVector;
    private double ordDx;
    private double ordDy;
    private double p;
    private Point2D pointA;
    private Point2D pointB;

    public ParabolaEquation(ParabolaAction parabolaAction, Iterable<ScriptoriumPoint> drawingPoints) {
        Point2D pointC;
        int startPointRef = parabolaAction.getStartPoint();
        int endPointRef = parabolaAction.getEndPoint();
        ScriptoriumPoint vertex = parabolaAction.getVertexPoint(drawingPoints);
        ScriptoriumPoint passingByPoint = parabolaAction.getPassingByPoint(drawingPoints);
        this.startPoint = ShapeAdapter.getReferredItem(startPointRef, drawingPoints).getPoint2D();
        this.endPoint = ShapeAdapter.getReferredItem(endPointRef, drawingPoints).getPoint2D();
        this.pointA = vertex.getPoint2D();
        this.pointB = passingByPoint.getPoint2D();
        double diameterDx = parabolaAction.getDiameterDx();
        double diameterDy = parabolaAction.getDiameterDy();
        this.diamVector = new DraftVector(this.pointA, diameterDx, diameterDy);
        DraftVector ordVector = parabolaAction.getOrdVector(passingByPoint, drawingPoints);
        this.ordDx = ordVector.getDx();
        this.ordDy = ordVector.getDy();
        try {
            pointC = GeometricHelper.intersection(this.diamVector, ordVector);
        }
        catch (InvalidValueException exc) {
            throw new RuntimeException(exc);
        }
        Point2D pointD = GeometricHelper.symmetric(this.pointB, pointC);
        double dAC = this.pointA.distance(pointC);
        this.p = Math.pow(this.pointB.distance(pointC), 2.0) / dAC;
        Point2D pointE = GeometricHelper.shift(this.diamVector, dAC * 100.0);
        double distance = Math.sqrt(this.p * this.pointA.distance(pointE)) * 0.9;
        Point2D pointF = GeometricHelper.shift(pointE, this.ordDx, this.ordDy, distance);
        Point2D pointG = GeometricHelper.shift(pointE, -this.ordDx, -this.ordDy, distance);
        this.parabolaPoints = new Point2D[]{pointD, this.pointA, this.pointB, pointF, pointG};
        this.equation = GeometricHelper.computeApproxEquation(this.parabolaPoints);
    }

    public Shape getShape() {
        Shape shape;
        try {
            shape = this.buildParabola();
        }
        catch (NoninvertibleTransformException | InvalidValueException exc) {
            shape = GeometricHelper.buildLine(new Point2D[]{this.pointA, this.pointB});
        }
        return shape;
    }

    private Shape buildParabola() throws NoninvertibleTransformException, InvalidValueException {
        double xc = this.equation.getXc();
        Point2D limit1 = ParabolaEquation.getParabolaPoint(this.diamVector, this.ordDx, this.ordDy, this.p, this.startPoint);
        Point2D limit2 = ParabolaEquation.getParabolaPoint(this.diamVector, this.ordDx, this.ordDy, this.p, this.endPoint);
        boolean clockWise = limit1.getX() < xc == limit1.getY() < limit2.getY();
        Point2D start = clockWise ? limit1 : limit2;
        Point2D end = clockWise ? limit2 : limit1;
        return GeometricHelper.buildConic(this.equation, true, start, end, this.parabolaPoints);
    }

    public static Point2D getParabolaPoint(DraftVector diamVector, double ordDx, double ordDy, double p, Point2D point) throws InvalidValueException {
        DraftVector pointVector = new DraftVector(point, ordDx, ordDy);
        Point2D diamPoint = GeometricHelper.intersection(diamVector, pointVector);
        double dx = point.getX() - diamPoint.getX();
        double dy = point.getY() - diamPoint.getY();
        if (dx == 0.0 && dy == 0.0) {
            dx = ordDx;
            dy = ordDy;
        }
        Point2D vertex = diamVector.getPoint();
        return ParabolaEquation.getParabolaPoint(vertex, diamPoint, dx, dy, p);
    }

    private static Point2D getParabolaPoint(Point2D vertex, Point2D diamPoint, double dx, double dy, double p) {
        double distPointVertex = vertex.distance(diamPoint);
        double distance = Math.sqrt(p * distPointVertex);
        return GeometricHelper.shift(diamPoint, dx, dy, distance);
    }

    public DraftVector tangent(ScriptoriumPoint point) {
        Point2D point2D = point.getPoint2D();
        return this.equation.tangent(point2D);
    }
}

