/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ndraft.actions;

import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import org.homelinux.elabor.exceptions.InvalidValueException;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.ScriptoriumPoint;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.ShapeAdapter;
import org.homelinux.elabor.scriptorium.ecomponents.visitors.EditionVisitor;
import org.homelinux.elabor.scriptorium.gui.drawings.GeometricHelper;
import org.homelinux.elabor.scriptorium.ndraft.actions.AbstractStraightLineAction;
import org.homelinux.elabor.scriptorium.ndraft.actions.ComputeAction;
import org.homelinux.elabor.scriptorium.ndraft.actions.DraftVector;
import org.w3c.dom.Element;

public final class TangentAction
extends AbstractStraightLineAction<TangentAction> {
    private static final String FIXED_POINT = "fixed_point";
    private static final String CURVE = "curve";
    private static final String START_POINT = "start_point";
    private static final String END_POINT = "end_point";

    public TangentAction() {
    }

    public TangentAction(Element element) {
        super(element);
    }

    @Override
    public String getElementName() {
        return "tangent";
    }

    @Override
    protected TangentAction make(Element element) {
        return new TangentAction(element);
    }

    public void setFixedPoint(ScriptoriumPoint fixedPoint) {
        this.setIntAttribute(FIXED_POINT, fixedPoint.getId());
    }

    public void setCurve(ComputeAction curve) {
        this.setIntAttribute(CURVE, curve.getId());
    }

    public void setStartPoint(ScriptoriumPoint startPoint) {
        this.setIntAttribute(START_POINT, startPoint.getId());
    }

    public void setEndPoint(ScriptoriumPoint endPoint) {
        this.setIntAttribute(END_POINT, endPoint.getId());
    }

    @Override
    protected DraftVector getVector(Iterable<ScriptoriumPoint> drawingPoints, Iterable<ComputeAction> drawingActions) throws InvalidValueException {
        ScriptoriumPoint point = this.getFixedPoint(drawingPoints);
        ComputeAction conicAction = this.getCurve(drawingActions);
        if (conicAction == null) {
            throw new InvalidValueException("the point does not belongs to a conic");
        }
        return conicAction.getTangent(point, drawingPoints);
    }

    public int getCurveReference() {
        return this.getIntAttribute(CURVE);
    }

    public ComputeAction getCurve(Iterable<ComputeAction> drawingActions) {
        int curveReference = this.getCurveReference();
        return ShapeAdapter.getReferredAction(curveReference, drawingActions);
    }

    @Override
    public Shape computeShape(Iterable<ScriptoriumPoint> drawingPoints, Iterable<ComputeAction> drawingActions) {
        DraftVector vector;
        GeneralPath line = new GeneralPath();
        ScriptoriumPoint startPoint = this.getStartPoint(drawingPoints);
        ScriptoriumPoint endPoint = this.getEndPoint(drawingPoints);
        try {
            vector = this.getVector(drawingPoints, drawingActions);
        }
        catch (InvalidValueException exc) {
            throw new RuntimeException(exc);
        }
        Point2D first = GeometricHelper.nearestPoint(vector, startPoint);
        Point2D last = GeometricHelper.nearestPoint(vector, endPoint);
        line.moveTo(first.getX(), first.getY());
        line.lineTo(last.getX(), last.getY());
        return line;
    }

    public int getFixedPointReference() {
        return this.getIntAttribute(FIXED_POINT);
    }

    public int getStartPointReference() {
        return this.getIntAttribute(START_POINT);
    }

    public int getEndPointReference() {
        return this.getIntAttribute(END_POINT);
    }

    public ScriptoriumPoint getFixedPoint(Iterable<ScriptoriumPoint> drawingPoints) {
        int pointReference = this.getFixedPointReference();
        return ShapeAdapter.getReferredItem(pointReference, drawingPoints);
    }

    public ScriptoriumPoint getStartPoint(Iterable<ScriptoriumPoint> drawingPoints) {
        int pointReference = this.getStartPointReference();
        return ShapeAdapter.getReferredItem(pointReference, drawingPoints);
    }

    public ScriptoriumPoint getEndPoint(Iterable<ScriptoriumPoint> drawingPoints) {
        int pointReference = this.getEndPointReference();
        return ShapeAdapter.getReferredItem(pointReference, drawingPoints);
    }

    @Override
    public String toString() {
        return "tangent " + this.getFixedPointReference();
    }

    @Override
    public void accept(EditionVisitor visitor) {
        visitor.visit(this);
    }
}

