/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.structures.listmap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.homelinux.elabor.structures.listmap.AbstractStore;

public class ListMapStore<K, V>
extends AbstractStore<K, V, List<V>> {
    public ListMapStore() {
        this(new LinkedHashMap());
    }

    public ListMapStore(Map<K, List<V>> map) {
        super(map);
    }

    @Override
    public void put(K key, Collection<V> values) {
        List<V> list = this.safeGet(key);
        list.addAll(values);
    }

    @Override
    public void put(K key, V value) {
        List<V> list = this.safeGet(key);
        list.add(value);
    }

    private List<V> safeGet(K key) {
        ArrayList list = (ArrayList)this.get(key);
        if (list == null) {
            list = new ArrayList();
            this.insert(key, list);
        }
        return list;
    }
}

