/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.structures.setmap;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.homelinux.elabor.structures.listmap.AbstractStore;

public class SetMapStore<K, V>
extends AbstractStore<K, V, Set<V>> {
    public SetMapStore() {
        this(new LinkedHashMap());
    }

    public SetMapStore(Map<K, Set<V>> set) {
        super(set);
    }

    @Override
    public void put(K key, Collection<V> values) {
        Set<V> list = this.safeGet(key);
        list.addAll(values);
    }

    @Override
    public void put(K key, V value) {
        Set<V> set = this.safeGet(key);
        set.add(value);
    }

    private Set<V> safeGet(K key) {
        TreeSet list = (TreeSet)this.get(key);
        if (list == null) {
            list = new TreeSet();
            this.insert(key, list);
        }
        return list;
    }
}

