/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.border.LineBorder;
import org.homelinux.elabor.tools.InvalidPathException;
import org.homelinux.elabor.ui.UITools;

public abstract class DefaultToolBar<T extends JButton>
extends JToolBar {
    private static final long serialVersionUID = 1L;
    private LineBorder selectBorder;
    private LineBorder unselectBorder;
    private ArrayList<T> buttons;

    public DefaultToolBar() {
        super(0);
        this.setFloatable(false);
        this.selectBorder = new LineBorder(Color.BLACK);
        this.unselectBorder = new LineBorder(Color.LIGHT_GRAY);
        this.buttons = new ArrayList();
    }

    public void add(T button) {
        this.buttons.add(button);
        super.add((Component)button);
    }

    public List<T> getButtons() {
        return this.buttons;
    }

    public T createButton(String selectedIconName, String unselectedIconName, String buttonLabel, ActionListener listener, String toolTipLabel, T button) throws InvalidPathException {
        ClassLoader loader = this.getClass().getClassLoader();
        ImageIcon unselectedIcon = UITools.createImageIcon(loader, "icons/" + unselectedIconName + ".png");
        ImageIcon selectedIcon = UITools.createImageIcon(loader, "icons/" + selectedIconName + ".png");
        ((AbstractButton)button).setIcon(unselectedIcon);
        ((AbstractButton)button).setSelectedIcon(selectedIcon);
        if (unselectedIcon.getIconWidth() < 10) {
            ((AbstractButton)button).setText(buttonLabel);
        }
        ((JComponent)button).setOpaque(false);
        ((AbstractButton)button).addActionListener(listener);
        ((JComponent)button).setToolTipText(toolTipLabel);
        return button;
    }

    private void setSelected(T button, boolean selected) {
        ((JComponent)button).setBorder(selected ? this.selectBorder : this.unselectBorder);
        ((AbstractButton)button).setSelected(selected);
    }

    public void setSelected(T pressedButton) {
        Iterator<T> iterator = this.getButtons().iterator();
        while (iterator.hasNext()) {
            JButton button;
            this.setSelected(button, (button = (JButton)iterator.next()) == pressedButton);
        }
    }
}

