/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.ui.panel;

import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.homelinux.elabor.tools.IntIterator;
import org.homelinux.elabor.tools.MessageCatalog;
import org.homelinux.elabor.ui.GenericSelectionModel;
import org.homelinux.elabor.ui.Selector;
import org.homelinux.elabor.ui.UITools;

public abstract class ListArea<T extends Serializable>
extends JPanel
implements ActionListener,
ListSelectionListener,
MouseListener,
Selector {
    static final long serialVersionUID = 1L;
    private GenericSelectionModel<T> listModel;
    private boolean shiftDown;
    private JButton addButton;
    private JButton editButton;
    private JButton removeButton;
    private JList<T> list;
    private String addLabel;
    private String addTooltip;
    private String editLabel;
    private String editTooltip;
    private String removeLabel;
    private String removeTooltip;
    private int[] selectedIndices;

    public ListArea() {
        this(true, true, true);
    }

    public ListArea(boolean showAddButton, boolean showEditButton, boolean showRemButton) {
        this.initLocale();
        this.list = new JList();
        this.list.addListSelectionListener(this);
        this.list.addMouseListener(this);
        JScrollPane scrollArea = new JScrollPane(this.list);
        this.selectedIndices = new int[0];
        this.setLayout(new GridBagLayout());
        UITools.addComponent(this, scrollArea, 1, 1, 1, 4, 100, 100, 1, 2);
        if (showAddButton) {
            this.addButton = UITools.setupButton(this.addLabel, this.addTooltip, this, true);
            UITools.addComponent(this, this.addButton, 2, 1, 1, 1, 0, 100, 2, 2);
        }
        if (showEditButton) {
            this.editButton = UITools.setupButton(this.editLabel, this.editTooltip, this, false);
            UITools.addComponent(this, this.editButton, 2, 2, 1, 1, 0, 100, 2, 2);
        }
        if (showRemButton) {
            this.removeButton = UITools.setupButton(this.removeLabel, this.removeTooltip, this, false);
            UITools.addComponent(this, this.removeButton, 2, 3, 1, 1, 0, 100, 2, 2);
        }
    }

    private void initLocale() {
        MessageCatalog catalog = new MessageCatalog();
        catalog.loadCatalog(ListArea.class.getName());
        this.addLabel = catalog.translate("add_label");
        this.addTooltip = catalog.translate("add_tooltip");
        this.editLabel = catalog.translate("edit_label");
        this.editTooltip = catalog.translate("edit_tooltip");
        this.removeLabel = catalog.translate("remove_label");
        this.removeTooltip = catalog.translate("remove_tooltip");
    }

    public void setFontSize(float size) {
        Font font = this.getFont();
        font = font.deriveFont(size);
        this.list.setFont(font);
    }

    public void setCellRenderer(ListCellRenderer<Object> renderer) {
        this.list.setCellRenderer(renderer);
    }

    public void setup(GenericSelectionModel<T> listModel) {
        this.listModel = listModel;
        this.list.setModel(listModel);
    }

    public void setup(GenericSelectionModel<T> listModel, T listElement) {
        this.setup(listModel);
        if (listElement != null) {
            listModel.setSelectedItem(listElement);
        }
    }

    public GenericSelectionModel<T> getModel() {
        return this.listModel;
    }

    public abstract void addAction();

    public abstract void remAction(int var1, T var2);

    public abstract void editAction(int var1, T var2);

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.addButton) {
            this.addAction();
        } else {
            int index = this.list.getSelectedIndex();
            if (index >= 0) {
                Serializable item = (Serializable)this.listModel.get(index);
                if (source == this.editButton) {
                    this.editAction(index, item);
                } else if (source == this.removeButton) {
                    this.remAction(index, item);
                }
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
        this.valueChanged(true);
    }

    public void valueChanged(boolean notify) {
        int[] indices = this.list.getSelectedIndices();
        if (this.editButton != null) {
            this.editButton.setEnabled(indices.length > 0);
        }
        if (this.removeButton != null) {
            this.removeButton.setEnabled(indices.length > 0);
        }
        if (notify) {
            this.listModel.selectionChanged(indices);
        }
    }

    @Override
    public int getSelectedIndex() {
        int[] indices = this.getSelectedIndices();
        return indices.length == 1 ? indices[0] : -1;
    }

    @Override
    public int[] getSelectedIndices() {
        return this.selectedIndices;
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        int index = this.findItemIndex(event);
        T item = this.getItem(index);
        if (item != null) {
            if (event.getClickCount() == 2) {
                this.editAction(index, item);
            } else if (this.shiftDown) {
                this.listModel.addSelectedItem(item, false);
            }
        }
    }

    public int findItemIndex(MouseEvent event) {
        Object source = event.getSource();
        int index = -1;
        if (source == this.list) {
            Point point = event.getPoint();
            index = this.list.locationToIndex(point);
        }
        return index;
    }

    public T getItem(int index) {
        Serializable item = null;
        if (index >= 0) {
            item = (Serializable)this.listModel.get(index);
        }
        return (T)item;
    }

    @Override
    public void mouseEntered(MouseEvent event) {
        this.setShiftDown(event);
    }

    private void setShiftDown(MouseEvent event) {
        if (event.getButton() == 1) {
            this.shiftDown = event.isShiftDown();
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
        this.setShiftDown(event);
    }

    @Override
    public void mouseReleased(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    public void contentsChanged(ListDataEvent e) {
        this.list.setSelectedIndex(e.getIndex0());
    }

    private void select(int index, boolean notify, List<Integer> selected) {
        if (!selected.contains(index)) {
            this.list.removeListSelectionListener(this);
            if (index >= 0) {
                selected.add(index);
                this.selectedIndices = IntIterator.toArray(selected);
                this.list.setSelectedIndices(this.selectedIndices);
                this.list.ensureIndexIsVisible(index);
            } else {
                this.list.clearSelection();
                this.selectedIndices = new int[0];
            }
            this.list.addListSelectionListener(this);
            this.valueChanged(notify);
        }
    }

    private void unselect(int index, boolean notify, List<Integer> selected) {
        if (selected.contains(index)) {
            this.list.removeListSelectionListener(this);
            if (index >= 0) {
                selected.remove((Object)index);
                this.selectedIndices = IntIterator.toArray(selected);
                this.list.setSelectedIndices(this.selectedIndices);
            } else {
                this.list.clearSelection();
                this.selectedIndices = new int[0];
            }
            this.list.addListSelectionListener(this);
            this.valueChanged(notify);
        }
    }

    @Override
    public void setSelectedIndex(int index, boolean notify) {
        ArrayList<Integer> selected = new ArrayList<Integer>();
        this.select(index, notify, selected);
    }

    @Override
    public void setSelectedIndices(int[] indices, boolean notify) {
        this.list.removeListSelectionListener(this);
        this.selectedIndices = indices;
        this.list.setSelectedIndices(this.selectedIndices);
        if (indices.length > 0) {
            this.list.ensureIndexIsVisible(indices[0]);
        }
        this.list.addListSelectionListener(this);
        this.valueChanged(notify);
    }

    @Override
    public void addSelectedIndex(int index, boolean notify) {
        List<Integer> selected = IntIterator.toList(this.selectedIndices);
        this.select(index, notify, selected);
    }

    @Override
    public void removeSelectedIndex(int index, boolean notify) {
        List<Integer> selected = IntIterator.toList(this.selectedIndices);
        this.unselect(index, notify, selected);
    }

    @Override
    public void unselectAll() {
        this.setSelectedIndices(new int[0], true);
    }

    public boolean closing() {
        return true;
    }
}

