/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.ui.tree;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.homelinux.elabor.ui.tree.InternalException;
import org.homelinux.elabor.ui.tree.TreeNodeTransferable;

public class JTreeHelper {
    private JTreeHelper() {
    }

    public static JTree getTree(Component component) {
        return (JTree)component;
    }

    public static DefaultMutableTreeNode getDropNode(TransferHandler.TransferSupport support) {
        JTree.DropLocation location = (JTree.DropLocation)support.getDropLocation();
        TreePath path = location.getPath();
        return (DefaultMutableTreeNode)path.getLastPathComponent();
    }

    public static DefaultMutableTreeNode getSelectedNode(JComponent component) {
        JTree tree = JTreeHelper.getTree(component);
        return JTreeHelper.getSelectedNode(tree);
    }

    public static DefaultMutableTreeNode getSelectedNode(JTree tree) {
        return (DefaultMutableTreeNode)tree.getLastSelectedPathComponent();
    }

    public static DefaultMutableTreeNode getDragNode(TransferHandler.TransferSupport support, Class<?> objectClass) {
        Transferable transferable = support.getTransferable();
        return JTreeHelper.getDragNode(transferable, objectClass);
    }

    public static DefaultMutableTreeNode getDragNode(Transferable transferable, Class<?> objectClass) {
        DefaultMutableTreeNode node;
        try {
            DataFlavor dataFlavor = TreeNodeTransferable.getDataFlavor(objectClass);
            Object object = transferable.getTransferData(dataFlavor);
            node = new DefaultMutableTreeNode(object);
        }
        catch (Exception e) {
            throw new InternalException(e);
        }
        return node;
    }

    public static Transferable createTransferable(JComponent component, Class<?> objectClass) {
        JTree tree = JTreeHelper.getTree(component);
        TreePath path = tree.getSelectionPath();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        Object userObject = node.getUserObject();
        return new TreeNodeTransferable(objectClass, userObject);
    }
}

