/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.ui.window;

import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.swing.JButton;
import org.homelinux.elabor.tools.MessageCatalog;
import org.homelinux.elabor.ui.UITools;
import org.homelinux.elabor.ui.panel.DefaultPanel;
import org.homelinux.elabor.ui.window.DefaultWindowAdaptable;

public class DefaultWindowAdaptor<M, P extends DefaultPanel<M>>
implements ActionListener,
Serializable {
    private static final long serialVersionUID = 1L;
    private P panel;
    private DefaultWindowAdaptable adaptable;

    public DefaultWindowAdaptor(P panel, DefaultWindowAdaptable adaptable) {
        this.panel = panel;
        this.adaptable = adaptable;
        MessageCatalog catalog = new MessageCatalog();
        catalog.loadCatalog(panel.getClass().getName());
        adaptable.setTitle(catalog.translate("titleString"));
        JButton okButton = new JButton(catalog.translate("okString"));
        okButton.setToolTipText(catalog.translate("okTooltip"));
        okButton.addActionListener(this);
        Container content = adaptable.getContentPane();
        content.setLayout(new GridBagLayout());
        UITools.addComponent(content, this.panel, 0, 0, 1, 1, 100, 100, 1, 2);
        UITools.addComponent(content, okButton, 0, 1, 1, 1, 1, 1, 0, 2);
        adaptable.getRootPane().setDefaultButton(okButton);
    }

    public P getPanel() {
        return this.panel;
    }

    public void setup(M itemManager) {
        ((DefaultPanel)this.panel).setup(itemManager);
        this.adaptable.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (((DefaultPanel)this.panel).okAction()) {
            if (this.adaptable.getDefaultCloseOperation() == 2) {
                this.adaptable.dispose();
            } else {
                this.adaptable.setVisible(false);
            }
        }
    }
}

