/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.common.config;

import biz.elabor.prebilling.common.config.BasicPrebillingConfiguration;
import biz.elabor.prebilling.common.config.Sequence;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.InvalidPropertiesFormatException;
import java.util.List;
import java.util.Properties;
import org.homelinux.elabor.calendar.ElaborCalendar;
import org.homelinux.elabor.db.DbmsType;
import org.homelinux.elabor.tools.StringUtils;

public class BasicFileConfiguration
implements BasicPrebillingConfiguration {
    protected final File mainFolder;
    protected final Properties properties;

    public BasicFileConfiguration(File mainFolder, List<File> configFiles, String version) throws InvalidPropertiesFormatException, IOException {
        this.mainFolder = mainFolder;
        this.properties = new Properties();
        for (File file : configFiles) {
            Throwable throwable = null;
            Object var7_8 = null;
            try (FileInputStream stream = new FileInputStream(file);){
                this.properties.loadFromXML(stream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        this.properties.put("version", version);
    }

    @Override
    public String getVersion() {
        return this.properties.getProperty("version");
    }

    @Override
    public String getGiadaHost() {
        return this.properties.getProperty("giada.dbHost");
    }

    @Override
    public DbmsType getGiadaType() {
        return DbmsType.valueOf(this.properties.getProperty("giada.dbType"));
    }

    @Override
    public String getGiadaDbName() {
        return this.properties.getProperty("giada.dbName");
    }

    @Override
    public String getGiadaDbUser() {
        return this.properties.getProperty("giada.dbUser");
    }

    @Override
    public String getGiadaDbPassword() {
        return this.properties.getProperty("giada.dbPass");
    }

    @Override
    public String getMisureHost() {
        return this.properties.getProperty("misure.dbHost");
    }

    @Override
    public DbmsType getMisureType() {
        return DbmsType.valueOf(this.properties.getProperty("misure.dbType"));
    }

    @Override
    public String getMisureDbName() {
        return this.properties.getProperty("misure.dbName");
    }

    @Override
    public String getMisureDbUser() {
        return this.properties.getProperty("misure.dbUser");
    }

    @Override
    public String getMisureDbPassword() {
        return this.properties.getProperty("misure.dbPass");
    }

    @Override
    public Date getToDay() {
        Date toDay;
        String toDayString = this.properties.getProperty("today");
        if (toDayString == null) {
            toDay = new Date();
        } else {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            try {
                toDay = dateFormat.parse(toDayString);
            }
            catch (ParseException exc) {
                throw new RuntimeException(exc);
            }
        }
        return toDay;
    }

    @Override
    public String getIdEsecuzione(String prefix, Sequence sequence) {
        String idEsecuzione = this.properties.getProperty("identificativo.esecuzione", null);
        if (idEsecuzione == null) {
            idEsecuzione = String.valueOf(prefix) + "-" + sequence.getNextValue();
        }
        return idEsecuzione;
    }

    @Override
    public boolean isLogMemory() {
        return this.properties.getProperty("log.memory", "false").equalsIgnoreCase("true");
    }

    protected File getFolder(String name, String defaultValue) {
        String path = this.properties.getProperty(name);
        File folder = path == null ? new File(this.mainFolder, defaultValue) : new File(path);
        folder.mkdirs();
        return folder;
    }

    @Override
    public File getTmpFolder() {
        return this.getFolder("tmp.folder", "tmp");
    }

    @Override
    public File getCodaFolder() {
        return this.getFolder("code.output.folder", "coda");
    }

    @Override
    public File getResellerOutputFolder(String id) {
        String defaultValue;
        String folderId;
        if (StringUtils.isEmpty(id) || id.equals("*")) {
            folderId = "output.folder";
            defaultValue = "no-reseller";
        } else {
            folderId = "reseller.output.folder." + id;
            defaultValue = "reseller-" + id;
        }
        return this.getFolder(folderId, defaultValue);
    }

    protected double getDouble(String name, String defaultValue) {
        String value = this.properties.getProperty(name, defaultValue);
        return Double.parseDouble(value);
    }

    protected boolean getBoolean(String name, String defaultValue) {
        String value = this.properties.getProperty(name, defaultValue);
        return Boolean.parseBoolean(value);
    }

    @Override
    public Date getTimeout(int ritardo) {
        Date toDay = this.getToDay();
        ElaborCalendar calendar = new ElaborCalendar(toDay);
        calendar.addGiorni(-ritardo);
        return calendar.getDate();
    }

    @Override
    public int getLunghezzaMatricola() {
        String value = this.properties.getProperty("lunghezza.matricola", "20");
        return Integer.parseInt(value);
    }

    @Override
    public int getCifreTariffe() {
        String value = this.properties.getProperty("cifre.tariffe", "8");
        return Integer.parseInt(value);
    }

    public String getCdmeslet(String flusso, List<String> idFlussi, String defaultValue) {
        String cdmeslet = null;
        for (String idFlusso : idFlussi) {
            if (!flusso.toLowerCase().startsWith(idFlusso.toLowerCase())) continue;
            cdmeslet = this.properties.getProperty("cdmes" + idFlusso, defaultValue);
            break;
        }
        return cdmeslet;
    }

    @Override
    public double getTolleranzaPrezzi() {
        return this.getDouble("tolleranza.prezzi", "0");
    }

    @Override
    public boolean isCheckPrezzi() {
        return this.getBoolean("check.prezzi", "true");
    }
}

