/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.common.dao;

import biz.elabor.prebilling.common.dao.BasicRecordCreatorHelper;
import biz.elabor.prebilling.common.model.BasicContratto;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.Date;
import org.homelinux.elabor.db.RecordCreator;

public class BasicContrattoCreator
implements RecordCreator<BasicContratto> {
    private final DateFormat dateFormat;
    private final boolean modello;

    public BasicContrattoCreator(boolean modello) {
        this.modello = modello;
        this.dateFormat = BasicRecordCreatorHelper.getDateFormat();
    }

    @Override
    public BasicContratto createRecord(ResultSet rs) throws SQLException {
        String codice = rs.getString("cdprerif").trim();
        String azienda = rs.getString("cdazirif").trim();
        Date dataInizio = BasicRecordCreatorHelper.getDate(rs, "inizio", this.dateFormat);
        Date dataFine = BasicRecordCreatorHelper.getDate(rs, "fine", this.dateFormat);
        Date dataValidita = BasicRecordCreatorHelper.getDate(rs, "dtvalidi", this.dateFormat);
        Date dataSospensione = BasicRecordCreatorHelper.getDate(rs, "dtsospen", this.dateFormat);
        String cdconmag = this.modello ? rs.getString("cdconmag").trim() : null;
        return new BasicContratto(codice, azienda, dataInizio, dataFine, dataValidita, dataSospensione, cdconmag);
    }
}

