/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.gas.config;

import biz.elabor.prebilling.common.config.BasicFileConfiguration;
import biz.elabor.prebilling.gas.config.PrebillingGasConfiguration;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.InvalidPropertiesFormatException;
import java.util.List;

public class FileGasConfiguration
extends BasicFileConfiguration
implements PrebillingGasConfiguration {
    private static final List<String> ID_FLUSSI = Arrays.asList("rgl", "letG", "tmv", "rmv", "rcd");

    public FileGasConfiguration(File folder, String fileName, String version) throws InvalidPropertiesFormatException, IOException {
        this(folder, Arrays.asList(new File(folder, fileName)), version);
    }

    public FileGasConfiguration(File mainFolder, List<File> configFiles, String version) throws InvalidPropertiesFormatException, IOException {
        super(mainFolder, configFiles, version);
    }

    @Override
    public double getInpcsAcquisto() {
        return this.getDouble("inpcs.acquisto", "38.1");
    }

    @Override
    public String getPrezziBaseUrl() {
        return this.properties.getProperty("url.prezzi.gas");
    }

    @Override
    public String getDirettiBaseUrl() {
        return this.properties.getProperty("url.diretti.gas");
    }

    @Override
    public String getResellerOutputLettureFolderName() {
        return this.properties.getProperty("reseller.output.letture.gas", "letture");
    }

    @Override
    public boolean checkGiroContatore() {
        return this.getBoolean("check.girocontatore", "false");
    }

    @Override
    public String getCdmeslet(String flusso, String defaultValue) {
        String cdmeslet = this.getCdmeslet(flusso, ID_FLUSSI, defaultValue);
        if (cdmeslet == null) {
            cdmeslet = defaultValue;
        }
        return cdmeslet;
    }

    @Override
    public double getTolleranzaConsumo() {
        return this.getDouble("tolleranza.consumo", "5");
    }

    @Override
    public File getConsumiOutputFolder(String azienda) {
        File parentFolder = this.getResellerOutputFolder(azienda);
        File folder = new File(parentFolder, "consumi");
        folder.mkdirs();
        return folder;
    }
}

