/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.gas.dao.misure.model;

import biz.elabor.prebilling.gas.dao.misure.model.InvalidDataValue;

public enum TipoLettura {
    EFFETTIVA("E"),
    STIMA("S"),
    AUTOLETTURA("A");

    private final String codice;

    private TipoLettura(String codice) {
        this.codice = codice;
    }

    public String getCodice() {
        return this.codice;
    }

    public static TipoLettura build(String codice) throws InvalidDataValue {
        TipoLettura[] tipoLetturaArray = TipoLettura.values();
        int n2 = tipoLetturaArray.length;
        int n3 = 0;
        while (n3 < n2) {
            TipoLettura tipo = tipoLetturaArray[n3];
            if (tipo.getCodice().equals(codice)) {
                return tipo;
            }
            ++n3;
        }
        throw new InvalidDataValue(codice, "tipo lettura");
    }

    public boolean isEffettiva() {
        return this == EFFETTIVA;
    }

    public boolean isStimata() {
        return this == STIMA;
    }
}

